/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.security.user;

import aQute.bnd.annotation.ProviderType;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesComposite;
import com.adobe.granite.security.user.UserPropertiesFilter;
import java.security.Principal;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.commons.osgi.PropertiesUtil;

@ProviderType
public interface UserPropertiesManager {
    public static final String JCR_TITLE = "{http://www.jcp.org/jcr/1.0}title";
    public static final String GRANITE_RANKING = "granite:ranking";
    public static final int DEFAULT_RANKING = 1000;
    public static final Comparator<Node> DESCENDING_RANKING_COMPARATOR = new Comparator<Node>(){

        @Override
        public int compare(Node p1, Node p2) {
            try {
                return this.ranking(p1) - this.ranking(p2);
            }
            catch (RepositoryException e) {
                return 0;
            }
        }

        private int ranking(Node p) throws RepositoryException {
            if (p.hasProperty(UserPropertiesManager.GRANITE_RANKING)) {
                return PropertiesUtil.toInteger(p.getProperty(UserPropertiesManager.GRANITE_RANKING).getLong(), 1000);
            }
            return 1000;
        }
    };

    public UserProperties createUserProperties(String var1, String var2) throws RepositoryException;

    public UserProperties getUserProperties(String var1, String var2) throws RepositoryException;

    public UserProperties getUserProperties(Authorizable var1, String var2) throws RepositoryException;

    public UserProperties getUserProperties(Node var1) throws RepositoryException;

    public UserPropertiesComposite getUserPropertiesComposite(String var1, String[] var2) throws RepositoryException;

    public UserPropertiesComposite getUserPropertiesComposite(String var1, UserPropertiesFilter var2) throws RepositoryException;

    @Nonnull
    public UserPropertiesComposite getUserPropertiesComposite(@Nonnull String var1, @Nullable String var2) throws RepositoryException;

    @Nonnull
    public UserPropertiesComposite getUserPropertiesComposite(@Nonnull String var1, @Nullable String var2, @Nonnull Comparator<Node> var3) throws RepositoryException;

    public Iterator<UserProperties> getMemberOfUserProperties(String var1, String var2, boolean var3) throws RepositoryException;

    public Iterator<UserProperties> getMemberUserProperties(Group var1, String var2, boolean var3) throws RepositoryException;

    public boolean addReaders(@Nonnull UserProperties var1, Principal ... var2) throws RepositoryException;

    public boolean removeReaders(@Nonnull UserProperties var1, Principal ... var2) throws RepositoryException;
}

