/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.security.user.util;

import com.adobe.granite.security.user.util.AuthorizableUtil;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizableFilterPredicate
implements Predicate {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizableFilterPredicate.class);
    private String filter;
    private Pattern filterPattern;

    public AuthorizableFilterPredicate(String filter) {
        if (!StringUtils.isBlank((CharSequence)filter)) {
            this.filter = filter;
            this.filterPattern = this.generateFilterPattern();
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean evaluate(Object object) {
        if (this.filter == null) {
            return true;
        }
        if (object instanceof Authorizable) {
            Authorizable authorizable = (Authorizable)object;
            try {
                String authorizableID = authorizable.getID();
                String authorizableName = AuthorizableUtil.getName(authorizable);
                boolean isMatching = false;
                if (authorizableID != null) {
                    isMatching = this.filterPattern.matcher(authorizableID).matches();
                }
                if (authorizableName != null) {
                    isMatching = isMatching || this.filterPattern.matcher(authorizableName).matches();
                }
                return isMatching;
            }
            catch (RepositoryException e) {
                LOG.error("Error while accessing authorizable" + authorizable + " properties:", (Throwable)e);
            }
        }
        return false;
    }

    private Pattern generateFilterPattern() {
        String filterRegex = this.filter.replaceAll("%+", "%");
        String[] tokens = filterRegex.split("%");
        StringBuilder sanitizedRegex = new StringBuilder();
        for (String token : tokens) {
            if (!token.isEmpty()) {
                sanitizedRegex.append(Pattern.quote(token));
            }
            sanitizedRegex.append(".*");
        }
        if (!filterRegex.endsWith("%")) {
            int length = sanitizedRegex.length();
            sanitizedRegex.delete(length - 2, length);
        }
        return Pattern.compile(sanitizedRegex.toString());
    }
}

