/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.clientlibs.script;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Binary;
import javax.jcr.Property;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static Pattern SCHEME_START = Pattern.compile("^[^:/]+:[^/]*/.*");
    private static Pattern URL_PATTERN = Pattern.compile("url\\(\\s*(['\"]?)([^'\")]*)(['\"]?\\s*)\\)");

    private Utils() {
    }

    public static String rewriteUrlsInCss(String libPath, String filePath, String css) {
        return Utils.rewriteUrlsInCss(Text.explode(libPath, 47), Text.explode(filePath, 47), css, null, 0L);
    }

    public static String rewriteUrlsInCss(String libPath, String filePath, String css, Session session, long maxDataUriSize) {
        return Utils.rewriteUrlsInCss(Text.explode(libPath, 47), Text.explode(filePath, 47), css, session, maxDataUriSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String rewriteUrlsInCss(String[] libPathSegs, String[] filePathSegs, String css, Session session, long maxDataUriSize) {
        Matcher m = URL_PATTERN.matcher(css);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            String url = m.group(2);
            if (url.startsWith("absolute:")) {
                url = url.substring(9);
            } else if (!url.endsWith(".htc") && !url.startsWith("//")) {
                url = Utils.resolveUrl(libPathSegs, filePathSegs, url);
                if (maxDataUriSize > 0L && session != null && !SCHEME_START.matcher(url).matches()) {
                    Binary bin = null;
                    String path = "/" + Text.implode(libPathSegs, "/") + "/../" + url + "/jcr:content/jcr:data";
                    try {
                        Property p;
                        if (session.propertyExists(path) && (p = session.getProperty(path)).getLength() < maxDataUriSize) {
                            bin = p.getBinary();
                            StringWriter w = new StringWriter();
                            Base64.encode(bin.getStream(), w);
                            url = "data:" + p.getParent().getProperty("{http://www.jcp.org/jcr/1.0}mimeType").getString() + ";base64," + w.toString();
                        }
                    }
                    catch (Exception e) {
                        log.warn("Error while encoding data uri of {}: {}", (Object)path, (Object)e.toString());
                    }
                    finally {
                        if (bin != null) {
                            bin.dispose();
                        }
                    }
                }
            }
            m.appendReplacement(result, "url($1" + url + "$3)");
        }
        m.appendTail(result);
        return result.toString();
    }

    public static String resolveUrl(String libPath, String filePath, String url) {
        return Utils.resolveUrl(Text.explode(libPath, 47), Text.explode(filePath, 47), url);
    }

    private static String resolveUrl(String[] libPath, String[] filePath, String url) {
        int i;
        if (url.length() == 0 || SCHEME_START.matcher(url).matches()) {
            if (log.isDebugEnabled()) {
                log.debug("resolving lib=/{}, file=/{}, url={} (ignored)", new Object[]{Text.implode(libPath, "/"), Text.implode(filePath, "/"), url});
            }
            return url;
        }
        LinkedList<String> file = new LinkedList<String>();
        if (!url.startsWith("/")) {
            file.addAll(Arrays.asList(filePath));
            file.removeLast();
        }
        boolean warned = false;
        for (String seg : Text.explode(url, 47)) {
            if ("..".equals(seg)) {
                if (file.isEmpty()) {
                    if (warned) continue;
                    log.warn("/{}: url('{}') invalid. too many '..'", (Object)Text.implode(filePath, "/"), (Object)url);
                    warned = true;
                    continue;
                }
                file.removeLast();
                continue;
            }
            if (".".equals(seg)) continue;
            file.add(seg);
        }
        for (i = 0; i < libPath.length - 1 && libPath[i].matches((String)file.getFirst()); ++i) {
            file.removeFirst();
        }
        while (i++ < libPath.length - 1) {
            file.addFirst("..");
        }
        StringBuilder ret = new StringBuilder();
        String delim = "";
        for (String seg : file) {
            ret.append(delim).append(seg);
            delim = "/";
        }
        if (log.isDebugEnabled()) {
            log.debug("resolving lib=/{}, file=/{}, url={} -> {}", new Object[]{Text.implode(libPath, "/"), Text.implode(filePath, "/"), url, ret});
        }
        return ret.toString();
    }
}

