/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.AttrBuilder;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.LayoutBuilder;
import com.adobe.granite.ui.components.State;
import com.adobe.granite.ui.components.Tag;
import com.adobe.granite.ui.components.Value;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.ResourceDataSource;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.scripting.jsp.util.JspSlingHttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentHelper {
    private static final String DEFAULT_LAYOUT_RT = "granite/ui/components/foundation/layouts/container";
    private static final String ATTRIBUTE_CACHE_RC = ComponentHelper.class.getName() + ".cache.rc";
    private PageContext pageContext;
    private SlingScriptHelper sling;
    private SlingHttpServletRequest request;
    private I18n i18n;
    private XSSAPI xss;
    private Config config;
    private Value value;
    private ExpressionHelper ex;
    private State state;
    private OptionsHolder optionsHolder;

    public ComponentHelper(PageContext pageContext) {
        this.pageContext = pageContext;
        SlingBindings bindings = (SlingBindings)pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        this.request = bindings.getRequest();
        this.sling = bindings.getSling();
        this.optionsHolder = (OptionsHolder)this.request.getAttribute(OptionsHolder.class.getName());
        this.request.removeAttribute(OptionsHolder.class.getName());
    }

    public I18n getI18n() {
        if (this.i18n == null) {
            this.i18n = new I18n(this.request);
        }
        return this.i18n;
    }

    public XSSAPI getXss() {
        if (this.xss == null) {
            this.xss = this.sling.getService(XSSAPI.class).getRequestSpecificAPI(this.request);
        }
        return this.xss;
    }

    public Config getConfig() {
        if (this.config == null) {
            this.config = new Config(this.request.getResource());
        }
        return this.config;
    }

    public Value getValue() {
        if (this.value == null) {
            this.value = new Value(this.request, this.getConfig());
        }
        return this.value;
    }

    public ExpressionHelper getExpressionHelper() {
        if (this.ex == null) {
            this.ex = new ExpressionHelper(this.sling.getService(ExpressionResolver.class), this.pageContext);
        }
        return this.ex;
    }

    public State getState() {
        if (this.state == null) {
            this.state = new State(this.request);
        }
        return this.state;
    }

    public Tag consumeTag() {
        Tag tag = this.getOptions().tag();
        return tag == null ? new Tag(new AttrBuilder(this.request, this.getXss())) : tag;
    }

    public Resource consumeLayoutResource() {
        Resource layout = this.getOptions().layoutResource();
        return layout == null ? this.request.getResource().getChild(Config.LAYOUT) : layout;
    }

    public void populateCommonAttrs(AttrBuilder attrs) {
        this.populateCommonAttrs(attrs, this.request.getResource());
    }

    public void populateCommonAttrs(AttrBuilder attrs, Resource src) {
        I18n i18n = this.getI18n();
        Config config = new Config(src);
        ExpressionHelper ex = this.getExpressionHelper();
        attrs.add("id", ex.getString(config.get("granite:id", String.class)));
        attrs.addRel(ex.getString(config.get("granite:rel", String.class)));
        attrs.addClass(ex.getString(config.get("granite:class", String.class)));
        attrs.add("title", i18n.getVar(config.get("granite:title", String.class)));
        attrs.addBoolean("hidden", config.get("granite:hidden", false));
        attrs.addBoolean("itemscope", config.get("granite:itemscope", false));
        attrs.add("itemtype", config.get("granite:itemtype", String.class));
        attrs.add("itemprop", config.get("granite:itemprop", String.class));
        Resource data = src.getChild("granite:data");
        if (data == null) {
            return;
        }
        for (Map.Entry e : data.getValueMap().entrySet()) {
            String key = (String)e.getKey();
            if (key.indexOf(":") >= 0) continue;
            Object v = e.getValue();
            if (v instanceof String) {
                v = ex.getString(v.toString());
            }
            attrs.addOther(key, v.toString());
        }
    }

    public Options getOptions() {
        if (this.optionsHolder != null && this.optionsHolder.getPath().equals(this.request.getResource().getPath())) {
            return this.optionsHolder.getOptions();
        }
        return new Options();
    }

    public LayoutBuilder getLayout() {
        return LayoutBuilder.from(this.consumeLayoutResource(), DEFAULT_LAYOUT_RT);
    }

    public String getReadOnlyResourceType() {
        return this.getReadOnlyResourceType(this.request.getResource());
    }

    public String getReadOnlyResourceType(Resource resource) {
        String resourceType = ComponentHelper.getResourceType(resource);
        if (resourceType == null) {
            return null;
        }
        Resource r = this.request.getResourceResolver().getResource(resourceType);
        if (r == null) {
            return null;
        }
        Resource ro = r.getChild("readonly");
        if (ro != null) {
            return ro.getPath();
        }
        return new Config(r).get("granite:readOnlyResourceType", String.class);
    }

    public DataSource getItemDataSource() throws ServletException, IOException {
        return this.getItemDataSource(this.request.getResource());
    }

    public DataSource getItemDataSource(Resource resource) throws ServletException, IOException {
        Resource items = resource.getChild(Config.ITEMS);
        if (items != null) {
            return new ResourceDataSource(items);
        }
        Resource datasource = resource.getChild(Config.DATASOURCE);
        if (datasource != null) {
            return this.asDataSource(datasource, resource);
        }
        return EmptyDataSource.instance();
    }

    public DataSource asDataSource(Resource datasource) throws ServletException, IOException {
        return this.asDataSource(datasource, null);
    }

    public DataSource asDataSource(Resource datasource, Resource context) throws ServletException, IOException {
        DataSource ds;
        if (datasource == null) {
            return null;
        }
        if (context == null) {
            context = datasource;
        }
        return (ds = this.fetchData(context, ComponentHelper.getResourceType(datasource), DataSource.class)) != null ? ds : EmptyDataSource.instance();
    }

    public RenderCondition getRenderCondition() throws ServletException, IOException {
        return this.getRenderCondition(this.request.getResource());
    }

    public RenderCondition getRenderCondition(Resource resource) throws ServletException, IOException {
        RenderCondition rc = null;
        Resource condition = resource.getChild("granite:rendercondition");
        if (condition == null) {
            condition = resource.getChild(Config.RENDERCONDITION);
        }
        if (condition != null) {
            String resourceType = ComponentHelper.getResourceType(condition, "granite/ui/components/foundation/renderconditions/simple");
            rc = this.fetchData(condition, resourceType, RenderCondition.class);
        }
        if (rc == null) {
            rc = SimpleRenderCondition.TRUE;
        }
        return rc;
    }

    public RenderCondition getRenderCondition(Resource resource, boolean cache) throws ServletException, IOException {
        String key;
        Map<String, RenderCondition> cacheMap = this.getRenderConditionCache();
        RenderCondition rc = cacheMap.get(key = resource.getPath());
        if (rc != null) {
            return rc;
        }
        Resource condition = resource.getChild("granite:rendercondition");
        if (condition != null) {
            rc = this.fetchData(condition, ComponentHelper.getResourceType(condition), RenderCondition.class);
        }
        if (rc == null) {
            rc = SimpleRenderCondition.TRUE;
        }
        if (cache) {
            cacheMap.put(key, rc);
        }
        return rc;
    }

    private Map<String, RenderCondition> getRenderConditionCache() {
        HashMap cache = (HashMap)this.request.getAttribute(ATTRIBUTE_CACHE_RC);
        if (cache == null) {
            cache = new HashMap();
            this.request.setAttribute(ATTRIBUTE_CACHE_RC, cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T fetchData(Resource resource, String resourceType, Class<T> type) throws ServletException, IOException {
        if (resourceType == null) {
            return null;
        }
        try {
            RequestDispatcher dispatcher = this.request.getRequestDispatcher(resource, new RequestDispatcherOptions(resourceType));
            if (dispatcher != null) {
                dispatcher.include((ServletRequest)this.request, (ServletResponse)new JspSlingHttpServletResponseWrapper(this.pageContext));
                Object object = this.request.getAttribute(type.getName());
                return (T)object;
            }
            T t = null;
            return t;
        }
        finally {
            this.request.removeAttribute(type.getName());
        }
    }

    public String getIconClass(String icon) {
        if (icon == null) {
            return null;
        }
        if (!icon.startsWith("icon-")) {
            return icon;
        }
        return "coral-Icon--" + ComponentHelper.toCamel(icon.substring(5));
    }

    private static String toCamel(String s) {
        String[] parts = s.split("-");
        StringBuilder b = new StringBuilder();
        b.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            b.append(parts[i].substring(0, 1).toUpperCase());
            b.append(parts[i].substring(1));
        }
        return b.toString();
    }

    private static String getResourceType(Resource resource) {
        return new Config(resource).get("sling:resourceType", String.class);
    }

    private static String getResourceType(Resource resource, String defaultValue) {
        return new Config(resource).get("sling:resourceType", defaultValue);
    }

    public void include(Resource resource, Tag tag) throws ServletException, IOException {
        this.include(resource, null, tag);
    }

    public void include(Resource resource, Options options) throws ServletException, IOException {
        this.include(resource, null, options);
    }

    public void include(Resource resource, String resourceType, Tag tag) throws ServletException, IOException {
        this.include(resource, resourceType, new Options().tag(tag));
    }

    public void include(Resource resource, String resourceType, Options options) throws ServletException, IOException {
        this.include(resource, resourceType, null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Resource resource, String resourceType, String selectors, Options options) throws ServletException, IOException {
        try {
            RequestDispatcher dispatcher;
            OptionsHolder holder = new OptionsHolder(options, resource.getPath());
            this.request.setAttribute(OptionsHolder.class.getName(), holder);
            RequestDispatcherOptions dispatcherOptions = new RequestDispatcherOptions(resourceType);
            if (selectors != null && selectors.length() > 0) {
                dispatcherOptions.setReplaceSelectors(selectors);
            }
            if ((dispatcher = this.request.getRequestDispatcher(resource, dispatcherOptions)) != null) {
                dispatcher.include((ServletRequest)this.request, (ServletResponse)new JspSlingHttpServletResponseWrapper(this.pageContext));
            }
        }
        finally {
            this.request.removeAttribute(OptionsHolder.class.getName());
        }
    }

    public void includeForLayout(Resource resource, Options options) throws ServletException, IOException {
        this.includeForLayout(resource, null, options);
    }

    public void includeForLayout(Resource resource, Resource layoutResource, Options options) throws ServletException, IOException {
        String resourceType = null;
        if (layoutResource == null) {
            Resource r = resource.getChild(Config.LAYOUT);
            if (r != null) {
                resourceType = ComponentHelper.getResourceType(r);
            }
        } else {
            resourceType = ComponentHelper.getResourceType(layoutResource);
            options.layoutResource(layoutResource);
        }
        if (resourceType == null) {
            resourceType = DEFAULT_LAYOUT_RT;
        }
        this.include(resource, resourceType, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(String script, Options options) throws ServletException, IOException {
        try {
            OptionsHolder holder = new OptionsHolder(options, this.request.getResource().getPath());
            this.request.setAttribute(OptionsHolder.class.getName(), holder);
            ServletResolver servletResolver = this.sling.getService(ServletResolver.class);
            Servlet servlet = servletResolver.resolveServlet(this.request.getResource(), script);
            if (servlet == null) {
                throw new ServletException("Could not find script " + script);
            }
            servlet.service((ServletRequest)this.request, (ServletResponse)new JspSlingHttpServletResponseWrapper(this.pageContext));
        }
        finally {
            this.request.removeAttribute(OptionsHolder.class.getName());
        }
    }

    public static class Options {
        private Tag tag;
        private boolean rootField = true;
        private Resource layout;

        public Tag tag() {
            return this.tag;
        }

        public Options tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public boolean rootField() {
            return this.rootField;
        }

        public Options rootField(boolean flag) {
            this.rootField = flag;
            return this;
        }

        public Resource layoutResource() {
            return this.layout;
        }

        public Options layoutResource(Resource r) {
            this.layout = r;
            return this;
        }
    }

    private class OptionsHolder {
        private Options options;
        private String path;

        public OptionsHolder(Options options, String path) {
            this.options = options;
            this.path = path;
        }

        public Options getOptions() {
            return this.options;
        }

        public String getPath() {
            return this.path;
        }
    }
}

