/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.CompositeValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private Resource resource;
    private ValueMap properties;
    private ValueMap propertiesWithParent;
    private Resource parentResource;
    public static String DEFAULTS = "defaults";
    public static String ITEMS = "items";
    public static String LAYOUT = "layout";
    public static String DATASOURCE = "datasource";
    public static String RENDERCONDITION = "rendercondition";

    public Config(Resource resource) {
        this(resource, false);
    }

    public Config(Resource resource, boolean inherit) {
        this.resource = resource;
        ValueMap valueMap = this.properties = resource != null ? resource.getValueMap() : new ValueMapDecorator(new HashMap<String, Object>());
        if (inherit) {
            this.parentResource = this.getParentResource();
            if (this.parentResource != null) {
                Resource defaults = this.parentResource.getChild(DEFAULTS);
                if (defaults != null) {
                    this.properties = new CompositeValueMap(this.properties, defaults.getValueMap());
                }
                this.propertiesWithParent = new CompositeValueMap(this.properties, this.parentResource.getValueMap());
            }
        }
    }

    public Config(Resource resource, ValueMap defaults, ValueMap parentProperties) {
        this.resource = resource;
        ValueMap prop = resource != null ? resource.getValueMap() : new ValueMapDecorator(new HashMap<String, Object>());
        this.properties = new CompositeValueMap(prop, defaults);
        this.propertiesWithParent = new CompositeValueMap(prop, parentProperties);
    }

    public String get(String name) {
        return this.get(name, "");
    }

    public <T> T get(String name, T defaultValue) {
        return this.properties.get(name, defaultValue);
    }

    public <T> T get(String name, Class<T> type) {
        return (T)this.properties.get(name, type);
    }

    public String getInherited(String name) {
        return this.getInherited(name, "");
    }

    public <T> T getInherited(String name, T defaultValue) {
        return this.propertiesWithParent.get(name, defaultValue);
    }

    public <T> T getInherited(String name, Class<T> type) {
        return (T)this.propertiesWithParent.get(name, type);
    }

    public String getInheritedDefault(String name) {
        return this.getInheritedDefault(name, "");
    }

    public <T> T getInheritedDefault(String name, T defaultValue) {
        return this.get(name, defaultValue);
    }

    public <T> T getInheritedDefault(String name, Class<T> type) {
        return this.get(name, type);
    }

    public ValueMap getDefaultProperties() {
        Resource defaults = this.resource.getChild(DEFAULTS);
        return defaults != null ? defaults.getValueMap() : new ValueMapDecorator(new HashMap<String, Object>());
    }

    public ValueMap getProperties() {
        return this.properties;
    }

    public Iterator<Resource> getItems() {
        return this.getItems(this.resource, ITEMS);
    }

    public Iterator<Resource> getItems(String name) {
        return this.getItems(this.resource, name);
    }

    public Iterator<Resource> getItems(Resource resource) {
        return this.getItems(resource, ITEMS);
    }

    public Iterator<Resource> getItems(Resource resource, String name) {
        Resource items;
        if (name == null || name.length() == 0) {
            name = ITEMS;
        }
        if ((items = resource.getChild(name)) != null) {
            return items.listChildren();
        }
        return Collections.emptyList().iterator();
    }

    public Resource getChild(String name) {
        return this.resource.getChild(name);
    }

    public Resource getParentResource() {
        if (this.parentResource != null) {
            return this.parentResource;
        }
        this.parentResource = this.resource.getParent();
        if ("nt:unstructured".equals(this.parentResource.getResourceType())) {
            this.parentResource = this.parentResource.getParent();
        }
        return this.parentResource;
    }
}

