/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import aQute.bnd.annotation.ProviderType;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.Value;
import javax.servlet.http.HttpServletRequest;

@ProviderType
public class Field {
    private Config cfg;
    public static String HIDE_IN_DEFAULT_CLASS = "foundation-field-hide-in-default";
    public static String IS_MIXED_SUFFIX = ".granite.mixed";
    private static final String BULK_EDIT_MODE_ATTRIBUTE = "granite.ui.field.bulkedit";

    public Field() {
    }

    public Field(Config cfg) {
        this.cfg = cfg;
    }

    public String getRootClass(boolean isEmpty) {
        return Field.getRootClass(this.cfg, isEmpty);
    }

    public String getRootClass(String value) {
        return Field.getRootClass(this.cfg, value);
    }

    public boolean isMixed(Value value) {
        return Field.isMixed(this.cfg, value);
    }

    public boolean isBulkEditAllowed() {
        return this.cfg.get("allowBulkEdit", false);
    }

    public static boolean isBulkEditMode(HttpServletRequest request) {
        Boolean isBulkEditMode = (Boolean)request.getAttribute(BULK_EDIT_MODE_ATTRIBUTE);
        return isBulkEditMode == null ? false : isBulkEditMode;
    }

    public static void setBulkEditMode(HttpServletRequest request) {
        request.setAttribute(BULK_EDIT_MODE_ATTRIBUTE, (Object)true);
    }

    public static void clearBulkEditMode(HttpServletRequest request) {
        request.removeAttribute(BULK_EDIT_MODE_ATTRIBUTE);
    }

    public static String getRootClass(Config cfg, boolean isEmpty) {
        String cls = "";
        if (isEmpty && cfg.get("renderReadOnly", false).booleanValue() && !cfg.get("showEmptyInReadOnly", false).booleanValue()) {
            cls = cls + HIDE_IN_DEFAULT_CLASS;
        }
        return cls;
    }

    public static String getRootClass(Config cfg, String value) {
        return Field.getRootClass(cfg, value == null || "".equals(value));
    }

    public static boolean isMixed(Config cfg, Value value) {
        String name = cfg.get("name") + IS_MIXED_SUFFIX;
        return value.getContentValue(name, false);
    }
}

