/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingIterator<E>
implements Iterator<E> {
    private Iterator<E> it;
    private Integer offset;
    private Integer limit;
    private int limitCounter = 0;

    public PagingIterator(Iterator<E> it, Integer offset, Integer limit) {
        this.it = it;
        this.offset = offset;
        this.limit = limit;
        if (offset != null && offset < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        if (limit != null && limit < 0) {
            throw new IllegalArgumentException("limit is negative");
        }
        this.doOffset();
    }

    private void doOffset() {
        if (this.offset == null) {
            return;
        }
        for (int i = 0; i < this.offset && this.it.hasNext(); ++i) {
            this.it.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.limit == null) {
            return this.it.hasNext();
        }
        return this.limitCounter < this.limit && this.it.hasNext();
    }

    @Override
    public E next() {
        E next = this.it.next();
        ++this.limitCounter;
        return next;
    }

    @Override
    public void remove() {
        this.it.remove();
    }
}

