/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.Config;
import java.util.Arrays;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Value {
    public static final String FORM_VALUESS_ATTRIBUTE = "granite.ui.form.values";
    public static final String CONTENTPATH_ATTRIBUTE = "granite.ui.form.contentpath";
    private Config config;
    private ValueMap values;

    public Value(SlingHttpServletRequest request, Config config) {
        Resource contentResource;
        String contentPath;
        this.config = config;
        this.values = (ValueMap)request.getAttribute(FORM_VALUESS_ATTRIBUTE);
        if (this.values == null && (contentPath = (String)request.getAttribute(CONTENTPATH_ATTRIBUTE)) != null && (contentResource = request.getResourceResolver().getResource(contentPath)) != null && !ResourceUtil.isNonExistingResource(contentResource)) {
            this.values = contentResource.getValueMap();
        }
    }

    public String get(String name) {
        return this.get(name, "");
    }

    public <T> T get(String name, T defaultValue) {
        if (this.values == null || this.config.get("ignoreData", false).booleanValue()) {
            return this.config.get("value", defaultValue);
        }
        return this.getContentValue(name, defaultValue);
    }

    public <T> T get(String name, Class<T> type) {
        if (this.values == null || this.config.get("ignoreData", false).booleanValue()) {
            return this.config.get("value", type);
        }
        return this.getContentValue(name, type);
    }

    public <T> T val(T defaultValue) {
        return this.val(this.config.get("name", String.class), defaultValue);
    }

    public <T> T val(String name, T defaultValue) {
        if (this.values == null || this.config.get("ignoreData", false).booleanValue()) {
            return defaultValue;
        }
        return this.getContentValue(name, defaultValue);
    }

    public boolean isSelected(String value, boolean defaultReturn) {
        return this.isSelected(this.config.get("name", String.class), value, defaultReturn);
    }

    public boolean isSelected(String name, String value, boolean defaultReturn) {
        if (this.values == null || this.config.get("ignoreData", false).booleanValue()) {
            return defaultReturn;
        }
        String[] contentValue = this.getContentValue(name, String[].class);
        if (contentValue != null) {
            if (value == null) {
                return false;
            }
            return Arrays.asList(contentValue).contains(value);
        }
        if (value == null) {
            return defaultReturn;
        }
        if (value.length() == 0) {
            return true;
        }
        return defaultReturn;
    }

    public String getContentValue(String name) {
        return this.getContentValue(name, "");
    }

    public <T> T getContentValue(String name, T defaultValue) {
        if (this.values == null || name == null) {
            return defaultValue;
        }
        return this.values.get(name, defaultValue);
    }

    public <T> T getContentValue(String name, Class<T> type) {
        if (this.values == null || name == null) {
            return null;
        }
        return (T)this.values.get(name, type);
    }
}

