/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.octopus.extract;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleExtractor {
    private static final String ROOT = ".octopus";
    private static final String VERSION_FILE = ".octopus/nativeCommExtractedVersions";
    private final Bundle bundle;
    private final File baseDir;

    public BundleExtractor(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle == null");
        }
        this.bundle = bundle;
        BundleContext context = this.getBundleContext();
        this.baseDir = context.getDataFile(ROOT);
        if (this.baseDir == null) {
            throw new IllegalArgumentException("the OSGi platform has no file system support");
        }
        this.baseDir.mkdir();
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(context.getServiceReference(PackageAdmin.class.getName()));
        try {
            if (this.resourcesNeedUpdate(packageAdmin)) {
                this.deleteDirectory(this.baseDir);
                this.baseDir.mkdir();
                this.updateVersionFile(packageAdmin);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public BundleExtractor(Class<?> clazz) {
        this(FrameworkUtil.getBundle(clazz));
    }

    public File extractResource(String path) throws IOException {
        File resolvedFile = this.getEntry(path);
        return resolvedFile;
    }

    public File extractExecutable(String path) throws IOException {
        File resolvedFile = this.getEntry(path);
        if (File.separatorChar == '/') {
            this.markExecutable(path, resolvedFile);
        }
        return resolvedFile;
    }

    private boolean deleteDirectory(File path) {
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDirectory(files[i]);
                continue;
            }
            files[i].delete();
        }
        return path.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resourcesNeedUpdate(PackageAdmin packageAdmin) throws IOException {
        boolean resourcesNeedUpdate = true;
        BundleContext context = this.getBundleContext();
        File versionFile = context.getDataFile(VERSION_FILE);
        if (versionFile.exists()) {
            Properties prop = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                prop.load(is);
                String hostBundleId = String.valueOf(this.bundle.getBundleId());
                resourcesNeedUpdate = !prop.containsKey(hostBundleId) || !this.bundle.getVersion().equals((Object)Version.parseVersion((String)prop.getProperty(hostBundleId)));
                Bundle[] fragments = null;
                if (packageAdmin != null) {
                    fragments = packageAdmin.getFragments(this.bundle);
                }
                if (fragments != null) {
                    if (prop.size() - 1 != fragments.length) {
                        resourcesNeedUpdate = true;
                    }
                    for (int i = 0; i + 1 < prop.size() && i < fragments.length && !resourcesNeedUpdate; ++i) {
                        String fragmentId = String.valueOf(fragments[i].getBundleId());
                        resourcesNeedUpdate = !prop.containsKey(fragmentId) || !fragments[i].getVersion().equals((Object)Version.parseVersion((String)prop.getProperty(fragmentId)));
                    }
                } else if (prop.size() > 1) {
                    resourcesNeedUpdate = true;
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return resourcesNeedUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionFile(PackageAdmin packageAdmin) throws IOException {
        Bundle[] fragments;
        Properties prop = new Properties();
        prop.setProperty(String.valueOf(this.bundle.getBundleId()), this.bundle.getVersion().toString());
        if (packageAdmin != null && (fragments = packageAdmin.getFragments(this.bundle)) != null) {
            for (Bundle fragment : fragments) {
                prop.setProperty(String.valueOf(fragment.getBundleId()), fragment.getVersion().toString());
            }
        }
        BundleContext context = this.getBundleContext();
        File versionFile = context.getDataFile(VERSION_FILE);
        FileOutputStream os = new FileOutputStream(versionFile);
        try {
            prop.store(os, null);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    private BundleContext getBundleContext() {
        BundleContext context = this.bundle.getBundleContext();
        if (context == null) {
            this.startBundle();
            context = this.bundle.getBundleContext();
            if (context == null) {
                throw new IllegalArgumentException("bundle '" + this.bundle + "' has no BundleContext." + "Either it is not active or a fragment bundle.");
            }
        }
        return context;
    }

    private File getEntry(String path) throws IOException {
        Enumeration entries = this.bundle.findEntries(path, null, true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                String entryPath = url.getPath();
                File target = new File(this.baseDir, entryPath);
                if (!entryPath.endsWith("/")) {
                    this.copyOut(url, target);
                    continue;
                }
                target.mkdirs();
            }
            File result = new File(this.baseDir, path);
            return result;
        }
        URL rootUrl = this.bundle.getResource(path);
        if (rootUrl == null) {
            throw new FileNotFoundException("'" + path + "' not found in Bundle " + this.bundle);
        }
        String rootPath = rootUrl.getPath();
        File result = new File(this.baseDir, rootPath);
        this.copyOut(rootUrl, result);
        return result;
    }

    private void copyOut(URL url, File target) throws IOException {
        if (!target.exists()) {
            target.getParentFile().mkdirs();
            InputStream in = url.openStream();
            FileOutputStream out = new FileOutputStream(target);
            BundleExtractor.copy(in, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream is, OutputStream os) throws IOException {
        long total = 0L;
        try {
            int read = 0;
            byte[] bytes = new byte[65536];
            while ((read = is.read(bytes)) != -1) {
                os.write(bytes, 0, read);
                total += (long)read;
            }
        }
        finally {
            BundleExtractor.safeClose(is);
            BundleExtractor.safeClose(os);
        }
        return total;
    }

    private void markExecutable(String path, File resolvedFile) throws IOException {
        try {
            if (!resolvedFile.setExecutable(true, true)) {
                throw new IOException("Failed to mark '" + path + "' of Bundle '" + this.bundle + "' as executable. (" + resolvedFile.getAbsolutePath() + ")");
            }
        }
        catch (NoSuchMethodError e) {
            this.markExecutable15(path, resolvedFile);
        }
    }

    private void markExecutable15(String path, File resolvedFile) throws IOException {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"chmod", "+x", resolvedFile.getAbsolutePath()});
            int pe = p.waitFor();
            if (pe != 0) {
                throw new IOException(String.format("chmod +x \"%s\" returned %i", resolvedFile.getAbsolutePath(), pe));
            }
        }
        catch (Exception ioe) {
            throw new IOException("Failed to mark '" + path + "' of Bundle '" + this.bundle + "' as executable. (" + resolvedFile.getAbsolutePath() + ")", ioe);
        }
    }

    private static void safeClose(Closeable c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void startBundle() {
        try {
            if (this.bundle.getState() != 32) {
                this.bundle.start(1);
            }
        }
        catch (BundleException be) {
            throw new IllegalArgumentException("failed to start bundle '" + this.bundle + "'", be);
        }
    }
}

