/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.reef.siren;

import com.adobe.reef.siren.Action;
import com.adobe.reef.siren.Link;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity {
    protected String[] clazz;
    protected String[] rel;
    protected String href;
    protected String type;
    protected String title;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected List<Entity> entities = new LinkedList<Entity>();
    protected List<Link> links = new LinkedList<Link>();
    protected List<Action> actions = new LinkedList<Action>();

    public String[] getClazz() {
        return this.clazz;
    }

    public void setClazz(String[] clazz) {
        this.clazz = clazz;
    }

    public String[] getRel() {
        return this.rel;
    }

    public void setRel(String[] rel) {
        this.rel = rel;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public String toString() {
        try {
            JSONObject entity = new JSONObject();
            if (this.clazz != null) {
                entity.put("class", (Object)this.clazz);
            }
            if (this.href != null) {
                entity.put("href", (Object)this.href);
            }
            if (this.rel != null) {
                entity.put("rel", (Object)this.rel);
            }
            if (this.title != null) {
                entity.put("title", (Object)this.title);
            }
            if (this.type != null) {
                entity.put("type", (Object)this.type);
            }
            if (!this.properties.isEmpty()) {
                entity.put("properties", this.properties);
            }
            if (!this.entities.isEmpty()) {
                LinkedList<JSONObject> entitiesJson = new LinkedList<JSONObject>();
                for (Entity e : this.entities) {
                    entitiesJson.add(new JSONObject(e.toString()));
                }
                entity.put("entities", entitiesJson);
            }
            if (!this.links.isEmpty()) {
                LinkedList<JSONObject> linksJson = new LinkedList<JSONObject>();
                for (Link l : this.links) {
                    linksJson.add(new JSONObject(l.toString()));
                }
                entity.put("links", linksJson);
            }
            if (!this.actions.isEmpty()) {
                LinkedList<JSONObject> actionsJson = new LinkedList<JSONObject>();
                for (Action a : this.actions) {
                    actionsJson.add(new JSONObject(a.toString()));
                }
                entity.put("actions", actionsJson);
            }
            return entity.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + Arrays.hashCode(this.rel);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        return Arrays.equals(this.rel, other.rel);
    }
}

