/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.reef.siren.builder;

import com.adobe.reef.siren.Action;
import com.adobe.reef.siren.EmbeddedLink;
import com.adobe.reef.siren.EmbeddedRepresentation;
import com.adobe.reef.siren.Entity;
import com.adobe.reef.siren.Link;
import com.adobe.reef.siren.builder.Builder;
import com.adobe.reef.siren.builder.BuilderException;
import com.adobe.reef.siren.builder.BuilderValidationException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBuilder
extends Builder<Entity> {
    private String[] clazz;
    private String title;
    private String[] rel;
    private String href;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<Entity> entities = new LinkedList<Entity>();
    private List<Link> links = new LinkedList<Link>();
    private List<Action> actions = new LinkedList<Action>();

    public EntityBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public EntityBuilder setClass(String[] clazz) {
        this.clazz = clazz;
        return this;
    }

    public EntityBuilder setRel(String[] rel) {
        this.rel = rel;
        return this;
    }

    public EntityBuilder setHref(String href) {
        this.href = href;
        return this;
    }

    public EntityBuilder setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public EntityBuilder addProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public EntityBuilder setEntities(List<Entity> entities) {
        this.entities = entities;
        return this;
    }

    public EntityBuilder addEntity(Entity entity) {
        this.entities.add(entity);
        return this;
    }

    public EntityBuilder setLinks(List<Link> links) {
        this.links = links;
        return this;
    }

    public EntityBuilder addLink(Link link) {
        this.links.add(link);
        return this;
    }

    public EntityBuilder setActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public EntityBuilder addAction(Action action) {
        this.actions.add(action);
        return this;
    }

    public EntityBuilder clear() {
        this.clazz = null;
        this.title = null;
        this.rel = null;
        this.href = null;
        this.properties.clear();
        this.entities.clear();
        this.links.clear();
        this.actions.clear();
        return this;
    }

    @Override
    protected Entity doBuild() throws BuilderException {
        try {
            Entity entity = null;
            entity = this.href != null ? new EmbeddedLink(this.rel, this.href) : (this.rel != null ? new EmbeddedRepresentation(this.rel) : new Entity());
            entity.setClazz(this.clazz);
            entity.setTitle(this.title);
            entity.setRel(this.rel);
            entity.setHref(this.href);
            entity.setProperties(this.properties);
            entity.setEntities(this.entities);
            entity.setLinks(this.links);
            entity.setActions(this.actions);
            return entity;
        }
        catch (IllegalArgumentException e) {
            throw new BuilderException(e.getMessage(), e);
        }
    }

    @Override
    protected void validate(Entity entity) throws BuilderValidationException {
        if (entity instanceof EmbeddedLink) {
            this.validateHref(entity);
            this.validateRel(entity);
        } else if (entity instanceof EmbeddedRepresentation) {
            this.validateRel(entity);
            this.validateSelf(entity);
        } else {
            this.validateSelf(entity);
        }
    }

    private void validateHref(Entity entity) throws BuilderValidationException {
        if (entity.getHref() == null) {
            throw new BuilderValidationException("Attribute 'href' cannot be null or empty.");
        }
        try {
            new URI(entity.getHref());
        }
        catch (URISyntaxException e) {
            throw new BuilderValidationException("Entity href is not a valid URI.");
        }
    }

    private void validateRel(Entity entity) throws BuilderValidationException {
        if (entity.getRel() == null) {
            throw new BuilderValidationException("Attribute 'rel' cannot be null or empty.");
        }
    }

    private void validateSelf(Entity entity) throws BuilderValidationException {
        if (!entity.getLinks().isEmpty()) {
            for (Link link : entity.getLinks()) {
                List<String> rels = Arrays.asList(link.getRel());
                if (!rels.contains("self")) continue;
                try {
                    new URI(link.getHref());
                    return;
                }
                catch (URISyntaxException e) {
                    throw new BuilderValidationException("Link href is not a valid URI.");
                }
            }
        }
        throw new BuilderValidationException("Entity has no valid 'self' link.");
    }
}

