/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.reef.siren.builder;

import com.adobe.reef.siren.Link;
import com.adobe.reef.siren.builder.Builder;
import com.adobe.reef.siren.builder.BuilderException;
import com.adobe.reef.siren.builder.BuilderValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkBuilder
extends Builder<Link> {
    private String href;
    private String[] rel;
    private String title;
    private String type;

    public LinkBuilder setHref(String href) {
        this.href = href;
        return this;
    }

    public LinkBuilder setRel(String[] rel) {
        this.rel = rel;
        return this;
    }

    public LinkBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public LinkBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public LinkBuilder clear() {
        this.rel = null;
        this.href = null;
        this.title = null;
        this.type = null;
        return this;
    }

    @Override
    public Link doBuild() throws BuilderException {
        try {
            Link link = new Link(this.rel, this.href);
            link.setTitle(this.title);
            link.setType(this.type);
            return link;
        }
        catch (IllegalArgumentException e) {
            throw new BuilderException(e.getMessage(), e);
        }
    }

    @Override
    protected void validate(Link link) throws BuilderValidationException {
        if (link.getHref() == null || link.getRel() == null) {
            throw new BuilderValidationException("href and rel cannot be null or empty.");
        }
    }
}

