/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst;

import com.day.cq.wcm.webservicesupport.Configuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.settings.SlingSettingsService;

public class SitecatalystUtil {
    private SitecatalystUtil() {
    }

    public static String getServer(SlingHttpServletRequest request, Configuration config) {
        String server = "";
        server = request.getScheme().equals("http") ? "http://" + config.getInherited("cq:trackingServer", "") : "https://" + config.getInherited("cq:trackingServerSecure", "");
        return server;
    }

    public static String getReportSuites(SlingSettingsService settingsService, Configuration configuration) {
        String[] accounts = configuration.getInherited("reportsuites", new String[0]);
        HashSet runModes = settingsService != null ? settingsService.getRunModes() : new HashSet();
        String s_account = "";
        boolean first = true;
        for (int i = 0; i < accounts.length; ++i) {
            String runMode;
            String rsid;
            if (accounts[i].indexOf(";") != -1) {
                rsid = accounts[i].substring(0, accounts[i].indexOf(";"));
                runMode = accounts[i].substring(accounts[i].indexOf(";") + 1);
            } else {
                rsid = accounts[i];
                runMode = "";
            }
            if (!runMode.equals("") && !runModes.contains(runMode)) continue;
            s_account = s_account + (first ? "" : ",") + rsid;
            first = false;
        }
        return s_account;
    }

    public static Integer getCookieDomainNamePeriod(SlingHttpServletRequest request, String server) {
        Integer cookieDomainNamePeriod = 0;
        cookieDomainNamePeriod = server.contains("2o7.net") || server.contains("omtrdc.net") ? Integer.valueOf(request.getServerName().split("\\.").length - 1) : Integer.valueOf(server.split("\\.").length - 1);
        cookieDomainNamePeriod = cookieDomainNamePeriod < 0 ? 0 : cookieDomainNamePeriod;
        return cookieDomainNamePeriod;
    }

    public static String getFormattedPagePath(Resource pageResource, Configuration configuration) {
        String fmtPath = pageResource.getPath();
        String cfgPath = configuration.getPath();
        if (cfgPath != null && fmtPath.startsWith(cfgPath)) {
            fmtPath = fmtPath.replaceFirst(cfgPath, "");
        }
        if (fmtPath.startsWith("/")) {
            fmtPath = fmtPath.replaceFirst("/", "");
        }
        fmtPath = fmtPath.replaceAll("/", ":");
        return fmtPath;
    }

    public static Resource findAnalyticsResource(ResourceResolver resolver, Resource resource) {
        try {
            String resourcePath = resource.getPath();
            while (resourcePath.lastIndexOf("/") > 0) {
                Resource res;
                resource = resolver.getResource(resourcePath);
                if (resource != null && (res = resource.getChild("jcr:content/analytics")) != null) {
                    Node jcrContent = resource.getChild("jcr:content").adaptTo(Node.class);
                    Node node = res.adaptTo(Node.class);
                    if (node.hasProperty("cq:services") || jcrContent.hasProperty("cq:cloudserviceconfigs")) {
                        return res;
                    }
                }
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getPublishPreferredReportSuite(Configuration config) {
        String[] reportSuites = config.getInherited("reportsuites", new String[0]);
        HashMap<String, ArrayList<String>> reportingSuitesPerRunMode = new HashMap<String, ArrayList<String>>();
        for (String reportSuite : reportSuites) {
            ArrayList<String> suites;
            String runMode = "all";
            String[] tmp = reportSuite.split(";");
            if (tmp.length == 2) {
                runMode = tmp[1];
            }
            if ((suites = (ArrayList<String>)reportingSuitesPerRunMode.get(runMode)) == null) {
                suites = new ArrayList<String>();
            }
            suites.add(tmp[0]);
            reportingSuitesPerRunMode.put(runMode, suites);
        }
        String reportSuite = null;
        if (reportingSuitesPerRunMode.get("publish") != null) {
            reportSuite = (String)((List)reportingSuitesPerRunMode.get("publish")).get(0);
        } else if (reportingSuitesPerRunMode.get("all") != null) {
            reportSuite = (String)((List)reportingSuitesPerRunMode.get("all")).get(0);
        } else if (reportingSuitesPerRunMode.get("author") != null) {
            reportSuite = (String)((List)reportingSuitesPerRunMode.get("author")).get(0);
        }
        return reportSuite;
    }
}

