/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.util;

import com.day.cq.analytics.sitecatalyst.util.EasySSLProtocolSocketFactory;
import java.util.Collections;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class HttpClientUtils {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final boolean DEFAULT_STALE_CONNECTION_CHECK = true;
    public static final int DEFAULT_SO_LINGER = 0;

    private HttpClientUtils() {
    }

    public static HttpClient newMultiThreaded() {
        return HttpClientUtils.newMultiThreaded(30000, 50);
    }

    public static HttpClient newMultiThreaded(int connectionTimeout, int maxConnections) {
        return HttpClientUtils.newMultiThreaded(connectionTimeout, maxConnections, true, 0);
    }

    public static HttpClient newMultiThreaded(int connectionTimeout, int maxConnections, boolean staleConnectionCheck, int soLinger) {
        HttpClientParams params = HttpClientUtils.newParams(connectionTimeout, maxConnections, staleConnectionCheck, soLinger);
        HttpClient httpClient = new HttpClient(params, (HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        return httpClient;
    }

    private static HttpClientParams newParams(int connectionTimeout, int maxConnections, boolean staleConnectionCheck, int soLinger) {
        HttpClientParams params = new HttpClientParams();
        params.setCookiePolicy("ignoreCookies");
        params.setParameter("http.connection.timeout", (Object)connectionTimeout);
        params.setParameter("http.connection.stalecheck", (Object)staleConnectionCheck);
        params.setParameter("http.connection-manager.max-total", (Object)maxConnections);
        params.setParameter("http.connection-manager.max-per-host", Collections.singletonMap(HostConfiguration.ANY_HOST_CONFIGURATION, maxConnections));
        params.setParameter("http.socket.linger", (Object)soLinger);
        return params;
    }

    public static void allowSelfSigned(HttpClient httpClient, String host, int port) {
        if (port < 0) {
            port = 443;
        }
        Protocol httpsProtocol = new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(true), port);
        httpClient.getHostConfiguration().setHost(host, port, httpsProtocol);
    }

    public static void shutdown(final HttpClient httpClient) {
        if (httpClient != null) {
            Thread shutdownThread = new Thread(){

                @Override
                public void run() {
                    HttpConnectionManager cm = httpClient.getHttpConnectionManager();
                    if (cm instanceof MultiThreadedHttpConnectionManager) {
                        ((MultiThreadedHttpConnectionManager)cm).shutdown();
                    } else if (cm instanceof SimpleHttpConnectionManager) {
                        ((SimpleHttpConnectionManager)cm).shutdown();
                    }
                }
            };
            shutdownThread.setName("HttpConnectionManager Shutdown Thread");
            shutdownThread.setDaemon(true);
            shutdownThread.start();
        }
    }
}

