/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.util;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitecatalystJsonItemReader {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String incrementalIndexKey = "";
    private int startIndex = -1;

    public SitecatalystJsonItemReader(String incrementalIndexKey, int startIndex) {
        this.incrementalIndexKey = incrementalIndexKey;
        this.startIndex = startIndex;
    }

    public SitecatalystJsonItemReader() {
    }

    public void readObject(Node parent, String key, JSONObject obj) throws RepositoryException, JSONException {
        Node child = !parent.hasNode(key) ? parent.addNode(key) : parent.getNode(key);
        Iterator<String> keyIter = obj.keys();
        while (keyIter.hasNext()) {
            String childKey = keyIter.next();
            if (childKey.matches("jcr:.+")) {
                this.LOGGER.debug("skipping JCR property " + childKey);
                continue;
            }
            if (childKey.matches("(^\\/|.*?\\.\\.\\/).*?")) {
                this.LOGGER.warn("skipping path traversal sequence " + childKey);
                continue;
            }
            if (obj.isNull(childKey)) continue;
            Object value = obj.get(childKey);
            if (value instanceof JSONObject) {
                this.readObject(child, childKey, (JSONObject)value);
                continue;
            }
            if (value instanceof JSONArray) {
                this.readArray(child, childKey, (JSONArray)value);
                continue;
            }
            if (value.toString().matches("\\d+")) {
                child.setProperty(childKey, Long.parseLong(value.toString()));
                continue;
            }
            child.setProperty(childKey, value.toString());
        }
    }

    public void readArray(Node parent, String key, JSONArray array) throws RepositoryException, JSONException {
        Object[] values = new Object[array.length()];
        Node child = null;
        int useIndex = 0;
        if (this.startIndex >= 0 && StringUtils.isNotBlank((String)this.incrementalIndexKey) && this.incrementalIndexKey.equalsIgnoreCase(key)) {
            useIndex = this.startIndex;
        }
        for (int i = 0; i < array.length(); ++i) {
            if (array.isNull(i)) continue;
            String childKey = Integer.toString(i + useIndex);
            Object value = array.get(i);
            if (value instanceof JSONObject) {
                if (child == null) {
                    child = !parent.hasNode(key) ? parent.addNode(key) : parent.getNode(key);
                }
                this.readObject(child, childKey, (JSONObject)value);
                values = null;
                continue;
            }
            if (value instanceof JSONArray) {
                if (child == null) {
                    child = !parent.hasNode(key) ? parent.addNode(key) : parent.getNode(key);
                }
                this.readArray(child, childKey, (JSONArray)value);
                values = null;
                continue;
            }
            if (values == null) continue;
            values[i] = value;
        }
        if (values != null) {
            boolean isLong = true;
            for (int i = 0; i < values.length; ++i) {
                if (values[i].toString().matches("\\d+")) continue;
                isLong = false;
                break;
            }
            if (isLong) {
                Value[] longValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    longValues[i] = parent.getSession().getValueFactory().createValue(Long.parseLong(values[i].toString()));
                }
                parent.setProperty(key, longValues);
            } else {
                String[] stringValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    stringValues[i] = values[i].toString();
                }
                parent.setProperty(key, stringValues);
            }
        }
    }
}

