/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.day.cq.commons.TidyJSONWriter;
import java.io.Writer;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.commons.json.jcr.JsonItemWriter;

public class TidyJsonItemWriter
extends JsonItemWriter {
    private boolean tidy;

    public TidyJsonItemWriter(Set<String> propertyNamesToIgnore) {
        super(propertyNamesToIgnore);
    }

    public boolean isTidy() {
        return this.tidy;
    }

    public void setTidy(boolean tidy) {
        this.tidy = tidy;
    }

    public void dump(Node node, JSONWriter w, int maxRecursionLevels) throws RepositoryException, JSONException {
        this.dump(node, w, 0, maxRecursionLevels);
    }

    @Override
    public void dump(Node node, Writer w, int maxRecursionLevels) throws RepositoryException, JSONException {
        TidyJSONWriter jw = new TidyJSONWriter(w);
        jw.setTidy(this.tidy);
        this.dump(node, jw, 0, maxRecursionLevels);
    }

    public void dump(NodeIterator it, JSONWriter w) throws RepositoryException, JSONException {
        w.array();
        while (it.hasNext()) {
            this.dumpSingleNode(it.nextNode(), w, 1, 0);
        }
        w.endArray();
    }

    @Override
    public void dump(NodeIterator it, Writer out) throws RepositoryException, JSONException {
        TidyJSONWriter w = new TidyJSONWriter(out);
        w.setTidy(this.tidy);
        w.array();
        while (it.hasNext()) {
            this.dumpSingleNode(it.nextNode(), w, 1, 0);
        }
        w.endArray();
    }

    public void dump(Property p, JSONWriter w) throws JSONException, RepositoryException {
        w.object();
        this.writeProperty(w, p);
        w.endObject();
    }

    @Override
    public void dump(Property p, Writer w) throws JSONException, ValueFormatException, RepositoryException {
        TidyJSONWriter jw = new TidyJSONWriter(w);
        jw.setTidy(this.tidy);
        jw.object();
        this.writeProperty(jw, p);
        jw.endObject();
    }
}

