/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.mail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailTemplate {
    private static final String HEADER_TO = "To";
    private static final String HEADER_CC = "CC";
    private static final String HEADER_BCC = "BCC";
    private static final String HEADER_REPLYTO = "Reply-To";
    private static final String HEADER_FROM = "From";
    private static final String HEADER_SUBJECT = "Subject";
    private static final String HEADER_BOUNCETO = "Bounce-To";
    private static final String[] PRIMARY_HEADERS = new String[]{"To", "CC", "BCC", "Reply-To", "From", "Subject", "Bounce-To"};
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final Logger log = LoggerFactory.getLogger(MailTemplate.class);
    private String message;
    private String charset;

    public MailTemplate(InputStream inputStream, String encoding) throws IOException {
        if (null == inputStream) {
            throw new IllegalArgumentException("input stream may not be null");
        }
        this.charset = StringUtils.defaultIfEmpty((String)encoding, (String)DEFAULT_CHARSET);
        InputStreamReader reader = new InputStreamReader(inputStream, this.charset);
        StringWriter writer = new StringWriter();
        IOUtils.copy((Reader)reader, (Writer)writer);
        this.message = writer.toString();
    }

    public <T extends Email> T getEmail(StrLookup lookup, Class<T> type) throws IOException, MessagingException, EmailException {
        if (null == lookup) {
            throw new IllegalArgumentException("lookup may not be null");
        }
        StrSubstitutor substitutor = new StrSubstitutor(lookup);
        String source = substitutor.replace(this.message);
        ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes(this.charset));
        InternetHeaders headers = new InternetHeaders((InputStream)in);
        Email email = null;
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            email = (Email)constructor.newInstance(new Object[0]);
            email.setCharset(this.charset);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)in, (Writer)writer, (String)this.charset);
            email.setMsg(writer.toString());
            Enumeration primaryHeaders = headers.getMatchingHeaders(PRIMARY_HEADERS);
            while (primaryHeaders.hasMoreElements()) {
                Header header = (Header)primaryHeaders.nextElement();
                String name = header.getName();
                String value = header.getValue();
                if (null != value) {
                    if (HEADER_TO.equalsIgnoreCase(name)) {
                        email.addTo(value);
                        continue;
                    }
                    if (HEADER_CC.equalsIgnoreCase(name)) {
                        email.addCc(value);
                        continue;
                    }
                    if (HEADER_BCC.equalsIgnoreCase(name)) {
                        email.addBcc(value);
                        continue;
                    }
                    if (HEADER_REPLYTO.equalsIgnoreCase(name)) {
                        email.addReplyTo(value);
                        continue;
                    }
                    if (HEADER_FROM.equalsIgnoreCase(name)) {
                        email.setFrom(value);
                        continue;
                    }
                    if (HEADER_SUBJECT.equalsIgnoreCase(name)) {
                        email.setSubject(value);
                        continue;
                    }
                    if (!HEADER_BOUNCETO.equalsIgnoreCase(name)) continue;
                    email.setBounceAddress(value);
                    continue;
                }
                log.warn("got empty primary header [{}].", (Object)name);
            }
            Enumeration secondaryHeaders = headers.getNonMatchingHeaders(PRIMARY_HEADERS);
            while (secondaryHeaders.hasMoreElements()) {
                Header header = (Header)secondaryHeaders.nextElement();
                String name = header.getName();
                String value = header.getValue();
                if (null != value) {
                    email.addHeader(name, value);
                    continue;
                }
                log.warn("got empty secondary header [{}].", (Object)name);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return (T)email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailTemplate create(String path, Session session) {
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalArgumentException("path may not be null or empty");
        }
        if (null == session) {
            throw new IllegalArgumentException("session may not be null");
        }
        InputStream is = null;
        try {
            if (session.itemExists(path)) {
                Node node = session.getNode(path);
                if ("nt:file".equals(node.getPrimaryNodeType().getName())) {
                    Node content = node.getNode("jcr:content");
                    String encoding = content.hasProperty("jcr:encoding") ? content.getProperty("jcr:encoding").getString() : DEFAULT_CHARSET;
                    is = content.getProperty("jcr:data").getBinary().getStream();
                    log.debug("loaded template [{}].", (Object)path);
                    MailTemplate mailTemplate = new MailTemplate(is, encoding);
                    IOUtils.closeQuietly((InputStream)is);
                    return mailTemplate;
                }
                throw new IllegalArgumentException("provided path does not point to a nt:file node");
            }
            IOUtils.closeQuietly(is);
        }
        catch (RepositoryException e) {
            log.error("error creating message template: ", (Throwable)e);
        }
        catch (IOException e) {
            log.error("error creating message template: ", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }
}

