/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.servlets;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"nt:file"}, extensions={"html"})
public class ProxyServlet
extends SlingSafeMethodsServlet
implements OptingServlet {
    private static final long serialVersionUID = -2132087866168663893L;
    private final Logger log = LoggerFactory.getLogger(ProxyServlet.class);

    @Override
    protected void service(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource resource = request.getResource();
        RequestDispatcher crd = request.getRequestDispatcher(resource.getPath() + "/" + "jcr:content");
        if (crd == null) {
            this.log.error("Unable to dispatch proxy request.for {} referrer={}", (Object)request.getRequestURI(), (Object)request.getHeader("Referrer"));
            throw new ServletException("No Content");
        }
        crd.include((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request) {
        try {
            Resource resource = request.getResource();
            Node node = resource.adaptTo(Node.class);
            if (node == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unable to adapt resource to node: {}", (Object)resource.getPath());
                }
                return false;
            }
            if (!node.hasNode("jcr:content")) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("resource has no jcr:content: {}", (Object)resource.getPath());
                }
                return false;
            }
            Node content = node.getNode("jcr:content");
            if (!content.hasProperty("sling:resourceType")) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("resource content has no sling:resourceType property: {}", (Object)resource.getPath());
                }
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("accepting request for {}", (Object)resource.getPath());
            }
            return true;
        }
        catch (RepositoryException e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("Error while evaluating accept.", (Throwable)e);
            } else {
                this.log.warn("Error while evaluating accept: {}", (Object)e.toString());
            }
            return false;
        }
    }
}

