/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.handler;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.contentsync.handler.AbstractDefaultContentUpdateHandler;
import com.day.cq.contentsync.handler.ContentUpdateHandler;
import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractSlingResourceUpdateHandler
extends AbstractDefaultContentUpdateHandler
implements ContentUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractSlingResourceUpdateHandler.class);
    private static final String NT_MD5_HASH = "cq:ContentSyncHash";
    private static final String MD5_HASH_PROPERTY = "md5";
    @Reference
    protected SlingRequestProcessor slingServlet;
    @Reference
    protected JcrResourceResolverFactory resolverFactory;
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference
    protected RequestResponseFactory requestResponseFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renderResource(String uri, String configCacheRoot, Session admin, Session session) throws RepositoryException, ServletException, IOException {
        String cachePath = configCacheRoot + this.getTargetPath(uri);
        try {
            ResourceResolver resolver = this.resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpServletRequest request = this.createRequest(uri);
            HttpServletResponse response = this.requestResponseFactory.createResponse(out);
            this.slingServlet.processRequest(request, response, resolver);
            response.getWriter().flush();
            String md5 = this.requestResponseFactory.getMD5(response);
            String md5Path = cachePath + "/" + "jcr:content" + "/" + MD5_HASH_PROPERTY;
            if (!admin.propertyExists(md5Path) || !admin.getProperty(md5Path).getString().equals(md5)) {
                log.debug("MD5 hash missing or not equal, updating content sync cache: {}", (Object)cachePath);
                JcrUtil.createPath(cachePath, "sling:Folder", "nt:file", admin, false);
                Node cacheContentNode = JcrUtil.createPath(cachePath + "/jcr:content", "nt:resource", admin);
                if (this.needsUtf8Encoding(response)) {
                    String encoding = response.getCharacterEncoding();
                    cacheContentNode.setProperty("jcr:data", admin.getValueFactory().createBinary(IOUtils.toInputStream((String)out.toString(encoding), (String)encoding)));
                } else {
                    cacheContentNode.setProperty("jcr:data", admin.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(out.toByteArray())));
                }
                cacheContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                if (response.getContentType() != null) {
                    cacheContentNode.setProperty("jcr:mimeType", response.getContentType());
                }
                if (response.getCharacterEncoding() != null) {
                    cacheContentNode.setProperty("jcr:encoding", response.getCharacterEncoding());
                }
                cacheContentNode.addMixin(NT_MD5_HASH);
                cacheContentNode.setProperty(MD5_HASH_PROPERTY, md5);
                admin.save();
                boolean bl = true;
                return bl;
            }
            log.debug("Skipping update of content sync cache: {}", (Object)uri);
            boolean bl = false;
            return bl;
        }
        catch (LoginException e) {
            log.error("Creating resource resolver for resource rendering failed: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (admin.hasPendingChanges()) {
                admin.refresh(false);
            }
        }
    }

    protected HttpServletRequest createRequest(String uri) {
        return this.requestResponseFactory.createRequest("GET", uri);
    }

    protected String getTargetPath(String path) {
        return path;
    }

    private boolean needsUtf8Encoding(HttpServletResponse response) {
        String contentType = response.getContentType();
        return contentType != null ? contentType.endsWith("/json") : false;
    }

    protected void bindSlingServlet(SlingRequestProcessor slingRequestProcessor) {
        this.slingServlet = slingRequestProcessor;
    }

    protected void unbindSlingServlet(SlingRequestProcessor slingRequestProcessor) {
        if (this.slingServlet == slingRequestProcessor) {
            this.slingServlet = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindRequestResponseFactory(RequestResponseFactory requestResponseFactory) {
        this.requestResponseFactory = requestResponseFactory;
    }

    protected void unbindRequestResponseFactory(RequestResponseFactory requestResponseFactory) {
        if (this.requestResponseFactory == requestResponseFactory) {
            this.requestResponseFactory = null;
        }
    }
}

