/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.preset;

import com.day.cq.dam.commons.preset.PresetType;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.tenant.Tenant;

public class S7Preset {
    private static final String DEFAULT_PRESET_ROOT_PATH = "/etc/dam/";
    private static final String TENANTS_BASE_PATH = "tenants/";
    private static final String PRESET_BASE_PATH = "/presets/";
    private static final String JCR_PRESET_ROOT_PATH = "/etc/dam/dynamicmediaconfig";
    private static final String JCR_PRESET_ROOT_PROP = "dynamicMediaPresetRoot";
    private PresetType presetType = null;
    private String tenantId = "";
    private String presetRootPath = "";

    public S7Preset(String presetTypeName, ResourceResolver resourceResolver) {
        Tenant tenant;
        this.presetType = PresetType.getPresetTypeByName(presetTypeName);
        this.presetRootPath = DEFAULT_PRESET_ROOT_PATH;
        if (resourceResolver != null && (tenant = resourceResolver.adaptTo(Tenant.class)) != null) {
            this.tenantId = tenant.getId();
            this.presetRootPath = this.getPresetRootPath(resourceResolver);
        }
    }

    private String getPresetRootPath(ResourceResolver resourceResolver) {
        String presetRootPath = DEFAULT_PRESET_ROOT_PATH;
        try {
            Session session = resourceResolver.adaptTo(Session.class);
            Node jcrRootPathNode = session.getNode(JCR_PRESET_ROOT_PATH);
            if (jcrRootPathNode != null && jcrRootPathNode.hasProperty(JCR_PRESET_ROOT_PROP) && !(presetRootPath = jcrRootPathNode.getProperty(JCR_PRESET_ROOT_PROP).getString()).endsWith("/")) {
                presetRootPath = presetRootPath + "/";
            }
        }
        catch (PathNotFoundException pnfe) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return presetRootPath;
    }

    public String getPresetPath() {
        StringBuilder path = new StringBuilder(this.presetRootPath);
        if (!this.tenantId.isEmpty()) {
            path.append(TENANTS_BASE_PATH);
            path.append(this.tenantId);
            path.append(PRESET_BASE_PATH);
            path.append(this.presetType.getName());
        } else {
            path.append(this.presetType.getDefaultPresetPath());
        }
        return path.toString();
    }
}

