/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.thumbnail;

import com.day.image.Layer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;

@Deprecated
public class ThumbnailCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createThumbnails(BufferedImage image, Node renditionsFolder, List<ThumbnailConfig> thumbnailConfigurations) throws IOException, RepositoryException {
        File thumbnailtmpFile = null;
        try {
            thumbnailtmpFile = File.createTempFile("thumbnail", ".tmp");
            for (ThumbnailConfig d : thumbnailConfigurations) {
                FileOutputStream tout = null;
                FileInputStream is = null;
                int maxHeight = d.getHeight();
                int maxWidth = d.getWidth();
                try {
                    tout = new FileOutputStream(thumbnailtmpFile);
                    Layer thumbnailLayer = this.creatThumbnail(image, maxWidth, maxHeight, this.getExtension(renditionsFolder), d.isDoCenter());
                    thumbnailLayer.write("image/png", 0.8, tout);
                    is = new FileInputStream(thumbnailtmpFile);
                    this.setThumbnail(renditionsFolder, is, d);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly((OutputStream)tout);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)tout);
            }
            renditionsFolder.getSession().save();
        }
        finally {
            if (thumbnailtmpFile != null) {
                thumbnailtmpFile.delete();
            }
        }
    }

    public Layer creatThumbnail(BufferedImage image, int maxWidth, int maxHeight, String extension, boolean doCenter) {
        Layer finalLayer = null;
        Layer layer = new Layer(image);
        int height = layer.getHeight();
        int width = layer.getWidth();
        Color bgColor = layer.getBackgroundColor();
        if (height > maxHeight || width > maxWidth) {
            int newWidth;
            int newHeight;
            if (height > width) {
                newHeight = maxHeight;
                newWidth = width * maxHeight / height;
                if (newWidth > maxWidth) {
                    newWidth = maxWidth;
                    newHeight = height * maxWidth / width;
                }
            } else {
                newWidth = maxWidth;
                newHeight = height * maxWidth / width;
                if (newHeight > maxHeight) {
                    newHeight = maxHeight;
                    newWidth = width * maxHeight / height;
                }
            }
            layer.resize(newWidth, newHeight);
        }
        if ((layer.getHeight() < maxHeight || layer.getWidth() < maxWidth) && doCenter) {
            if (bgColor == null) {
                bgColor = Color.WHITE;
            }
            Color dummyColor = extension.equals("gif") ? new Color(-991024) : bgColor;
            finalLayer = new Layer(maxWidth, maxHeight, dummyColor);
            finalLayer.setTransparency(dummyColor);
            int y = (maxHeight - layer.getHeight()) / 2;
            int x = (maxWidth - layer.getWidth()) / 2;
            layer.setX(x);
            layer.setY(y);
            finalLayer.merge(layer);
        }
        if (finalLayer == null) {
            return layer;
        }
        return finalLayer;
    }

    public ThumbnailConfig createThumbnailConfig() {
        return new ThumbnailConfig();
    }

    private void setThumbnail(Node renditionsFolder, InputStream in, ThumbnailConfig thumbnailConf) throws RepositoryException {
        if (renditionsFolder.hasNode(this.getThumbnailName(thumbnailConf))) {
            Node content = renditionsFolder.getNode(this.getThumbnailName(thumbnailConf) + "/" + "jcr:content");
            content.setProperty("jcr:mimeType", "image/png");
            content.setProperty("jcr:data", content.getSession().getValueFactory().createBinary(in));
            content.setProperty("jcr:lastModified", Calendar.getInstance());
        } else {
            Node file = renditionsFolder.addNode(this.getThumbnailName(thumbnailConf), "nt:file");
            Node content = file.addNode("jcr:content", "nt:resource");
            content.setProperty("jcr:mimeType", "image/png");
            content.setProperty("jcr:data", content.getSession().getValueFactory().createBinary(in));
            content.setProperty("jcr:lastModified", Calendar.getInstance());
        }
    }

    private String getThumbnailName(ThumbnailConfig conf) {
        String name = "cq5dam.thumbnail";
        if (conf != null) {
            name = name + "." + String.valueOf(conf.getWidth()) + "." + String.valueOf(conf.getHeight()) + (conf.isDoCenter() ? ".margin" : "");
        }
        name = name + ".png";
        return name;
    }

    private String getExtension(Node node) throws RepositoryException {
        String assetPath = node.getParent().getParent().getPath();
        return assetPath.substring(assetPath.lastIndexOf(".") + 1);
    }

    public class ThumbnailConfig {
        private int width;
        private int height;
        private boolean doCenter = true;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean isDoCenter() {
            return this.doCenter;
        }

        public void setDoCenter(boolean doCenter) {
            this.doCenter = doCenter;
        }
    }
}

