/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.ui.editor.metadata;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.ui.editor.metadata.MetadataEditorHelper;
import com.day.cq.dam.commons.util.SchemaFormHelper;
import com.day.cq.workflow.collection.ResourceCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

@Service
@Component
public class MetadataEditorHelperImpl
implements MetadataEditorHelper {
    private static final String MIMETYPE_MAPPING_PATH = "/etc/dam/metadataeditor/mimetypemappings";
    private static final String FOLDER_SPECIFIC_METADATA_FORM = "jcr:content/metadataSchema";
    private static final String REQUIRED = "required";
    private static final String METADATA_PROPERTY_NAME = "name";
    private static final String COLLECTION_FORM = "collection";
    private static final String DEFAULT_FORM = "default";

    @Override
    public Resource getEditorFormResource(Resource ... resources) {
        return this.getFormResource(resources);
    }

    @Override
    public List<Resource> getInvalidFormItems(Resource resource) {
        return this.getEmptyMandatoryMetadata(resource);
    }

    private List<Resource> getEmptyMandatoryMetadata(Resource resource) {
        Resource formResource = this.getFormResource(resource);
        ArrayList<Resource> items = new ArrayList<Resource>();
        ArrayList<Resource> emptyMandatoryFields = new ArrayList<Resource>();
        this.traverseForm(formResource, items);
        for (Resource each : items) {
            ValueMap vmLoad;
            ValueMap vm = each.adaptTo(ValueMap.class);
            boolean required = vm.get(REQUIRED, false);
            String name = (String)((Object)vm.get(METADATA_PROPERTY_NAME, String.class));
            if (null == name || "".equals(name) || !required) continue;
            if (name.startsWith("./")) {
                name = name.substring(2);
            }
            if (null != (vmLoad = resource.adaptTo(ValueMap.class)).get(name)) continue;
            emptyMandatoryFields.add(each);
        }
        return emptyMandatoryFields;
    }

    private void traverseForm(Resource resource, List<Resource> items) {
        if (null != resource) {
            ValueMap vm = resource.adaptTo(ValueMap.class);
            if (vm.containsKey(METADATA_PROPERTY_NAME) && vm.containsKey(REQUIRED)) {
                items.add(resource);
            }
            if (resource.hasChildren()) {
                Iterator<Resource> children = resource.listChildren();
                while (children.hasNext()) {
                    Resource child = children.next();
                    this.traverseForm(child, items);
                }
            }
        }
    }

    private Asset[] convertToAssets(Resource ... resources) throws IllegalArgumentException {
        Asset[] assets = new Asset[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Asset each = resources[i].adaptTo(Asset.class);
            if (null == each) {
                throw new IllegalArgumentException("All resources are not adaptable to asset");
            }
            assets[i] = each;
        }
        return assets;
    }

    private String getMimeType(Asset ... assets) {
        if (null == assets || assets.length == 0) {
            throw new IllegalArgumentException("Assets must not be null or empty");
        }
        ResourceResolver resourceResolver = assets[0].adaptTo(Resource.class).getResourceResolver();
        MediaType commonType = null;
        for (Asset each : assets) {
            String eachType = each.getMimeType();
            eachType = eachType == null ? "application/octet-stream" : eachType;
            String exposedType = this.getExposedmimetype(eachType, resourceResolver);
            commonType = null != commonType ? commonType.getCommonType(new MediaType(exposedType)) : new MediaType(exposedType);
        }
        return commonType.getMimeType();
    }

    private String getExposedmimetype(String mimetype, ResourceResolver resourceResolver) {
        String MIMETYPES = "mimetypes";
        String EXPOSED_MIMETYPE = "exposedmimetype";
        Resource mimeTypeMappingsRes = resourceResolver.getResource(MIMETYPE_MAPPING_PATH);
        if (mimeTypeMappingsRes != null) {
            Iterator<Resource> children = mimeTypeMappingsRes.listChildren();
            while (children.hasNext()) {
                Object[] mimeTypes;
                Resource child = children.next();
                ValueMap vm = child.adaptTo(ValueMap.class);
                if (!vm.containsKey("mimetypes") || !ArrayUtils.contains((Object[])(mimeTypes = (String[])vm.get("mimetypes", String[].class)), (Object)mimetype)) continue;
                mimetype = (String)((Object)vm.get("exposedmimetype", String.class));
                return mimetype;
            }
        }
        return mimetype;
    }

    String getFolderSpecificMetadataForm(Resource resource, String mimeType) {
        Resource parent;
        for (parent = resource.getParent(); parent != null && parent.getChild(FOLDER_SPECIFIC_METADATA_FORM) == null && !parent.getPath().equals("/content/dam"); parent = parent.getParent()) {
        }
        if (parent == null) {
            return null;
        }
        ValueMap vm = parent.adaptTo(ValueMap.class);
        String folderMetadata = (String)((Object)vm.get(FOLDER_SPECIFIC_METADATA_FORM, String.class));
        String assetSpecificForm = null;
        if (null == folderMetadata) {
            return null;
        }
        ResourceResolver resolver = resource.getResourceResolver();
        for (assetSpecificForm = new StringBuilder().append(folderMetadata).append("/").append(mimeType).toString(); resolver.resolve(assetSpecificForm).getResourceType().equals("sling:nonexisting") && assetSpecificForm != null; assetSpecificForm = assetSpecificForm.substring(0, assetSpecificForm.lastIndexOf("/"))) {
        }
        return assetSpecificForm;
    }

    private Resource getAbsoluteFormResource(ResourceResolver resolver, String relativeFormPath) {
        String[] baseFormPaths = SchemaFormHelper.getBaseFormPaths(resolver);
        relativeFormPath = MetadataEditorHelperImpl.getRelativeFormPath(relativeFormPath, baseFormPaths);
        do {
            for (String baseFormPath : baseFormPaths) {
                String path = baseFormPath + relativeFormPath;
                Resource res = resolver.getResource(path);
                if (res == null) {
                    res = resolver.getResource(path.toLowerCase());
                }
                if (res == null || res.getChild("items/tabs") == null && !relativeFormPath.trim().isEmpty()) continue;
                return res;
            }
        } while (!(relativeFormPath = relativeFormPath.trim().isEmpty() ? "" : relativeFormPath.substring(0, relativeFormPath.lastIndexOf(47))).trim().isEmpty());
        return null;
    }

    private final Resource mergeResources(Resource resource) {
        List<Resource> masterTabList;
        try {
            masterTabList = SchemaFormHelper.getMasterForms(resource);
        }
        catch (RepositoryException e) {
            throw new SlingException("unable to get master forms ", e);
        }
        Resource rootTabRes = null;
        if (!masterTabList.isEmpty()) {
            Resource root = masterTabList.get(0);
            rootTabRes = root.getChild("items/tabs");
            for (int i = 1; i < masterTabList.size(); ++i) {
                Resource formRes = masterTabList.get(i);
                Resource formTabRes = formRes.getChild("items/tabs");
                rootTabRes = SchemaFormHelper.mergeFormTabResource(rootTabRes, formTabRes);
            }
        }
        Resource currentFormResource = resource;
        Resource currentTabListRes = currentFormResource.getChild("items/tabs");
        rootTabRes = rootTabRes != null ? SchemaFormHelper.mergeFormTabResource(rootTabRes, currentTabListRes) : currentTabListRes;
        return rootTabRes;
    }

    private Resource getFormResource(Resource ... resources) {
        if (null == resources || resources.length == 0) {
            throw new IllegalArgumentException("Failure: No resource(s) passed.");
        }
        String relativeFormPath = "";
        ResourceResolver resolver = resources[0].getResourceResolver();
        String mimeType = this.getMimeType(this.convertToAssets(resources));
        if (resources.length == 1 && resources[0].adaptTo(ResourceCollection.class) != null) {
            relativeFormPath = "/collection";
        } else {
            if (resources.length == 1) {
                relativeFormPath = this.getFolderSpecificMetadataForm(resources[0], this.getMimeType(this.convertToAssets(resources)));
            }
            if (null == relativeFormPath) {
                relativeFormPath = "/default/" + mimeType;
            }
        }
        Resource res = this.getAbsoluteFormResource(resolver, relativeFormPath);
        return this.mergeResources(res);
    }

    private static String getRelativeFormPath(String formPath, String[] baseFormPaths) {
        for (String baseFormPath : baseFormPaths) {
            if (!formPath.startsWith(baseFormPath)) continue;
            String relativePath = formPath.substring(baseFormPath.length());
            relativePath = relativePath.startsWith("/") ? relativePath : relativePath + "/";
            relativePath = relativePath.endsWith("/") ? relativePath.substring(relativePath.length() - 1) : relativePath;
            return relativePath;
        }
        return formPath;
    }

    private static class MediaType {
        private final String topLevelType;
        private final String subType;
        private final String mimeType;

        MediaType(String mediaType) {
            if (mediaType == null || mediaType.length() == 0) {
                throw new IllegalArgumentException("mediaType must not be null or empty.");
            }
            String[] parts = mediaType.split("/");
            if (parts.length > 2) {
                throw new IllegalArgumentException("Invalid mediaType.");
            }
            this.mimeType = mediaType;
            this.topLevelType = parts[0];
            this.subType = parts.length > 1 && parts[1].length() > 0 ? parts[1] : null;
        }

        private MediaType(String topLevelType, String subType) {
            this.topLevelType = topLevelType;
            this.subType = subType;
            String mimeType = "";
            if (null != this.topLevelType) {
                mimeType = mimeType + this.topLevelType;
                if (null != this.subType) {
                    mimeType = mimeType + '/' + this.subType;
                }
            }
            this.mimeType = mimeType;
        }

        MediaType getCommonType(MediaType other) {
            if (this.topLevelType != null && this.topLevelType.equals(other.topLevelType)) {
                if (this.subType != null && this.subType.equals(other.subType)) {
                    return this;
                }
                return new MediaType(this.topLevelType, null);
            }
            return new MediaType(null, null);
        }

        String getMimeType() {
            return this.mimeType;
        }
    }
}

