/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.commons.Language;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.commons.util.UIHelper;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.cq.wcm.api.WCMException;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamLanguageUtil {
    private static final Logger log = LoggerFactory.getLogger(DamLanguageUtil.class);
    private static final String CONTENT_FRAGMENT = "contentFragment";
    private static final String ATTRIBUTE_DESTINATION_LANGUAGE_COPY_PATH = "dam:destinationLanguageCopy";
    public static final String ATTRIBUTE_ASSET_UPDATE_REQUIRED = "dam:assetUpdateRequired";
    private static final String ATTRIBUTE_SMART_ASSET_UPDATE_SOURCE = "dam:smartAssetUpdateSource";
    private static final String ATTRIBUTE_EXTRACT_METADATA = "dam:extractMetadata";
    private static final String ASSET_VERSION_MESSAGE = "Created by Asset Update Translation";
    private static final String ASSET_PERFORMANCE_NODE_RELATIVE_PATH = "/jcr:content/performance";
    private static final String ASSET_USAGE_NODE_RELATIVE_PATH = "/jcr:content/usages";

    public static boolean hasLanguageCopy(String assetPath, String languageCode, ResourceResolver resolver) {
        Asset asset = DamLanguageUtil.findLanguageCopy(assetPath, languageCode, resolver);
        return asset != null;
    }

    public static Asset getLanguageCopy(String assetPath, String languageCode, ResourceResolver resolver) {
        return DamLanguageUtil.findLanguageCopy(assetPath, languageCode, resolver);
    }

    public static List<String> createLanguageCopy(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String[] targetLanguageCodes) {
        Session session = resourceResolver.adaptTo(Session.class);
        PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        ArrayList<String> createdCopies = new ArrayList<String>();
        String languageCopyPath = "";
        String contentPath = "";
        if (targetLanguageCodes == null || targetLanguageCodes.length == 0 || targetLanguageCodes[0].trim().length() == 0) {
            log.error("Failed to load destination language from payload.");
            return null;
        }
        String root = LanguageUtil.getLanguageRoot(sourcePath);
        String parentOfRoot = null;
        boolean createNewLanguageRoot = false;
        if (root == null) {
            log.debug("Language root does not exist for asset at path: {} and would be created. ", (Object)sourcePath);
            if (Text.getRelativeParent(sourcePath, 1).equals("/content/dam")) {
                createNewLanguageRoot = true;
                parentOfRoot = "/content/dam";
                root = "/content/dam";
            } else if (sourcePath.startsWith("/content/dam/")) {
                int parentOfRootPathLength = sourcePath.indexOf(47, "/content/dam".length() + 1);
                int oldRootPathLength = sourcePath.indexOf(47, parentOfRootPathLength);
                if (parentOfRootPathLength < 0 || sourcePath.length() <= parentOfRootPathLength) {
                    return createdCopies;
                }
                createNewLanguageRoot = true;
                parentOfRoot = sourcePath.substring(0, parentOfRootPathLength);
                if (oldRootPathLength > 0 && sourcePath.length() > oldRootPathLength) {
                    root = sourcePath.substring(0, oldRootPathLength);
                }
            }
            log.info("Parent of New Language root at path {} added for asset at path {}", (Object)parentOfRoot, (Object)sourcePath);
            contentPath = sourcePath.replaceFirst(parentOfRoot, "");
        } else {
            contentPath = sourcePath.replaceFirst(root, "");
            parentOfRoot = Text.getRelativeParent(root, 1);
        }
        for (int i = 0; i < targetLanguageCodes.length; ++i) {
            String targetPath = "";
            String languageRootPath = "";
            languageRootPath = parentOfRoot + "/" + targetLanguageCodes[i];
            targetPath = languageRootPath + contentPath;
            try {
                if (contentPath.trim().length() > 0) {
                    String pathToCreate = Text.getRelativeParent(targetPath, 1);
                    String nodeType = "sling:Folder";
                    if (session.getNode(root).isNodeType("sling:OrderedFolder")) {
                        nodeType = "sling:OrderedFolder";
                    }
                    JcrResourceUtil.createPath(pathToCreate, nodeType, nodeType, session, false);
                }
                if (!session.nodeExists(targetPath)) {
                    Resource destinationResource = pageManager.copy(sourceResource, targetPath, null, false, false, false);
                    DamLanguageUtil.deleteInsightData(destinationResource.getPath(), resourceResolver);
                    Node targetNode = session.getNode(languageRootPath);
                    if (targetNode != null) {
                        Node content;
                        if (!targetNode.hasNode("jcr:content")) {
                            targetNode.addNode("jcr:content", "nt:unstructured");
                        }
                        if (!(content = targetNode.getNode("jcr:content")).hasProperty("jcr:title")) {
                            String displayLanguage = LanguageUtil.getLanguage(targetLanguageCodes[i]).getLocale().getDisplayLanguage();
                            content.setProperty("jcr:title", displayLanguage);
                        }
                        String tempAddTitlePath = contentPath.substring(0, contentPath.lastIndexOf(47));
                        while (tempAddTitlePath.length() > 0) {
                            Node tempNode = session.getNode(languageRootPath + tempAddTitlePath);
                            if (tempNode == null) continue;
                            if (!tempNode.hasNode("jcr:content")) {
                                tempNode.addNode("jcr:content", "nt:unstructured");
                            }
                            Node tempNodeContent = tempNode.getNode("jcr:content");
                            String sourceNodeForTitle = null;
                            sourceNodeForTitle = createNewLanguageRoot ? parentOfRoot + tempAddTitlePath : root + tempAddTitlePath;
                            if (!tempNodeContent.hasProperty("jcr:title")) {
                                String tempNodeTitle = UIHelper.getTitle(resourceResolver.getResource(sourceNodeForTitle));
                                tempNodeContent.setProperty("jcr:title", tempNodeTitle);
                            }
                            tempAddTitlePath = tempAddTitlePath.substring(0, tempAddTitlePath.lastIndexOf(47));
                        }
                    }
                } else {
                    log.info("Could not create language copy for assets at path: " + targetPath + ", resource already exists. Updating language copy.");
                    Asset sourceAsset = resourceResolver.getResource(sourcePath).adaptTo(Asset.class);
                    Asset targetAsset = resourceResolver.getResource(targetPath).adaptTo(Asset.class);
                    if (sourceAsset != null && targetAsset != null && DamLanguageUtil.isSmartAssetUpdateRequired(sourceAsset, targetAsset)) {
                        DamLanguageUtil.addSmartAssetUpdateSource(targetAsset, sourcePath);
                    }
                }
                createdCopies.add(targetPath);
                continue;
            }
            catch (Exception e) {
                log.error("error while creating language copy for assets at path: " + languageCopyPath + "{}", (Throwable)e);
            }
        }
        return createdCopies;
    }

    private static Asset findLanguageCopy(String assetPath, String languageCode, ResourceResolver resolver) {
        Resource assetResource = resolver.getResource(assetPath);
        if (assetResource == null || assetResource.adaptTo(Asset.class) == null) {
            return null;
        }
        Asset asset = null;
        String languageRootPath = LanguageUtil.getLanguageRoot(assetPath);
        if (languageRootPath == null) {
            return null;
        }
        String contentPath = assetPath.replaceFirst(languageRootPath, "");
        String languageRootParentPath = Text.getRelativeParent(languageRootPath, 1);
        String assetPathLC = languageRootParentPath + "/" + languageCode + contentPath;
        Resource assetResourceLC = resolver.getResource(assetPathLC);
        if (assetResourceLC != null) {
            asset = assetResourceLC.adaptTo(Asset.class);
        }
        return asset;
    }

    @Deprecated
    public static String getLanguageRoot(String path) {
        if (path == null || path.length() == 0 || path.equals("/")) {
            return null;
        }
        path = path + "/";
        int idx = path.indexOf(47, 1);
        while (idx > 0) {
            String namelocale;
            Locale locale;
            String subPath = path.substring(0, idx);
            String name = Text.getName(subPath);
            if (name.contains("-") && (locale = LanguageUtil.getLocale(namelocale = name.substring(name.lastIndexOf("-") + 1))) != null) {
                return subPath;
            }
            idx = path.indexOf(47, idx + 1);
        }
        return null;
    }

    @Deprecated
    public static Language getLanguage(String path) {
        if ((path = DamLanguageUtil.getLanguageRoot(path)) != null) {
            String languageRoot = path.substring(path.lastIndexOf("-") + 1);
            return new Language(languageRoot);
        }
        return null;
    }

    public static Collection<Resource> getLanguageRoots(ResourceResolver resolver, String path) {
        String root = LanguageUtil.getLanguageRoot(path);
        if (root == null) {
            return Collections.emptySet();
        }
        String parent = Text.getRelativeParent(root, 1);
        Resource parentResource = resolver.getResource(parent);
        if (parentResource == null) {
            return Collections.emptySet();
        }
        LinkedList<Resource> resources = new LinkedList<Resource>();
        Iterator<Resource> iter = resolver.listChildren(parentResource);
        while (iter.hasNext()) {
            Resource r = iter.next();
            Locale locale = LanguageUtil.getLocale(Text.getName(r.getPath()));
            if (locale == null) continue;
            resources.add(r);
        }
        return resources;
    }

    public static String createUpdateLanguageCopy(ResourceResolver resourceResolver, PageManagerFactory pageManagerFactory, String sourcePath, String targetLanguageCode, String prefixPath) {
        Session session = resourceResolver.adaptTo(Session.class);
        PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        String createdCopy = "";
        String languageCopyPath = "";
        String contentPath = "";
        if (targetLanguageCode == null || targetLanguageCode.trim().length() == 0) {
            log.error("Failed to load destination language from payload.");
            return null;
        }
        String root = LanguageUtil.getLanguageRoot(sourcePath);
        String parentOfRoot = null;
        boolean createNewLanguageRoot = false;
        if (root == null) {
            log.debug("Language root does not exist for asset at path: {} and would be created. ", (Object)sourcePath);
            if (Text.getRelativeParent(sourcePath, 1).equals("/content/dam")) {
                createNewLanguageRoot = true;
                parentOfRoot = "/content/dam";
                root = "/content/dam";
            } else if (sourcePath.startsWith("/content/dam/")) {
                int parentOfRootPathLength = sourcePath.indexOf(47, "/content/dam".length() + 1);
                int oldRootPathLength = sourcePath.indexOf(47, parentOfRootPathLength);
                if (parentOfRootPathLength < 0 || sourcePath.length() <= parentOfRootPathLength) {
                    return createdCopy;
                }
                createNewLanguageRoot = true;
                parentOfRoot = sourcePath.substring(0, parentOfRootPathLength);
                if (oldRootPathLength > 0 && sourcePath.length() > oldRootPathLength) {
                    root = sourcePath.substring(0, oldRootPathLength);
                }
            }
            log.info("Parent of New Language root at path {} added for asset at path {}", (Object)parentOfRoot, (Object)sourcePath);
            contentPath = sourcePath.replaceFirst(parentOfRoot, "");
        } else {
            contentPath = sourcePath.replaceFirst(root, "");
            parentOfRoot = Text.getRelativeParent(root, 1);
        }
        String targetPath = "";
        String languageRootPath = "";
        languageRootPath = prefixPath + parentOfRoot + "/" + targetLanguageCode;
        targetPath = languageRootPath + contentPath;
        try {
            String pathToCreate = Text.getRelativeParent(targetPath, 1);
            String nodeType = "sling:Folder";
            if (session.getNode(root).isNodeType("sling:OrderedFolder")) {
                nodeType = "sling:OrderedFolder";
            }
            JcrResourceUtil.createPath(pathToCreate, nodeType, nodeType, session, false);
            if (DamUtil.isAsset(sourceResource)) {
                Resource destinationResource = pageManager.copy(sourceResource, targetPath, null, false, true, false);
                DamLanguageUtil.deleteInsightData(destinationResource.getPath(), resourceResolver);
                DamLanguageUtil.removeAllRenditionsInsideResource(destinationResource);
                String destinationForTemporaryAsset = parentOfRoot + "/" + targetLanguageCode + contentPath;
                DamLanguageUtil.setDestinationLanguageCopyPath(destinationResource, destinationForTemporaryAsset);
                createdCopy = destinationResource.getPath();
            } else if (DamLanguageUtil.isFolder(sourceResource)) {
                String sourceFolderPath = sourceResource.getPath();
                String destinationFolderPath = parentOfRoot + "/" + targetLanguageCode + contentPath;
                Iterator<Asset> assetIterator = DamUtil.getAssets(sourceResource);
                while (assetIterator.hasNext()) {
                    String assetPath = assetIterator.next().getPath();
                    String destinationAssetPath = assetPath.replaceFirst(sourceFolderPath, destinationFolderPath);
                    String temporaryAssetPath = prefixPath + destinationAssetPath;
                    Resource assetResource = resourceResolver.getResource(assetPath);
                    Resource destinationResource = pageManager.copy(assetResource, temporaryAssetPath, null, false, true, false);
                    DamLanguageUtil.deleteInsightData(destinationResource.getPath(), resourceResolver);
                    DamLanguageUtil.removeAllRenditionsInsideResource(destinationResource);
                    DamLanguageUtil.setDestinationLanguageCopyPath(destinationResource, destinationAssetPath);
                }
                createdCopy = targetPath;
            }
            Node targetNode = session.getNode(languageRootPath);
            if (targetNode != null) {
                Node content;
                if (!targetNode.hasNode("jcr:content")) {
                    targetNode.addNode("jcr:content", "nt:unstructured");
                }
                if (!(content = targetNode.getNode("jcr:content")).hasProperty("jcr:title")) {
                    String displayLanguage = LanguageUtil.getLanguage(targetLanguageCode).getLocale().getDisplayLanguage();
                    content.setProperty("jcr:title", displayLanguage);
                }
                String tempAddTitlePath = contentPath.substring(0, contentPath.lastIndexOf(47));
                while (tempAddTitlePath.length() > 0) {
                    Node tempNode = session.getNode(languageRootPath + tempAddTitlePath);
                    if (tempNode == null) continue;
                    if (!tempNode.hasNode("jcr:content")) {
                        tempNode.addNode("jcr:content", "nt:unstructured");
                    }
                    Node tempNodeContent = tempNode.getNode("jcr:content");
                    String sourceNodeForTitle = null;
                    sourceNodeForTitle = createNewLanguageRoot ? parentOfRoot + tempAddTitlePath : root + tempAddTitlePath;
                    if (!tempNodeContent.hasProperty("jcr:title")) {
                        String tempNodeTitle = UIHelper.getTitle(resourceResolver.getResource(sourceNodeForTitle));
                        tempNodeContent.setProperty("jcr:title", tempNodeTitle);
                    }
                    tempAddTitlePath = tempAddTitlePath.substring(0, tempAddTitlePath.lastIndexOf(47));
                }
            }
            session.save();
        }
        catch (Exception e) {
            log.error("error while creating language copy for assets at path: " + languageCopyPath + "{}", (Throwable)e);
        }
        return createdCopy;
    }

    private static void deleteInsightData(String resourcePath, ResourceResolver resourceResolver) {
        Resource resource = resourceResolver.getResource(resourcePath);
        if (resource != null) {
            if (DamUtil.isAsset(resource)) {
                DamLanguageUtil.deleteResource(resourcePath + ASSET_PERFORMANCE_NODE_RELATIVE_PATH, resourceResolver);
                DamLanguageUtil.deleteResource(resourcePath + ASSET_USAGE_NODE_RELATIVE_PATH, resourceResolver);
            } else if (DamLanguageUtil.isFolder(resource)) {
                Iterator<Asset> assetIterator = DamUtil.getAssets(resource);
                while (assetIterator.hasNext()) {
                    String assetPath = assetIterator.next().getPath();
                    DamLanguageUtil.deleteResource(assetPath + ASSET_PERFORMANCE_NODE_RELATIVE_PATH, resourceResolver);
                    DamLanguageUtil.deleteResource(assetPath + ASSET_USAGE_NODE_RELATIVE_PATH, resourceResolver);
                }
            }
        }
    }

    private static void deleteResource(String path, ResourceResolver resourceResolver) {
        Resource resource = resourceResolver.getResource(path);
        if (resource != null) {
            try {
                resourceResolver.delete(resource);
            }
            catch (PersistenceException e) {
                log.error("Unable to delete resource from {} : {}", (Object)resource, (Object)e.getMessage());
            }
        }
    }

    private static void setDestinationLanguageCopyPath(Resource temporaryResource, String destinationPath) throws RepositoryException {
        Node temporaryNode = temporaryResource.adaptTo(Node.class);
        if (!temporaryNode.hasNode("jcr:content")) {
            temporaryNode.addNode("jcr:content", "nt:unstructured");
        }
        Node destinationContentNode = temporaryNode.getNode("jcr:content");
        destinationContentNode.setProperty(ATTRIBUTE_DESTINATION_LANGUAGE_COPY_PATH, destinationPath);
    }

    private static boolean isFolder(Resource resource) {
        Node n = resource.adaptTo(Node.class);
        try {
            return n.isNodeType("nt:folder");
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Deprecated
    public static void moveUpdatedAsset(String sourcePath, String destinationPath, Session userSession, PageManagerFactory pageManagerFactory, ResourceResolverFactory resolverFactory) {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        authInfo.put("user.jcr.session", userSession);
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = resolverFactory.getResourceResolver(authInfo);
            Resource sourceResource = resourceResolver.getResource(sourcePath);
            Resource destinationResource = resourceResolver.getResource(destinationPath);
            Asset sourceAsset = DamUtil.resolveToAsset(sourceResource);
            PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
            if (destinationResource == null) {
                String pathToCreate = Text.getRelativeParent(destinationPath, 1);
                String nodeType = "sling:Folder";
                JcrResourceUtil.createPath(pathToCreate, nodeType, nodeType, userSession, false);
                pageManager.copy(sourceResource, destinationPath, null, false, false, true);
            } else {
                Asset destinationAsset = DamUtil.resolveToAsset(destinationResource);
                destinationAsset.addRendition("original", sourceAsset.getOriginal().getStream(), sourceAsset.getMimeType());
            }
            userSession.save();
        }
        catch (Exception e) {
            log.error("Unable to move updated asset {}", (Object)e.getMessage());
        }
    }

    public static void moveUpdatedAsset(String sourcePath, String destinationPath, Session userSession, PageManagerFactory pageManagerFactory, ResourceResolver resourceResolver) {
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put("user.jcr.session", userSession);
        try {
            Resource sourceResource = resourceResolver.getResource(sourcePath);
            Resource destinationResource = resourceResolver.getResource(destinationPath);
            Asset sourceAsset = DamUtil.resolveToAsset(sourceResource);
            if (sourceAsset != null) {
                PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
                if (destinationResource == null) {
                    String pathToCreate = Text.getRelativeParent(destinationPath, 1);
                    String nodeType = "sling:Folder";
                    JcrResourceUtil.createPath(pathToCreate, nodeType, nodeType, userSession, false);
                    pageManager.copy(sourceResource, destinationPath, null, false, false, true);
                } else {
                    Asset destinationAsset = DamUtil.resolveToAsset(destinationResource);
                    if (destinationAsset != null) {
                        destinationAsset.addRendition("original", sourceAsset.getOriginal().getStream(), sourceAsset.getMimeType());
                    } else {
                        log.error("Unable to move updated asset : Destination Asset not found");
                    }
                }
                userSession.save();
            } else {
                log.error("Unable to move updated asset : Source Asset not found");
            }
        }
        catch (Exception e) {
            log.error("Unable to move updated asset {}", (Object)e.getMessage());
        }
    }

    public static void replaceUpdatedAsset(String sourcePath, String destinationPath, Session userSession, PageManagerFactory pageManagerFactory, ResourceResolver resourceResolver) {
        try {
            Resource sourceResource = resourceResolver.getResource(sourcePath);
            Resource destinationResource = resourceResolver.getResource(destinationPath);
            Asset sourceAsset = sourceResource.adaptTo(Asset.class);
            if (sourceAsset != null && !DamLanguageUtil.isContentFragment(sourceAsset)) {
                DamLanguageUtil.addExtractMetadataPropertyForAsset(sourceAsset, false);
            }
            if (sourceResource != null) {
                PageManager pageManager = pageManagerFactory.getPageManager(resourceResolver);
                if (destinationResource == null) {
                    String pathToCreate = Text.getRelativeParent(destinationPath, 1);
                    String nodeType = "sling:Folder";
                    JcrResourceUtil.createPath(pathToCreate, nodeType, nodeType, userSession, false);
                    pageManager.copy(sourceResource, destinationPath, null, false, false, true);
                } else {
                    Asset destinationAsset = resourceResolver.getResource(destinationPath).adaptTo(Asset.class);
                    if (destinationAsset != null) {
                        destinationAsset.createRevision("", ASSET_VERSION_MESSAGE);
                        DamLanguageUtil.copyInsightData(destinationResource.getPath(), sourceResource.getPath(), resourceResolver, pageManager);
                        DamLanguageUtil.deleteAllChildren(destinationResource, userSession);
                        DamLanguageUtil.copyAllChildren(sourceResource, destinationResource, pageManager, userSession);
                    } else {
                        log.error("Unable to move updated asset : Destination is not an Asset");
                    }
                }
                userSession.save();
            } else {
                log.error("Unable to move updated asset : Source Resource not found");
            }
        }
        catch (Exception e) {
            log.error("Unable to move updated asset {}", (Object)e.getMessage());
        }
    }

    private static void copyInsightData(String sourcePath, String destinationPath, ResourceResolver resourceResolver, PageManager pageManager) {
        DamLanguageUtil.copyResource(sourcePath + ASSET_PERFORMANCE_NODE_RELATIVE_PATH, destinationPath + ASSET_PERFORMANCE_NODE_RELATIVE_PATH, resourceResolver, pageManager);
        DamLanguageUtil.copyResource(sourcePath + ASSET_USAGE_NODE_RELATIVE_PATH, destinationPath + ASSET_USAGE_NODE_RELATIVE_PATH, resourceResolver, pageManager);
    }

    private static void copyResource(String sourcePath, String destinationPath, ResourceResolver resourceResolver, PageManager pageManager) {
        Resource sourceResource = resourceResolver.getResource(sourcePath);
        if (sourceResource != null) {
            try {
                pageManager.copy(sourceResource, destinationPath, null, false, false, false);
            }
            catch (WCMException e) {
                log.error("Unable to copy resource from " + sourcePath + " to " + destinationPath + " : {}", (Object)e.getMessage());
            }
        }
    }

    private static void copyAllChildren(Resource sourceResource, Resource destinationResource, PageManager pageManager, Session session) throws RepositoryException, WCMException {
        if (sourceResource != null && destinationResource != null) {
            Iterable<Resource> childList = sourceResource.getChildren();
            String destinationResourcePath = destinationResource.getPath();
            for (Resource child : childList) {
                String destinationChildPath = destinationResourcePath + "/" + child.getName();
                pageManager.copy(child, destinationChildPath, null, false, false, false);
            }
            session.save();
        }
    }

    private static void deleteAllChildren(Resource resource, Session session) throws RepositoryException {
        if (resource != null) {
            Iterable<Resource> childList = resource.getChildren();
            for (Resource child : childList) {
                Node childNode = child.adaptTo(Node.class);
                childNode.remove();
            }
        }
        session.save();
    }

    private static void removeAllRenditionsInsideResource(Resource resource) throws RepositoryException {
        Iterator<Asset> assets = DamUtil.getAssets(resource);
        while (assets.hasNext()) {
            Asset asset = assets.next();
            if (DamLanguageUtil.isContentFragment(asset)) continue;
            List<Rendition> renditions = asset.getRenditions();
            for (Rendition rendition : renditions) {
                String name = rendition.getName();
                if (name.equals("original")) continue;
                asset.removeRendition(name);
            }
        }
    }

    private static boolean isContentFragment(Asset asset) throws RepositoryException {
        Node assetNode = asset.adaptTo(Node.class);
        Node jcrNode = assetNode.getNode("jcr:content");
        if (jcrNode.hasProperty(CONTENT_FRAGMENT)) {
            return jcrNode.getProperty(CONTENT_FRAGMENT).getBoolean();
        }
        return false;
    }

    public static boolean isSmartAssetUpdateRequired(Asset sourceAsset, Asset destinationAsset) {
        if (sourceAsset == null || destinationAsset == null) {
            return false;
        }
        return sourceAsset.getLastModified() > destinationAsset.getLastModified();
    }

    @Deprecated
    public static void addSmartAssetUpdateFlag(Asset destinationAsset) throws RepositoryException {
        Node assetNode = destinationAsset.adaptTo(Node.class);
        if (!assetNode.hasNode("jcr:content")) {
            assetNode.addNode("jcr:content", "nt:unstructured");
        }
        Node assetContentNode = assetNode.getNode("jcr:content");
        assetContentNode.setProperty(ATTRIBUTE_ASSET_UPDATE_REQUIRED, true);
    }

    public static void addSmartAssetUpdateSource(Asset destinationAsset, String sourcePath) throws RepositoryException {
        if (destinationAsset == null || sourcePath == null) {
            return;
        }
        Node assetNode = destinationAsset.adaptTo(Node.class);
        if (!assetNode.hasNode("jcr:content")) {
            assetNode.addNode("jcr:content", "nt:unstructured");
        }
        Node assetContentNode = assetNode.getNode("jcr:content");
        assetContentNode.setProperty(ATTRIBUTE_SMART_ASSET_UPDATE_SOURCE, sourcePath);
    }

    private static void addExtractMetadataPropertyForAsset(Asset asset, boolean bExtractMetadata) throws RepositoryException {
        Node assetNode = asset.adaptTo(Node.class);
        if (!assetNode.hasNode("jcr:content")) {
            assetNode.addNode("jcr:content", "nt:unstructured");
        }
        Node assetContentNode = assetNode.getNode("jcr:content");
        assetContentNode.setProperty(ATTRIBUTE_EXTRACT_METADATA, bExtractMetadata);
    }
}

