/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.s7dam.config.DynamicMediaServicesConfig;
import java.util.Calendar;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMediaServicesConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicMediaServicesConfigUtil.class);
    private static final int REGISTRATION_EXPIRES_SECONDS = 10800;
    private static byte[] key = new byte[]{111, 110, 39, 116, 32, 102, 111, 114, 103, 101, 116, 32, 116, 111, 100, 114};

    public static boolean isDynamicMediaServiceConfigured(ResourceResolver resolver) {
        return DynamicMediaServicesConfigUtil.isDynamicMediaServiceConfigured(resolver, null);
    }

    public static boolean isDynamicMediaServiceConfigured(ResourceResolver resolver, String assetPath) {
        return DynamicMediaServicesConfigUtil.getDefaultConfig(resolver, assetPath) != null;
    }

    public static DynamicMediaServicesConfig getDefaultConfig(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, null);
    }

    public static DynamicMediaServicesConfig getDefaultConfig(ResourceResolver resourceResolver, String assetPath) {
        Resource cloudResource;
        String tenantId;
        Tenant tenant;
        String suffix = "";
        if (assetPath != null && (tenant = DynamicMediaServicesConfigUtil.getTenant(resourceResolver, assetPath)) != null && (tenantId = tenant.getId()) != null && tenantId.length() > 0) {
            suffix = "/" + tenantId;
        }
        if ((cloudResource = resourceResolver.getResource("/etc/cloudservices/dynamicmediaservices" + suffix)) != null) {
            Iterator<Resource> dmConfigResourceIter = cloudResource.listChildren();
            while (dmConfigResourceIter.hasNext()) {
                DynamicMediaServicesConfig config = dmConfigResourceIter.next().adaptTo(DynamicMediaServicesConfig.class);
                if (config == null || StringUtils.isEmpty((String)config.getRegistrationId()) || StringUtils.isEmpty((String)config.getServiceUrl())) continue;
                return config;
            }
        }
        return null;
    }

    public static String getRegistrationId(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getRegistrationId(resourceResolver, null);
    }

    public static String getRegistrationId(ResourceResolver resourceResolver, String assetPath) {
        DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, assetPath);
        Calendar cal = Calendar.getInstance();
        long registrationTimeout = cal.getTimeInMillis() + 10800000L;
        try {
            if (config != null) {
                return DynamicMediaServicesConfigUtil.encrypt(config.getRegistrationId() + "|" + String.valueOf(registrationTimeout));
            }
        }
        catch (Exception e) {
            LOG.error("Failed while creating encrypted key [{}]", (Object)e.getMessage());
        }
        return null;
    }

    private static String encrypt(String strToEncrypt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            cipher.init(1, secretKey);
            String enc = Base64.encodeBase64String((byte[])cipher.doFinal(strToEncrypt.getBytes()));
            return enc.replaceAll("/", "_slash_").replaceAll("\\?", "_qmark_");
        }
        catch (Exception e) {
            LOG.error("Error while encrypting", (Throwable)e);
            return null;
        }
    }

    public static String getPublicKey(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getPublicKey(resourceResolver, null);
    }

    public static String getPublicKey(ResourceResolver resourceResolver, String assetPath) {
        try {
            String regId;
            DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, assetPath);
            if (config != null && StringUtils.isNotBlank((String)(regId = config.getRegistrationId())) && regId.contains("|")) {
                return StringUtils.substringAfter((String)regId, (String)"|");
            }
        }
        catch (Exception e) {
            LOG.error("Failed while extracting public key [{}]", (Object)e.getMessage());
        }
        return null;
    }

    public static String getServiceUrl(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getServiceUrl(resourceResolver, null);
    }

    public static String getServiceUrl(ResourceResolver resourceResolver, String assetPath) {
        String videoServiceUrl = null;
        DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, assetPath);
        if (config != null) {
            videoServiceUrl = config.getServiceUrl();
            if (videoServiceUrl.length() > 0) {
                return videoServiceUrl;
            }
        } else {
            try {
                String path = "/etc/cloudservices/dynamicmediaservices/jcr:content";
                Resource res = resourceResolver.getResource(path);
                Node node = res.adaptTo(Node.class);
                if (node.hasProperty("serviceUrl")) {
                    videoServiceUrl = node.getProperty("serviceUrl").getString();
                }
            }
            catch (PathNotFoundException e) {
                LOG.error("videoServiceUrl access error {}", (Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.error("videoServiceUrl access error {}", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error("videoServiceUrl access error {}", (Throwable)e);
            }
        }
        return videoServiceUrl;
    }

    public static String getImageServiceUrl(ResourceResolver resourceResolver) {
        return DynamicMediaServicesConfigUtil.getImageServiceUrl(resourceResolver, null);
    }

    public static String getImageServiceUrl(ResourceResolver resourceResolver, String assetPath) {
        String imageServiceUrl = "";
        DynamicMediaServicesConfig config = DynamicMediaServicesConfigUtil.getDefaultConfig(resourceResolver, assetPath);
        if (config != null) {
            imageServiceUrl = config.getImageServiceUrl();
        }
        return imageServiceUrl;
    }

    private static Tenant getTenant(ResourceResolver resourceResolver, String assetPath) {
        if (assetPath != null) {
            Resource assetResource = resourceResolver.getResource(assetPath);
            return assetResource.adaptTo(Tenant.class);
        }
        return null;
    }
}

