/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GQLConverter {
    private static final String OR_OP = "OR";
    private static final String TAGS_PROP = "tags";
    private static final String DATERANGE_PRED = "daterange";
    private static final String RANGEPROP_PRED = "rangeproperty";
    private static final String JCR_PROPERTIES_PATH = "/apps/dam/content/formitems";
    private static final Logger log = LoggerFactory.getLogger(GQLConverter.class);

    public static PredicateGroup buildQuery(Map conditions, ResourceResolver resolver) throws RepositoryException {
        PredicateGroup rootGrp = PredicateConverter.createPredicates(conditions);
        List<String> gqlExpressions = GQLConverter.getValidGQLStatements(rootGrp);
        if (gqlExpressions.size() > 0) {
            for (String expression : gqlExpressions) {
                PredicateGroup gqlPredicateGroup = PredicateConverter.createPredicatesFromGQL(expression.replace("*", "%"));
                GQLConverter.transformPredicates(gqlPredicateGroup, GQLConverter.getJcrPropertyMapping(resolver));
                rootGrp.addAll(gqlPredicateGroup);
            }
        }
        return rootGrp;
    }

    public static void populateGqlfacets(Resource sourceNode, Resource destinationNode) {
        if (sourceNode == null) {
            log.error("source node null, skipping GQL facets extraction");
            return;
        }
        try {
            GQLConverter.findGqlFacets(sourceNode, destinationNode);
        }
        catch (PersistenceException e) {
            log.error("Error while GQL facets extraction" + e.getMessage(), (Throwable)e);
        }
    }

    private static List<String> getValidGQLStatements(PredicateGroup predicateGroup) {
        ArrayList<String> gqlExpressions = new ArrayList<String>();
        if (predicateGroup == null) {
            return gqlExpressions;
        }
        for (int i = 0; i < predicateGroup.size(); ++i) {
            String fulltext;
            Predicate predicate;
            if (predicateGroup.get(i) instanceof PredicateGroup) {
                gqlExpressions.addAll(GQLConverter.getValidGQLStatements((PredicateGroup)predicateGroup.get(i)));
                continue;
            }
            if (!(predicateGroup.get(i) instanceof Predicate) || !"fulltext".equals((predicate = predicateGroup.get(i)).getType()) || (fulltext = predicate.get("fulltext", "")) == null || !fulltext.contains(":") && !fulltext.contains(OR_OP)) continue;
            gqlExpressions.add(fulltext);
            predicateGroup.remove(i);
        }
        return gqlExpressions;
    }

    private static Map<String, String> getJcrPropertyMapping(ResourceResolver resolver) throws RepositoryException {
        HashMap<String, String> jcrPropertyMap = new HashMap<String, String>();
        if (resolver == null) {
            log.warn("Resource resolver is null, skipping property name conversion");
            return jcrPropertyMap;
        }
        Resource formItemsNode = resolver.getResource(GQLConverter.getGqlFacetsDir(resolver));
        Iterator<Resource> itr = formItemsNode.listChildren();
        while (itr.hasNext()) {
            ValueMap prop = itr.next().adaptTo(ValueMap.class);
            if (prop == null || !prop.containsKey("fieldLabel") || !prop.containsKey("name")) continue;
            jcrPropertyMap.put(prop.get("fieldLabel").toString().toLowerCase().trim().replace(" ", ""), prop.get("name").toString());
        }
        return jcrPropertyMap;
    }

    private static String getGqlFacetsDir(ResourceResolver resolver) {
        String gqlFacetsDir = JCR_PROPERTIES_PATH;
        Tenant tenant = resolver.adaptTo(Tenant.class);
        if (tenant != null && tenant.getProperty("dam:gqlFacetsHome") != null) {
            gqlFacetsDir = tenant.getProperty("dam:gqlFacetsHome").toString();
        }
        return gqlFacetsDir;
    }

    private static void transformPredicates(PredicateGroup predicateGroup, Map<String, String> jcrPropertyMap) {
        if (predicateGroup == null) {
            return;
        }
        for (int i = 0; i < predicateGroup.size(); ++i) {
            if (predicateGroup.get(i) instanceof PredicateGroup) {
                PredicateGroup optionalGrp = (PredicateGroup)predicateGroup.get(i);
                GQLConverter.transformPredicates(optionalGrp, jcrPropertyMap);
                predicateGroup.set(i, optionalGrp);
                continue;
            }
            if (!(predicateGroup.get(i) instanceof Predicate)) continue;
            Predicate predicate = predicateGroup.get(i);
            GQLConverter.modifyPredicate(predicateGroup, predicate, i, jcrPropertyMap);
        }
    }

    private static void modifyPredicate(PredicateGroup parentGroup, Predicate predicate, int index, Map<String, String> jcrPropertyMap) {
        String property = predicate.get("property");
        if ("property".equals(predicate.getType())) {
            String value = predicate.get("value");
            if (property.equals(TAGS_PROP)) {
                property = jcrPropertyMap.containsKey(property.toLowerCase()) ? jcrPropertyMap.get(property.toLowerCase()) : property;
                predicate = new Predicate("tagsearch");
                predicate.set("property", property);
                predicate.set("tagsearch", value);
            } else {
                property = jcrPropertyMap.containsKey(property.toLowerCase()) ? jcrPropertyMap.get(property.toLowerCase()) : property;
                predicate.set("property", property);
                predicate.set("value", value);
                predicate.set("operation", "like");
            }
        } else if (DATERANGE_PRED.equals(predicate.getType()) || RANGEPROP_PRED.equals(predicate.getType())) {
            property = jcrPropertyMap.containsKey(property) ? jcrPropertyMap.get(property) : property;
            predicate.set("property", property);
            predicate.set("lowerOperation", ">=");
            predicate.set("upperOperation", "<=");
        }
        parentGroup.set(index, predicate);
    }

    private static void findGqlFacets(Resource sourceNode, Resource destinationNode) throws PersistenceException {
        if (sourceNode == null) {
            return;
        }
        Iterator<Resource> itr = sourceNode.listChildren();
        while (itr.hasNext()) {
            ValueMap childProps;
            Resource childNode = itr.next();
            ValueMap valueMap = childProps = childNode != null ? childNode.adaptTo(ValueMap.class) : null;
            if (childProps != null) {
                String desNodeName;
                String jcrProperty = (String)((Object)childProps.get("name", String.class));
                String facetName = (String)((Object)childProps.get("fieldLabel", String.class));
                if (jcrProperty != null && facetName != null && destinationNode.getChild(desNodeName = JcrUtil.createValidName(facetName)) == null) {
                    jcrProperty = jcrProperty.length() > 2 && jcrProperty.startsWith("./") ? jcrProperty.substring(2) : jcrProperty;
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("fieldLabel", facetName);
                    props.put("name", jcrProperty);
                    destinationNode.getResourceResolver().create(destinationNode, desNodeName, props);
                }
            }
            GQLConverter.findGqlFacets(childNode, destinationNode);
        }
    }
}

