/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.granite.confmgr.Conf;
import com.day.cq.dam.commons.schemaforms.internal.TabList;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.tenant.Tenant;

public class SchemaFormHelper {
    @Deprecated
    public static List<Resource> getMasterForms(Resource currentForm, String formsBaseDirPath) throws RepositoryException {
        ResourceResolver resolver = currentForm.getResourceResolver();
        String currentResourcePath = currentForm.getPath();
        String appsDIr = SchemaFormHelper.getAppsDir(resolver);
        String APPS_BASE_DIR = appsDIr + "/" + formsBaseDirPath;
        String APPS_BASE_DIR_NON_TENANT = "/apps/" + formsBaseDirPath;
        String LIBS_BASE_DIR = "/libs/" + formsBaseDirPath;
        ArrayList<Resource> masterFormsList = new ArrayList<Resource>();
        String path = currentResourcePath;
        Resource res = currentForm;
        while (!(path.equals(APPS_BASE_DIR) || path.equals(LIBS_BASE_DIR) || path.equals(APPS_BASE_DIR_NON_TENANT))) {
            path = (res = res.getParent()).getPath();
            String relativePath = path.startsWith("/libs") ? path.substring("/libs".length()) : (path.startsWith(appsDIr) ? path.substring(appsDIr.length()) : path.substring("/apps".length()));
            Resource resToVerify = resolver.getResource(appsDIr + relativePath);
            if (resToVerify != null && resToVerify.getChild("items/tabs") != null) {
                masterFormsList.add(resToVerify);
                continue;
            }
            resToVerify = resolver.getResource("/apps" + relativePath);
            if (resToVerify != null && resToVerify.getChild("items/tabs") != null) {
                masterFormsList.add(resToVerify);
                continue;
            }
            resToVerify = resolver.getResource("/libs" + relativePath);
            if (resToVerify == null) continue;
            masterFormsList.add(resToVerify);
        }
        Collections.reverse(masterFormsList);
        return masterFormsList;
    }

    public static String[] getBaseFormPaths(ResourceResolver resourceResolver) {
        Tenant tenant = resourceResolver.adaptTo(Tenant.class);
        String schemaExtHome = null != tenant ? (String)tenant.getProperty("metadataschema.home") : "/conf/global/settings/dam/adminui-extension/metadataschema";
        String schemaHome = "/libs/dam/content/schemaeditors/forms";
        Resource schemaExtHomeRes = resourceResolver.getResource(schemaExtHome);
        if (null == schemaExtHome || schemaExtHome.trim().isEmpty() || schemaExtHomeRes == null) {
            schemaExtHome = "/conf/global/settings/dam/adminui-extension/metadataschema";
        } else {
            Conf conf = schemaExtHomeRes.adaptTo(Conf.class);
            schemaHome = conf.getItem("dam/adminui").get("metadataschema.home", "/libs/dam/content/schemaeditors/forms");
        }
        return new String[]{schemaExtHome, schemaHome};
    }

    private static String getRelativeFormPath(String formPath, String[] baseFormPaths) {
        for (String baseFormPath : baseFormPaths) {
            if (!formPath.startsWith(baseFormPath)) continue;
            String relativePath = formPath.substring(baseFormPath.length());
            relativePath = relativePath.startsWith("/") ? relativePath : relativePath + "/";
            relativePath = relativePath.endsWith("/") ? relativePath.substring(relativePath.length() - 1) : relativePath;
            return relativePath;
        }
        return formPath;
    }

    public static List<Resource> getMasterForms(Resource currentForm) throws RepositoryException {
        ResourceResolver resourceResolver = currentForm.getResourceResolver();
        String[] baseFormPaths = SchemaFormHelper.getBaseFormPaths(resourceResolver);
        String relativePath = SchemaFormHelper.getRelativeFormPath(currentForm.getPath(), baseFormPaths);
        ArrayList<Resource> masterFormsList = new ArrayList<Resource>();
        String string = relativePath = relativePath.trim().isEmpty() ? "" : relativePath.substring(0, relativePath.lastIndexOf(47));
        while (!relativePath.trim().isEmpty()) {
            for (int i = 0; i < baseFormPaths.length; ++i) {
                String baseFormPath = baseFormPaths[i];
                Resource resToVerify = resourceResolver.getResource(baseFormPath + relativePath);
                if (resToVerify == null || i != baseFormPaths.length - 1 && resToVerify.getChild("items/tabs") == null) continue;
                masterFormsList.add(resToVerify);
                break;
            }
            relativePath = relativePath.trim().isEmpty() ? "" : relativePath.substring(0, relativePath.lastIndexOf(47));
        }
        Collections.reverse(masterFormsList);
        return masterFormsList;
    }

    public static Resource mergeFormTabResource(Resource oneTabList, Resource otherTabList) {
        if (oneTabList == null) {
            return otherTabList;
        }
        if (otherTabList == null) {
            return oneTabList;
        }
        TabList aTab = new TabList(oneTabList);
        TabList oTab = new TabList(otherTabList);
        aTab.merge((Resource)oTab);
        return aTab;
    }

    public static Resource getSchemaResource(SlingHttpServletRequest request) {
        String[] baseFormPaths;
        String suffix = request.getRequestPathInfo().getSuffix();
        suffix = suffix == null ? "" : suffix;
        ResourceResolver resourceResolver = request.getResourceResolver();
        for (String baseFormPath : baseFormPaths = SchemaFormHelper.getBaseFormPaths(resourceResolver)) {
            Resource res = resourceResolver.getResource(baseFormPath + suffix);
            if (null == res) continue;
            return res;
        }
        return null;
    }

    private static String getAppsDir(ResourceResolver resolver) {
        String appsDir = "/apps";
        Tenant tenant = resolver.adaptTo(Tenant.class);
        if (tenant != null) {
            appsDir = appsDir + "/" + tenant.getId();
        }
        return appsDir;
    }

    public static Iterator getSchemaFormsIterator(SlingHttpServletRequest request, int rows, int offset) {
        String resName;
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        ResourceResolver resolver = request.getResourceResolver();
        String[] baseFormPaths = SchemaFormHelper.getBaseFormPaths(resolver);
        String suffix = request.getRequestPathInfo().getSuffix();
        suffix = null == suffix ? "" : suffix;
        suffix = SchemaFormHelper.getRelativeFormPath(suffix, baseFormPaths);
        String appsResPath = baseFormPaths[0] + suffix;
        String libsResPath = baseFormPaths[1] + suffix;
        Resource appRes = resolver.getResource(appsResPath);
        Resource libsRes = resolver.getResource(libsResPath);
        if (appRes != null) {
            Iterator<Resource> appIter = appRes.listChildren();
            while (appIter.hasNext()) {
                Resource ar = appIter.next();
                resName = Text.getName(ar.getPath());
                if (libsRes != null && libsRes.getChild(resName) != null || !ar.isResourceType("nt:folder") && !ar.isResourceType("sling:OrderedFolder") && !ar.isResourceType("sling:Folder")) continue;
                resourceList.add(ar);
            }
        }
        if (libsRes != null) {
            Iterator<Resource> libsIter = libsRes.listChildren();
            while (libsIter.hasNext()) {
                Resource lr = libsIter.next();
                resName = Text.getName(lr.getPath());
                if (appRes != null && appRes.getChild(resName) != null && appRes.getChild(resName).getChild("items/tabs") != null) {
                    Resource ar = resolver.getResource(appRes.getPath() + "/" + resName);
                    if (!ar.isResourceType("nt:folder") && !ar.isResourceType("sling:OrderedFolder") && !ar.isResourceType("sling:Folder")) continue;
                    resourceList.add(ar);
                    continue;
                }
                if ((lr.getChild("items/tabs") == null || !lr.isResourceType("nt:folder")) && !lr.isResourceType("sling:OrderedFolder") && !lr.isResourceType("sling:Folder")) continue;
                resourceList.add(lr);
            }
        }
        return resourceList.iterator();
    }
}

