/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.core.AbstractAssetHandler;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=false)
public abstract class AbstractSubAssetHandler
extends AbstractAssetHandler {
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    private static final Logger log = LoggerFactory.getLogger(AbstractSubAssetHandler.class);

    protected Node initializeSubAsset(String parentFilePath, String assetName, InputStream is, Session session, String mimeType, boolean doSave) throws RepositoryException {
        String parentAssetPath = DamUtil.binaryToAssetPath(parentFilePath);
        String subAssetPath = parentAssetPath + "/" + "subassets" + "/" + assetName;
        if (!session.itemExists(parentAssetPath + "/" + "subassets")) {
            Node parent = (Node)session.getItem(parentAssetPath);
            parent.addNode("subassets", "nt:unstructured");
            if (doSave) {
                session.save();
            }
        }
        Asset subAsset = this.getAssetManager(session).createAssetForBinary(subAssetPath, doSave);
        Node renditionFolder = this.getRenditionFolder(subAsset.getPath(), session);
        this.createFileNode(renditionFolder, is, mimeType, doSave);
        return subAsset.adaptTo(Node.class);
    }

    protected Node getRenditionFolder(String path, Session session) throws RepositoryException {
        Asset asset = this.getAssetManager(session).getAssetForBinary(path);
        return asset.adaptTo(Node.class).getNode("jcr:content/renditions");
    }

    protected Node createFileNode(Node parent, InputStream is, String mimeType, boolean doSave) throws RepositoryException {
        if (parent.hasNode("original")) {
            Node content = parent.getNode("original/jcr:content");
            this.setFileContent(content, is, mimeType);
            if (doSave) {
                content.getSession().save();
            }
        } else {
            Node file = parent.addNode("original", "nt:file");
            Node content = file.addNode("jcr:content", "nt:resource");
            this.setFileContent(content, is, mimeType);
            if (doSave) {
                parent.getSession().save();
            }
        }
        return parent.getNode("original");
    }

    protected void setFileContent(Node content, InputStream is, String mimeType) throws RepositoryException {
        content.setProperty("jcr:mimeType", mimeType);
        content.setProperty("jcr:data", content.getSession().getValueFactory().createBinary(is));
        content.setProperty("jcr:lastModified", Calendar.getInstance());
    }

    protected boolean isSubasset(Node node) {
        try {
            return node.getPath().indexOf("/subassets/") > 0;
        }
        catch (RepositoryException e) {
            log.error("isSubAsset: error while determining sub-asset status for asset [{}]: ", (Object)this.safeGetPath(node), (Object)e);
            return false;
        }
    }
}

