/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="process.label", value={"Rasterize PDF and Adobe Illustrator documents to a preview image rendition"})
public class CreatePdfPreviewProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(CreatePdfPreviewProcess.class);
    private static final String OPTION_MIME_TYPES = "MIME_TYPES";
    private static final String OPTION_MAX_WIDTH = "MAX_WIDTH";
    private static final String OPTION_MAX_HEIGHT = "MAX_HEIGHT";
    private static final String OPTION_RESOLUTION = "RESOLUTION";
    private static final String[] DEFAULT_MIME_TYPES = new String[0];
    @Reference
    protected AssetStore assetStore;

    @Override
    public void execute(WorkItem wfItem, WorkflowSession wfSession, MetaDataMap args) throws WorkflowException {
        try {
            Session session = wfSession.getSession();
            Asset asset = this.getAssetFromPayload(wfItem, session);
            if (asset == null) {
                log.debug("Skipping work item, since it's not an asset: {}", (Object)wfItem);
                return;
            }
            List<Object> mimeTypes = Arrays.asList((Object[])args.get(OPTION_MIME_TYPES, DEFAULT_MIME_TYPES));
            if (!mimeTypes.contains(asset.getMimeType())) {
                log.debug("Skipping asset, unsupported mime type: {} ({})", (Object)wfItem, (Object)asset.getMimeType());
                return;
            }
            ValueMapDecorator metadata = new ValueMapDecorator(asset.getMetadata());
            double pageWidth = metadata.get("dam:Physicalwidthininches", 0.0);
            double pageHeight = metadata.get("dam:Physicalheightininches", 0.0);
            if (pageWidth == 0.0 || pageHeight == 0.0) {
                return;
            }
            double maxWidth = CreatePdfPreviewProcess.getClamped(args, OPTION_MAX_WIDTH, 2048.0, 1.0, 32000.0);
            double maxHeight = CreatePdfPreviewProcess.getClamped(args, OPTION_MAX_HEIGHT, 2048.0, 1.0, 32000.0);
            double maxRes = Math.min(maxWidth / pageWidth, maxHeight / pageHeight);
            double res = CreatePdfPreviewProcess.getClamped(args, OPTION_RESOLUTION, 72.0, 1.0, maxRes);
            Dimension dim = new Dimension((int)Math.round(pageWidth * res), (int)Math.round(pageHeight * res));
            Rendition original = asset.getOriginal();
            AssetHandler assetHandler = this.assetStore.getAssetHandler(original.getMimeType());
            BufferedImage image = assetHandler.getImage(original, dim);
            log.info("Rasterized {} to an image with dim {}x{}", new Object[]{original.getPath(), image.getWidth(), image.getHeight()});
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            boolean w = ImageIO.write((RenderedImage)image, "png", out);
            if (w) {
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                asset.setBatchMode(true);
                asset.addRendition("cqdam.preview.png", (InputStream)in, "image/png");
                session.save();
            }
        }
        catch (IOException e) {
            throw new WorkflowException(e);
        }
        catch (RepositoryException e) {
            throw new WorkflowException(e);
        }
    }

    private static double getClamped(MetaDataMap args, String option, double def, double min, double max) {
        double v = args.get(option, def);
        return Math.min(Math.max(v, min), max);
    }

    protected void bindAssetStore(AssetStore assetStore) {
        this.assetStore = assetStore;
    }

    protected void unbindAssetStore(AssetStore assetStore) {
        if (this.assetStore == assetStore) {
            this.assetStore = null;
        }
    }
}

