/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Create Sub Asset"})
public class CreateSubAssetsProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(CreateSubAssetsProcess.class);

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        Asset asset = this.getAssetFromPayload(workItem, workflowSession.getSession());
        if (null != asset) {
            if (!asset.isSubAsset() && !this.isPrintAsset(asset)) {
                AssetHandler handler = this.getAssetHandler(asset.getMimeType());
                handler.processSubAssets(asset);
            } else {
                log.debug("execute: skipping processing of asset [{}], it is already a sub-asset.", (Object)asset.getPath());
            }
        } else {
            String wfPayload = workItem.getWorkflowData().getPayload().toString();
            String message = "execute: cannot create sub-assets, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            throw new WorkflowException(message);
        }
    }

    private boolean isPrintAsset(Asset asset) {
        if (asset.getRendition("cq-indesign-print") != null) {
            return true;
        }
        Iterator<? extends com.adobe.granite.asset.api.Asset> relatedPages = asset.adaptTo(com.adobe.granite.asset.api.Asset.class).listRelated("pages");
        if (relatedPages.hasNext()) {
            com.adobe.granite.asset.api.Asset relatedPage = relatedPages.next();
            return relatedPage.getRendition("cq-indesign-print") != null || StringUtils.endsWithIgnoreCase((String)relatedPage.getRendition("original").getMimeType(), (String)"-indesign");
        }
        return false;
    }
}

