/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.core.process.MetadataExtractor;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(metatype=true)
@Service
@Property(name="process.label", value={"Extract Meta Data"})
public class ExtractMetadataProcess
extends AbstractAssetWorkflowProcess {
    private MetadataExtractor metadataExtractor = new MetadataExtractor();
    private boolean sha1Enabled = false;
    @Property(boolValue={true})
    public static final String ENABLE_SHA1_GEN = "cq.dam.enable.sha1";
    private static final Logger log = LoggerFactory.getLogger(ExtractMetadataProcess.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY)
    protected ContentAwareMimeTypeService contentAwareMimeTypeService;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        block5: {
            try {
                Session session = workflowSession.getSession();
                Asset asset = this.getAssetFromPayload(workItem, session);
                if (null != asset) {
                    asset.setBatchMode(true);
                    AssetHandler handler = this.getAssetHandler(asset.getMimeType());
                    if (null != handler) {
                        this.metadataExtractor.extractMetadata(session, asset, handler, this.sha1Enabled, null != this.contentAwareMimeTypeService ? this.contentAwareMimeTypeService : this.mimeTypeService);
                        session.save();
                    } else {
                        log.error("execute: cannot extract metadata, no handler found for asset [{}] with mime type [{}]", (Object)asset.getPath(), (Object)asset.getMimeType());
                    }
                    break block5;
                }
                String wfPayload = workItem.getWorkflowData().getPayload().toString();
                String message = "execute: cannot extract metadata, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                throw new WorkflowException(message);
            }
            catch (Exception e) {
                log.warn("unexpected error occurred during metadata extraction. Cause: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Activate
    protected void Actiate(ComponentContext context) throws RepositoryException {
        this.sha1Enabled = OsgiUtil.toBoolean(context.getProperties().get(ENABLE_SHA1_GEN), true);
    }

    protected void bindContentAwareMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        this.contentAwareMimeTypeService = contentAwareMimeTypeService;
    }

    protected void unbindContentAwareMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        if (this.contentAwareMimeTypeService == contentAwareMimeTypeService) {
            this.contentAwareMimeTypeService = null;
        }
    }
}

