/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.metadata.SimpleXmpToJcrMetadataBuilder;
import com.day.cq.dam.commons.util.DamMimeUtil;
import com.day.cq.tagging.JcrTagManagerFactory;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataExtractor {
    private static final Logger log = LoggerFactory.getLogger(MetadataExtractor.class);
    private static final String JCR_CONTENT_METADATA = "jcr:content/metadata";
    private static final String JCR_CONTENT_JCR_DATA = "jcr:content/jcr:data";
    private static final String METADATA_PROPERTY_NAME_ADOBE_KEYWORDS = "lr:hierarchicalSubject";
    @Reference
    private JcrTagManagerFactory tagManagerFactory = null;

    public void extractMetadata(Session session, Asset asset, AssetHandler assetHandler, boolean sha1Enabled, MimeTypeService mimeTypeService) throws RepositoryException, IOException {
        Node originalBinary;
        Resource assetResource = asset.adaptTo(Resource.class);
        ResourceResolver resolver = assetResource.getResourceResolver();
        Resource metadataResource = resolver.getResource(assetResource, JCR_CONTENT_METADATA);
        ExtractedMetadata metadata = assetHandler.extractMetadata(asset);
        metadata.setMetaDataProperty("dam:extracted", Calendar.getInstance().getTime());
        Rendition originalRendition = asset.getOriginal();
        if (sha1Enabled) {
            String sha1 = DigestUtils.shaHex((InputStream)originalRendition.getStream());
            metadata.setMetaDataProperty("dam:sha1", sha1);
        }
        if ((originalBinary = originalRendition.adaptTo(Node.class)).hasProperty(JCR_CONTENT_JCR_DATA)) {
            metadata.setMetaDataProperty("dam:size", originalBinary.getProperty(JCR_CONTENT_JCR_DATA).getBinary().getSize());
        }
        this.resetMimetype(asset, metadata, mimeTypeService);
        this.saveMetadata(asset, metadata, metadataResource);
        this.extractHierarchicalSubjects(asset, session, metadataResource);
    }

    protected void saveMetadata(Asset asset, ExtractedMetadata metadata, Resource metadataResource) {
        if (null != metadataResource) {
            SimpleXmpToJcrMetadataBuilder metadataBuilder = new SimpleXmpToJcrMetadataBuilder();
            try {
                metadataBuilder.storeAsXmp(metadata, asset, false);
            }
            catch (Exception e) {
                log.error("saveMetadata: error while saving metdata for asset [{}]: ", (Object)asset.getPath(), (Object)e);
            }
        } else {
            log.error("execute: cannot save metdata for asset [{}], doesn't have metdata node.", (Object)asset.getPath());
        }
    }

    private void resetMimetype(Asset asset, ExtractedMetadata metadata, MimeTypeService mimeTypeService) {
        String mimeType = null;
        try {
            mimeType = DamMimeUtil.getDetectMimeFromContent() ? ((ContentAwareMimeTypeService)mimeTypeService).getMimeType(asset.getName(), asset.getOriginal().getStream()) : mimeTypeService.getMimeType(asset.getName());
        }
        catch (IOException ign) {
            // empty catch block
        }
        if (StringUtils.isNotEmpty(mimeType)) {
            metadata.setMetaDataProperty("dc:format", mimeType);
        }
    }

    private void extractHierarchicalSubjects(Asset asset, Session session, Resource metadataResource) {
        if (null != metadataResource) {
            ValueMap props = metadataResource.adaptTo(ValueMap.class);
            Object[] subjects = props.get(METADATA_PROPERTY_NAME_ADOBE_KEYWORDS, new String[0]);
            log.debug("got hierarchical subjects [{}] with content [{}].", (Object)METADATA_PROPERTY_NAME_ADOBE_KEYWORDS, (Object)StringUtils.join((Object[])subjects, (String)", "));
            if (subjects.length > 0) {
                TagManager tagManager = this.tagManagerFactory.getTagManager(session);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                for (Object subject : subjects) {
                    String titlePath = StringUtils.replaceOnce((String)subject, (String)":|", (String)":");
                    Tag tag = tagManager.resolveByTitle(titlePath = StringUtils.replace((String)titlePath, (String)"|", (String)"/"));
                    if (null != tag) {
                        log.debug("got tag [{}] from title path [{}].", (Object)tag.getTagID(), (Object)titlePath);
                        tags.add(tag);
                        continue;
                    }
                    log.warn("could not find tag from title path [{}].", (Object)titlePath);
                }
                if (tags.size() > 0) {
                    try {
                        log.debug("tagging [{}] with [{}] tags.", (Object)asset.getPath(), (Object)tags.size());
                        tagManager.setTags(metadataResource, tags.toArray(new Tag[tags.size()]), !asset.isBatchMode());
                    }
                    catch (Exception e) {
                        log.error("cannot save hierarchical subjects for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
            }
        } else {
            log.error("cannot save hierarchical subjects for asset [{}], doesn't have metdata node.", (Object)asset.getPath());
        }
    }
}

