/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.core.process.MetadataExtractor;
import com.day.cq.dam.core.process.ProcessingProfileApplier;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true)
@Service
@Property(name="process.label", value={"Metadata Processor"})
public class MetadataProcessorProcess
extends AbstractAssetWorkflowProcess {
    private boolean sha1Enabled = false;
    private ProcessingProfileApplier processingProfileApplier = new ProcessingProfileApplier();
    private MetadataExtractor metadataExtractor = new MetadataExtractor();
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY)
    protected ContentAwareMimeTypeService contentAwareMimeTypeService;
    @Property(boolValue={true})
    public static final String ENABLE_SHA1_GEN = "cq.dam.enable.sha1";
    @Property(value={"adobe_dam:restrictions"}, unbounded=PropertyUnbounded.ARRAY, label="XSS protected properties", description="These properties will be passed through xss api before saving")
    public static final String XSS_PROTECTED_PROPERTIES = "cq.dam.metadata.xssprotected.properties";
    private String[] xssProtectedProperties;
    private static final String[] DEFAULT_XSS_PROTECTED_PROPERTIES = new String[]{"adobe_dam:restrictions"};
    private static final String ATTRIBUTE_EXTRACT_METADATA = "dam:extractMetadata";
    @Reference
    private XSSAPI xssApi;
    private static final Logger log = LoggerFactory.getLogger(MetadataProcessorProcess.class);

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        try {
            Session session = workflowSession.getSession();
            Asset asset = this.getAssetFromPayload(workItem, session);
            if (null != asset) {
                asset.setBatchMode(true);
                try {
                    asset.adaptTo(AssetManager.class).assignAssetID(asset);
                }
                catch (RepositoryException e) {
                    log.error("Couldn't assign Asset ID to asset at {}.Please see if sufficient privileges are available", (Object)asset.getPath(), (Object)e);
                }
                AssetHandler assetHandler = this.getAssetHandler(asset.getMimeType());
                if (null != assetHandler) {
                    Node assetNode = asset.adaptTo(Node.class);
                    if (MetadataProcessorProcess.extractMetadataRequired(assetNode)) {
                        this.metadataExtractor.extractMetadata(session, asset, assetHandler, this.sha1Enabled, null != this.contentAwareMimeTypeService ? this.contentAwareMimeTypeService : this.mimeTypeService);
                        assetHandler.processRelated(asset);
                    } else {
                        log.debug("execute: Metadata not extracted on Asset : {}. Property dam:extractMetadata is found to be false", (Object)asset.getPath());
                    }
                    MetadataProcessorProcess.removeExtractMetadataProperty(assetNode);
                } else {
                    log.error("execute: cannot extract metadata, no handler found for asset [{}] with mime type [{}]", (Object)asset.getPath(), (Object)asset.getMimeType());
                }
            } else {
                String wfPayload = workItem.getWorkflowData().getPayload().toString();
                String message = "execute: cannot extract metadata, create references and apply processing profile, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                throw new WorkflowException(message);
            }
            this.processingProfileApplier.applyProcessingProfile(session, asset);
            this.processXSSProtectedProperties(asset, this.getResourceResolver(session));
            session.save();
        }
        catch (Exception e) {
            log.warn("unexpected error occurred during metadata extraction. Cause: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void processXSSProtectedProperties(Asset asset, ResourceResolver resourceResolver) {
        try {
            Resource assetResource = resourceResolver.getResource(asset.getPath());
            Resource metadataResource = assetResource.getChild("jcr:content/metadata");
            ModifiableValueMap metadataVM = metadataResource.adaptTo(ModifiableValueMap.class);
            for (String prop : this.xssProtectedProperties) {
                String propValue = asset.getMetadataValue(prop);
                if (!StringUtils.isNotBlank((String)propValue)) continue;
                metadataVM.put(prop, this.xssApi.encodeForHTML(propValue));
            }
        }
        catch (Exception e) {
            log.error("Exception occured while applying for xss to xss protected properties", (Object)e.getMessage());
        }
    }

    @Activate
    protected void Actiate(ComponentContext context) throws RepositoryException {
        this.sha1Enabled = OsgiUtil.toBoolean(context.getProperties().get(ENABLE_SHA1_GEN), true);
        this.xssProtectedProperties = OsgiUtil.toStringArray(context.getProperties().get(XSS_PROTECTED_PROPERTIES), DEFAULT_XSS_PROTECTED_PROPERTIES);
    }

    private static boolean extractMetadataRequired(Node assetNode) {
        boolean retVal = true;
        try {
            Node contentNode;
            if (assetNode.hasNode("jcr:content") && (contentNode = assetNode.getNode("jcr:content")).hasProperty(ATTRIBUTE_EXTRACT_METADATA)) {
                retVal = contentNode.getProperty(ATTRIBUTE_EXTRACT_METADATA).getBoolean();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return retVal;
    }

    private static void removeExtractMetadataProperty(Node assetNode) throws RepositoryException {
        try {
            Node contentNode;
            if (assetNode.hasNode("jcr:content") && (contentNode = assetNode.getNode("jcr:content")).hasProperty(ATTRIBUTE_EXTRACT_METADATA)) {
                contentNode.getProperty(ATTRIBUTE_EXTRACT_METADATA).remove();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    protected void bindContentAwareMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        this.contentAwareMimeTypeService = contentAwareMimeTypeService;
    }

    protected void unbindContentAwareMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        if (this.contentAwareMimeTypeService == contentAwareMimeTypeService) {
            this.contentAwareMimeTypeService = null;
        }
    }

    protected void bindXssApi(XSSAPI xSSAPI) {
        this.xssApi = xSSAPI;
    }

    protected void unbindXssApi(XSSAPI xSSAPI) {
        if (this.xssApi == xSSAPI) {
            this.xssApi = null;
        }
    }
}

