/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.adobe.granite.confmgr.Conf;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingProfileApplier {
    private static final Logger log = LoggerFactory.getLogger(ProcessingProfileApplier.class);
    private static final String JCR_CONTENT_METADATA = "jcr:content/metadata";

    public void applyProcessingProfile(Session session, Asset asset) throws RepositoryException {
        Node metadataProfileNode = DamUtil.getApplicableProfile(asset, "metadataProfile", session);
        if (metadataProfileNode != null) {
            String metadataProfilePath = metadataProfileNode.getPath();
            if (this.isMetadataProfileValid(metadataProfilePath, asset)) {
                this.applyMetadataProfile(session, asset, metadataProfilePath);
            }
        } else {
            Node assetNode;
            Node folderNode = null;
            Node iterNode = assetNode = asset.adaptTo(Node.class);
            while (!iterNode.getPath().equals("/content")) {
                if ((iterNode = iterNode.getParent()).getPrimaryNodeType().getName().equals("dam:Asset") || !iterNode.hasNode(JCR_CONTENT_METADATA)) continue;
                folderNode = iterNode;
                break;
            }
            if (null != folderNode) {
                if (!assetNode.hasNode(JCR_CONTENT_METADATA)) {
                    this.createAssetMetadataNode(assetNode);
                }
                this.copyProperties(folderNode.getNode(JCR_CONTENT_METADATA), assetNode.getNode(JCR_CONTENT_METADATA));
            }
        }
    }

    private boolean isMetadataProfileValid(String metadataProfilePath, Asset asset) {
        String normalizedPath = ResourceUtil.normalize(metadataProfilePath);
        Resource assetRes = asset.adaptTo(Resource.class);
        Tenant tenant = assetRes.adaptTo(Tenant.class);
        return null == tenant || null != normalizedPath && normalizedPath.startsWith(assetRes.adaptTo(Conf.class).getItem("dam/adminui-extension").get("metadataprofile.home", "/conf/global/settings/dam/adminui-extension/metadataprofile"));
    }

    private Node createAssetMetadataNode(Node assetNode) throws RepositoryException {
        Node _jcr_content = assetNode.hasNode("jcr:content") ? assetNode.getNode("jcr:content") : assetNode.addNode("jcr:content");
        return _jcr_content.addNode("metadata");
    }

    private void applyMetadataProfile(Session session, Asset asset, String path) throws RepositoryException {
        Node metadataProfileNode = session.getNode(path);
        Node assetNode = asset.adaptTo(Node.class);
        Node assetMetadataNode = assetNode.getNode(JCR_CONTENT_METADATA);
        if (null == metadataProfileNode) {
            return;
        }
        if (null == assetMetadataNode) {
            assetMetadataNode = this.createAssetMetadataNode(assetNode);
        }
        this.copyMetadataProfileValues(metadataProfileNode, assetNode);
    }

    private void copyMetadataProfileValues(Node metadataProfileNode, Node assetNode) throws PathNotFoundException, RepositoryException {
        List<Node> formItems = this.getFormItems(metadataProfileNode);
        for (Node item : formItems) {
            Property property;
            String mapsTo;
            if (!item.hasProperty("name") || (mapsTo = (property = item.getProperty("name")).getString()) == null || "".equals(mapsTo) || !item.hasProperty("value")) continue;
            Property value = item.getProperty("value");
            mapsTo = mapsTo.substring(2);
            String relPathDataNode = mapsTo.substring(0, mapsTo.lastIndexOf("/") + 1);
            String propertyName = mapsTo.substring(mapsTo.lastIndexOf("/") + 1);
            log.debug("Metadata profile property name: " + propertyName);
            Node dataNode = assetNode.getNode(relPathDataNode);
            if (dataNode.hasProperty(propertyName)) {
                ArrayList<Value> updatedVals;
                Value[] vals;
                Property prop = dataNode.getProperty(propertyName);
                if (value.isMultiple() && prop.isMultiple()) {
                    vals = prop.getValues();
                    updatedVals = new ArrayList<Value>();
                    updatedVals.addAll(Arrays.asList(vals));
                    for (Value val : value.getValues()) {
                        if (updatedVals.contains(val)) continue;
                        updatedVals.add(val);
                    }
                    dataNode.setProperty(propertyName, updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                    continue;
                }
                if (!value.isMultiple() && prop.isMultiple()) {
                    vals = prop.getValues();
                    updatedVals = new ArrayList();
                    updatedVals.addAll(Arrays.asList(vals));
                    if (!updatedVals.contains(value.getValue())) {
                        updatedVals.add(value.getValue());
                    }
                    dataNode.setProperty(propertyName, updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                    continue;
                }
                if (value.isMultiple() && !prop.isMultiple()) {
                    Value val = prop.getValue();
                    updatedVals = new ArrayList();
                    updatedVals.addAll(Arrays.asList(value.getValues()));
                    if (!updatedVals.contains(val)) {
                        updatedVals.add(val);
                    }
                    dataNode.setProperty(propertyName, (Value)null);
                    dataNode.setProperty(propertyName, updatedVals.toArray(new Value[updatedVals.size()]), value.getType());
                    continue;
                }
                if (value.isMultiple() || prop.isMultiple()) continue;
                dataNode.setProperty(propertyName, value.getValue());
                continue;
            }
            if (!value.isMultiple()) {
                dataNode.setProperty(propertyName, value.getValue());
                continue;
            }
            dataNode.setProperty(propertyName, value.getValues(), value.getType());
        }
    }

    private void copyProperties(Node metadataProfileNode, Node assetMetadataNode) throws RepositoryException {
        PropertyIterator dpi = metadataProfileNode.getProperties();
        while (dpi.hasNext()) {
            Property p = dpi.nextProperty();
            if (p.getName().startsWith("jcr:")) continue;
            log.debug("Metadata profile property name: " + p.getName());
            if (assetMetadataNode.hasProperty(p.getName())) {
                ArrayList<Value> updatedVals;
                Value[] vals;
                Property prop = assetMetadataNode.getProperty(p.getName());
                if (p.isMultiple() && prop.isMultiple()) {
                    vals = prop.getValues();
                    updatedVals = new ArrayList<Value>();
                    updatedVals.addAll(Arrays.asList(vals));
                    for (Value val : p.getValues()) {
                        if (updatedVals.contains(val)) continue;
                        updatedVals.add(val);
                    }
                    assetMetadataNode.setProperty(prop.getName(), updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                    continue;
                }
                if (!p.isMultiple() && prop.isMultiple()) {
                    vals = prop.getValues();
                    updatedVals = new ArrayList();
                    updatedVals.addAll(Arrays.asList(vals));
                    if (!updatedVals.contains(p.getValue())) {
                        updatedVals.add(p.getValue());
                    }
                    assetMetadataNode.setProperty(prop.getName(), updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                    continue;
                }
                if (p.isMultiple() || prop.isMultiple()) continue;
                assetMetadataNode.setProperty(p.getName(), p.getValue());
                continue;
            }
            if (!p.isMultiple()) {
                assetMetadataNode.setProperty(p.getName(), p.getValue());
                continue;
            }
            assetMetadataNode.setProperty(p.getName(), p.getValues(), p.getType());
        }
    }

    private List<Node> getFormItems(Node metadataProfileNode) throws PathNotFoundException, RepositoryException {
        ArrayList<Node> formItems = new ArrayList<Node>();
        NodeIterator iter = metadataProfileNode.getNode("items/tabs/items").getNodes();
        while (iter.hasNext()) {
            Node tab = iter.nextNode();
            if (!tab.hasNode("items")) continue;
            NodeIterator clmns = tab.getNode("items").getNodes();
            while (clmns.hasNext()) {
                Node clm = clmns.nextNode();
                if (!clm.hasNode("items")) continue;
                NodeIterator fields = clm.getNode("items").getNodes();
                while (fields.hasNext()) {
                    formItems.add(fields.nextNode());
                }
            }
        }
        return formItems;
    }
}

