/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Synchronize Asset"})
public class SyncAssetProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SyncAssetProcess.class);

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        try {
            Session session = workflowSession.getSession();
            Node binaryNode = this.getNodeFromPayload(workItem, session);
            if (binaryNode == null) {
                log.warn("execute: cannot sync NULL asset; work item [{}].", (Object)workItem.getId());
            } else if (!binaryNode.isNodeType("nt:file")) {
                log.warn("execute: cannot sync asset not of type [{}]; work item [{}].", (Object)"nt:file", (Object)workItem.getId());
            } else if (this.isNotReadyForProcessing(binaryNode)) {
                log.debug("execute: skipping sync of file with zero size for asset [{}].", (Object)this.safeGetPath(binaryNode));
            } else {
                log.info("execute: start syncing asset [{}]...", (Object)this.safeGetPath(binaryNode));
                log.debug("execute: file size for asset [{}]: [{}]", (Object)this.safeGetPath(binaryNode), (Object)binaryNode.getProperty("jcr:content/jcr:data").getLength());
                Asset asset = this.getAssetManager(session).createAssetForBinary(binaryNode.getPath(), false);
                asset.setBatchMode(true);
                InputStream is = binaryNode.getProperty("jcr:content/jcr:data").getStream();
                Rendition original = asset.getRendition("original");
                String mimeType = null != original ? original.getMimeType() : this.recheck(asset.getMimeType(), binaryNode);
                asset.addRendition("original", is, mimeType);
                log.debug("execute: added original rendition to asset [{}] for binary [{}].", (Object)asset.getPath(), (Object)this.safeGetPath(binaryNode));
            }
        }
        catch (RepositoryException e) {
            log.error("execute: error while syncing asset; work item [{}]: ", (Object)workItem.getId(), (Object)e);
        }
    }
}

