/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.workflow.PayloadMap;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.text.Text;
import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Synchronize /var/dam"})
public class SyncVarProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SyncVarProcess.class);
    @Reference(policy=ReferencePolicy.STATIC)
    private PayloadMap payloadMap;
    private static final long INTERVAL = 200L;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        String[] args = this.buildArguments(metaData);
        try {
            Session session;
            Node node;
            String mode = null;
            if (this.getValuesFromArgs("mode", args).size() > 0) {
                mode = this.getValuesFromArgs("mode", args).get(0);
            }
            if ((node = this.getNodeFromPayload(workItem, session = workflowSession.getSession())) != null && mode != null) {
                if (mode.equals("sync")) {
                    this.sync(node, this.getResourceResolver(session));
                }
            } else if (mode != null && mode.equals("cleanup")) {
                String path;
                String string = path = workItem.getWorkflowData().getPayloadType().equals("JCR_PATH") ? workItem.getWorkflowData().getPayload().toString() : null;
                while (path != null && !session.itemExists(path)) {
                    path = Text.getRelativeParent(path, 1);
                }
                this.cleanup((Node)session.getItem(path));
            } else {
                log.debug("execute: referenced payload node does not exist; work item [{}].", (Object)workItem.getId());
            }
            if (session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (RepositoryException e) {
            log.error("execute: error while syncing structure; work item [{}]: ", (Object)workItem.getId(), (Object)e);
        }
    }

    public void execute(WorkItem workItem, WorkflowSession workflowSession) throws Exception {
    }

    private void sync(Node node, ResourceResolver resolver) throws RepositoryException {
        Session session = node.getSession();
        if (node.isNodeType("sling:OrderedFolder")) {
            JcrUtil.createPath(this.getDest(node), "nt:folder", "nt:folder", session, false);
            this.cleanup(node);
            NodeIterator itr = node.getNodes();
            while (itr.hasNext()) {
                Node n = itr.nextNode();
                if (n.isNodeType("dam:Asset")) {
                    log.debug("sync: syncing asset [{}]...", (Object)this.safeGetPath(n));
                    Asset asset = resolver.getResource(n.getPath()).adaptTo(Asset.class);
                    if (null != asset) {
                        String dest = this.getDest(node);
                        if (session.itemExists(this.getDest(n)) || this.getDest(n).contains("/._") || this.payloadMap.isInWorkflow(dest + "/" + asset.getName(), true)) continue;
                        JcrUtil.copy(asset.getOriginal().adaptTo(Node.class), (Node)session.getItem(dest), asset.getName(), true);
                        continue;
                    }
                    log.warn("sync: asset [{}] doesn't exist, cannot sync.");
                    continue;
                }
                if (!node.isNodeType("sling:OrderedFolder") || n.getParent().isNodeType("dam:Asset") || n.getName().equals("jcr:content")) continue;
                log.debug("sync: syncing folder [{}]...", (Object)this.safeGetPath(n));
                String dest = this.getDest(n);
                if (!session.itemExists(dest)) {
                    Node destNode = (Node)session.getItem(this.getDest(node));
                    destNode.addNode(n.getName(), "nt:folder");
                }
                this.sync(n, resolver);
            }
        } else if (node.isNodeType("dam:Asset")) {
            Asset asset = resolver.getResource(node.getPath()).adaptTo(Asset.class);
            String dest = this.getDest(node.getParent());
            if (!(session.itemExists(this.getDest(node)) || this.payloadMap.isInWorkflow(dest + "/" + asset.getName(), true) || node.getParent().getName().equals("subassets"))) {
                JcrUtil.copy(asset.getOriginal().adaptTo(Node.class), (Node)session.getItem(dest), asset.getName(), true);
            }
        }
    }

    private String getDest(Node node) throws RepositoryException {
        return DamUtil.assetToBinaryPath(node.getPath());
    }

    private void cleanup(Node node) throws RepositoryException {
        block8: {
            try {
                if (!node.getSession().itemExists(this.getDest(node))) break block8;
                Node varFolder = (Node)node.getSession().getItem(this.getDest(node));
                log.debug("cleanup: starting cleanup for [{}]...", (Object)this.safeGetPath(varFolder));
                boolean isReady = false;
                long kizSize = 0L;
                long count = 5L;
                while (true) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        log.debug("cleanup: caught interrupt for [{}].", (Object)this.safeGetPath(varFolder));
                        break;
                    }
                    long currentSize = varFolder.getNodes().getSize();
                    boolean bl = isReady = currentSize == kizSize;
                    if (isReady && count == 0L) break;
                    count = isReady ? --count : 5L;
                    kizSize = currentSize;
                }
                NodeIterator itr = varFolder.getNodes();
                while (itr.hasNext()) {
                    Node varNode = itr.nextNode();
                    if (node.hasNode(varNode.getName()) || this.payloadMap.isInWorkflow(varNode.getPath(), true) || varNode.getPath().contains("/._")) continue;
                    log.info("cleanup: removing folder [{}]...", (Object)this.safeGetPath(varNode));
                    try {
                        varNode.remove();
                    }
                    catch (RepositoryException e) {
                        log.debug("cleanup: failed to remove [{}]: ", (Object)this.safeGetPath(node), (Object)e);
                    }
                }
            }
            catch (RepositoryException e) {
                log.warn("cleanup: failed to clean [{}]: ", (Object)this.safeGetPath(node));
            }
        }
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String currentMode = (String)((Object)metaData.get(Arguments.MODE.name(), String.class));
        if (StringUtils.isNotBlank((String)currentMode)) {
            arguments.add(Arguments.MODE.getArgumentPrefix() + currentMode);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected void bindPayloadMap(PayloadMap payloadMap) {
        this.payloadMap = payloadMap;
    }

    protected void unbindPayloadMap(PayloadMap payloadMap) {
        if (this.payloadMap == payloadMap) {
            this.payloadMap = null;
        }
    }

    public static enum Modes {
        sync,
        cleanup;

    }

    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        MODE("mode");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

