/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.renditions.RenditionMaker;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.core.impl.ui.preview.FolderPreviewUpdater;
import com.day.cq.dam.core.process.CreateThumbnailProcess;
import com.day.cq.dam.core.process.CreateWebEnabledImageProcess;
import com.day.cq.dam.core.process.UpdateFolderThumbnailProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="process.label", value={"Thumbnail Process"})
public class ThumbnailProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ThumbnailProcess.class);
    @Reference
    private RenditionMaker renditionMaker;
    @Reference
    private FolderPreviewUpdater folderPreviewUpdater;
    private CreateThumbnailProcess thumbnailCreator = new CreateThumbnailProcess();
    private CreateWebEnabledImageProcess webEnabledImageCreator = new CreateWebEnabledImageProcess();
    private UpdateFolderThumbnailProcess folderThumbnailUpdater = new UpdateFolderThumbnailProcess();

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        Asset asset = this.getAssetFromPayload(workItem, workflowSession.getSession());
        if (asset == null) {
            String wfPayload = workItem.getWorkflowData().getPayload().toString();
            String message = "execute: cannot process thumbnails, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            throw new WorkflowException(message);
        }
        CreateThumbnailProcess.Config createThumbnailConfig = this.thumbnailCreator.parseConfig(metaData);
        this.thumbnailCreator.createThumbnails(asset, createThumbnailConfig, this.renditionMaker);
        CreateWebEnabledImageProcess.Config createWebEnabledImageConfig = this.webEnabledImageCreator.parseConfig(metaData);
        try {
            this.webEnabledImageCreator.createWebEnabledImage(workItem, createWebEnabledImageConfig, asset, this.renditionMaker);
        }
        catch (RepositoryException re) {
            throw new WorkflowException(re);
        }
        Node assetNode = asset.adaptTo(Node.class);
        try {
            this.folderThumbnailUpdater.updateFolderThumbnail(asset, assetNode, this.folderPreviewUpdater);
        }
        catch (Exception e) {
            log.error("Error while updating folder thumbnail of asset ", (Object)asset.getPath(), (Object)e);
        }
    }

    protected void bindRenditionMaker(RenditionMaker renditionMaker) {
        this.renditionMaker = renditionMaker;
    }

    protected void unbindRenditionMaker(RenditionMaker renditionMaker) {
        if (this.renditionMaker == renditionMaker) {
            this.renditionMaker = null;
        }
    }

    protected void bindFolderPreviewUpdater(FolderPreviewUpdater folderPreviewUpdater) {
        this.folderPreviewUpdater = folderPreviewUpdater;
    }

    protected void unbindFolderPreviewUpdater(FolderPreviewUpdater folderPreviewUpdater) {
        if (this.folderPreviewUpdater == folderPreviewUpdater) {
            this.folderPreviewUpdater = null;
        }
    }
}

