/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={WorkflowProcess.class})
@Property(name="process.label", value={"DAM Unarchiver Process"})
public class UnarchiverProcess
extends AbstractAssetWorkflowProcess {
    protected static final Logger log = LoggerFactory.getLogger(UnarchiverProcess.class);
    protected static final int BUFFER = 2048;
    protected static final String MIME_TYPE_ZIP = "application/zip";
    protected static final String FILE_EXT_ZIP = ".zip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void execute(WorkItem item, WorkflowSession wfSession, MetaDataMap args) throws WorkflowException {
        block12: {
            block9: {
                String assetPath;
                block10: {
                    block11: {
                        Session session = wfSession.getSession();
                        Asset asset = this.getAssetFromPayload(item, session);
                        if (null == asset) break block9;
                        assetPath = asset.getPath();
                        if (!UnarchiverProcess.isZipFile(asset)) {
                            log.info("execute: ignoring asset [{}] as it is not a ZIP archive.", (Object)assetPath);
                            return;
                        }
                        Rendition original = asset.getOriginal();
                        if (null == original) break block10;
                        InputStream stream = original.getStream();
                        if (null == stream) break block11;
                        AssetManager assetManager = this.getAssetManager(session);
                        if (null == assetManager) {
                            throw new WorkflowException("asset manager unavailable");
                        }
                        UnarchiverContext context = new UnarchiverContext(session, assetManager, asset, args);
                        if (context.isDisableExtraction()) {
                            log.info("execute: skipping extraction of [{}], disabled via configuration.", (Object)assetPath);
                            return;
                        }
                        item.getWorkflowData().getMetaDataMap().put("noretry", true);
                        log.info("scan: scanning archive [{}] and verifying configured limits", (Object)assetPath);
                        this.scan(context);
                        log.debug("execute: calling beforeExtract for [{}]", (Object)assetPath);
                        this.beforeExtract(context);
                        boolean isExtractionSuccessful = false;
                        try {
                            isExtractionSuccessful = this.extract(context);
                            log.debug("execute: calling afterExtract for [{}] (extraction {})", (Object)assetPath, (Object)(isExtractionSuccessful ? "successful" : "failed"));
                        }
                        catch (IOException e) {
                            log.error("execute: IO error while extracting archive [{}]: ", (Object)assetPath, (Object)e);
                            log.debug("execute: calling afterExtract for [{}] (extraction {})", (Object)assetPath, (Object)(isExtractionSuccessful ? "successful" : "failed"));
                            this.afterExtract(context, isExtractionSuccessful);
                        }
                        catch (RepositoryException e2) {
                            log.error("execute: repository error while extracting archive [{}]: ", (Object)assetPath, (Object)e2);
                            log.debug("execute: calling afterExtract for [{}] (extraction {})", (Object)assetPath, (Object)(isExtractionSuccessful ? "successful" : "failed"));
                            {
                                catch (Throwable throwable) {
                                    log.debug("execute: calling afterExtract for [{}] (extraction {})", (Object)assetPath, (Object)(isExtractionSuccessful ? "successful" : "failed"));
                                    this.afterExtract(context, isExtractionSuccessful);
                                    throw throwable;
                                }
                            }
                            this.afterExtract(context, isExtractionSuccessful);
                        }
                        this.afterExtract(context, isExtractionSuccessful);
                        break block12;
                    }
                    log.error("execute: cannot extract archive, asset [{}] in workflow [{}] doesn't have binary stream.", (Object)assetPath, (Object)item.getId());
                    break block12;
                }
                log.error("execute: cannot extract archive, asset [{}] in workflow [{}] doesn't have original file.", (Object)assetPath, (Object)item.getId());
                break block12;
            }
            log.error("execute: cannot extract archive, asset [{}] in workflow [{}] does not exist.", (Object)item.getWorkflowData().getPayload().toString(), (Object)item.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extract(UnarchiverContext context) throws RepositoryException, IOException {
        Session session = context.getSession();
        Asset asset = context.getAsset();
        String assetPath = asset.getPath();
        ZipInputStream zis = context.createZipInputStream();
        try {
            log.info("extract: begin extraction of archive [{}] - update mode [{}]", (Object)assetPath, (Object)context.getUpdateMode().name());
            context.setRoot(this.getOrCreateRoot(context));
            try {
                ZipEntry entry;
                while (null != (entry = zis.getNextEntry())) {
                    String name = entry.getName();
                    if (this.isExtractEntry(context, entry)) {
                        long numFiles = context.updateNumFiles();
                        this.extractEntry(context, zis, entry);
                        if (numFiles % context.getSaveThreshold() != 0L) continue;
                        log.debug("extract: threshold of [{}] reached, saving....", (Object)context.getSaveThreshold());
                        session.save();
                        continue;
                    }
                    log.info("extract: extraction of entry [{}] skipped for archive [{}]", (Object)name, (Object)assetPath);
                }
            }
            catch (Exception e) {
                log.error("extract: error while extracting archive [{}]: ", (Object)assetPath, (Object)e);
            }
            finally {
                zis.closeEntry();
            }
            session.save();
            log.info("extract: extraction of archive [{}] successfully completed.", (Object)assetPath);
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
    }

    private long getFolderCount(HashMap<String, Long> folderMap, String zipFolder) {
        long count;
        if (folderMap.containsKey(zipFolder)) {
            count = folderMap.get(zipFolder);
            folderMap.put(zipFolder, ++count);
        } else {
            count = 1L;
            folderMap.put(zipFolder, count);
        }
        return count;
    }

    private String getSHA1(MessageDigest sha1) {
        return new BigInteger(1, sha1.digest()).toString(16);
    }

    private static boolean isZipFile(Asset asset) {
        return MIME_TYPE_ZIP.equals(asset.getMimeType()) || asset.getName().endsWith(FILE_EXT_ZIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(UnarchiverContext context) throws WorkflowException {
        Asset asset = context.getAsset();
        HashMap<String, Long> folderMap = new HashMap<String, Long>();
        String assetPath = asset.getPath();
        long maxBytes = context.getMaxBytes();
        long maxNumFiles = context.getMaxNumFiles();
        long maxNumFilesPerDir = context.getMaxNumFilesPerDirectory();
        log.info("scan: configured limits: max bytes [{}], max files [{}], max files per dir [" + maxNumFilesPerDir + "]", (Object)maxBytes, (Object)maxNumFiles);
        ZipInputStream zis = context.createZipInputStream();
        try {
            ZipEntry entry;
            long numBytes = 0L;
            long numFiles = 0L;
            while (null != (entry = zis.getNextEntry())) {
                int size;
                EntryInfo info = context.getEntryInfo(entry);
                String zipFolder = info.getParentPath();
                if (!this.isExtractEntry(context, entry)) continue;
                long entryBytes = 0L;
                byte[] buffer = new byte[2048];
                while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                    entryBytes += (long)size;
                }
                entry.setSize(entryBytes);
                if ((numBytes += entryBytes) > maxBytes) {
                    log.error("scan: archive [{}] exceeds configured max bytes limit [{}]", (Object)assetPath, (Object)maxBytes);
                    throw new WorkflowException("Configured max number of bytes exceeded");
                }
                if (++numFiles > maxNumFiles) {
                    log.error("scan: archive [{}] exceeds max number of files limit [{}]", (Object)assetPath, (Object)maxNumFiles);
                    throw new WorkflowException("Configured max number of files limit exceeded");
                }
                long dirFileCount = this.getFolderCount(folderMap, zipFolder);
                if (dirFileCount > maxNumFilesPerDir) {
                    log.error("scan: archive [{}] exceeds max number of files/folders per directory limit [" + maxNumFilesPerDir + "] in directory [{}]", (Object)assetPath, (Object)zipFolder);
                    throw new WorkflowException("Configured total number of files limit reached");
                }
                log.debug("scan: scanned entry [{}] - [{}] bytes - folder:[" + zipFolder + " - " + dirFileCount + " - " + maxNumFilesPerDir + "]", (Object)entry.getName(), (Object)entry.getSize());
            }
            context.setTotalNumFiles(numFiles);
            context.setTotalNumBytes(numBytes);
            log.info("scan: scan of archive [{}] completed. archive is within configured limits.", (Object)assetPath);
            log.info("scan: archive [{}] will result in [{}] extracted files with a total of [" + numBytes + "] bytes.", (Object)assetPath, (Object)numFiles);
        }
        catch (IOException e) {
            log.error("scan: IO error while scanning archive [{}]: ", (Object)assetPath, (Object)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void extractEntry(UnarchiverContext context, ZipInputStream zis, ZipEntry entry) throws Exception {
        FileInputStream fis;
        FileOutputStream fos;
        File tempFile;
        block10: {
            Asset target;
            Resource resource;
            String fullPath;
            String fileName;
            String name;
            block11: {
                Session session = context.getSession();
                Node root = context.getTargetRoot();
                EntryInfo info = context.getEntryInfo(entry);
                name = entry.getName();
                String zipPath = info.getPath();
                fileName = info.getFileName();
                fullPath = info.getTargetPath(root.getPath());
                log.debug("extractEntry: extracting entry [{}] in archive [{}]", (Object)entry.getName(), (Object)context.getAsset().getPath());
                if (entry.isDirectory()) {
                    if (!root.hasNode(zipPath)) {
                        Node node = JcrUtil.createPath(root, zipPath, false, "sling:OrderedFolder", "sling:OrderedFolder", session, false);
                        log.info("extractEntry: created directory [{}] from entry [{}]", (Object)node.getPath(), (Object)name);
                        return;
                    } else {
                        log.debug("extractEntry: directory [{}] already exists, skipping entry [{}]", (Object)fullPath, (Object)name);
                    }
                    return;
                }
                tempFile = File.createTempFile("unarchiver-file-" + System.currentTimeMillis(), null);
                log.debug("extractEntry: created temporary file at [{}]", (Object)tempFile.getPath());
                fos = null;
                fis = null;
                try {
                    String assetSha1;
                    int size;
                    long numBytes = 0L;
                    byte[] buffer = new byte[2048];
                    MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                    fos = new FileOutputStream(tempFile);
                    while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                        fos.write(buffer, 0, size);
                        sha1.update(buffer, 0, size);
                        numBytes += (long)size;
                    }
                    IOUtils.closeQuietly((OutputStream)fos);
                    context.updateNumBytes(numBytes);
                    if (this.isMatchSkipFileNamePatterns(context, fileName)) break block10;
                    String zipSha1 = this.getSHA1(sha1);
                    log.debug("extractEntry: got SHA-1 [{}] for entry [{}]", (Object)zipSha1, (Object)name);
                    resource = this.getResourceResolver(session).getResource(fullPath);
                    target = null;
                    if (null == resource || null == (target = resource.adaptTo(Asset.class)) || !StringUtils.equals((String)(assetSha1 = target.getMetadataValue("dam:sha1")), (String)zipSha1)) break block11;
                    log.info("extractEntry: entry [{}] exists as asset [{}] with identical SHA-1, skipping.", (Object)name, (Object)target.getPath());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    IOUtils.closeQuietly(fis);
                    tempFile.delete();
                    log.debug("extractEntry: deleted temporary file at [{}]", (Object)tempFile.getPath());
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
                IOUtils.closeQuietly((InputStream)fis);
                tempFile.delete();
                log.debug("extractEntry: deleted temporary file at [{}]", (Object)tempFile.getPath());
                return;
            }
            fis = new FileInputStream(tempFile);
            String mimeType = this.mimeTypeService.getMimeType(fileName);
            if (null != target) {
                Asset newAsset = target.addRendition("original", (InputStream)fis, mimeType).getAsset();
                log.info("extractEntry: updated existing asset [{}] from entry [{}]", (Object)newAsset.getPath(), (Object)name);
                break block10;
            }
            if (null != resource) {
                log.error("extractEntry: cannot extract entry [{}], blocking resource at [{}]", (Object)name, (Object)resource.getPath());
                throw new WorkflowException("Cannot extract entry, blocking resource.");
            }
            Asset newAsset = context.getAssetManager().createAsset(fullPath, fis, mimeType, false);
            if (null != newAsset) {
                log.info("extractEntry: created new asset [{}] from entry [{}]", (Object)newAsset.getPath(), (Object)name);
                break block10;
            }
            log.error("extractEntry: asset manager couldn't create asset for entry [{}]", (Object)name);
            throw new WorkflowException("Asset manager couldn't create asset for entry " + name);
        }
        IOUtils.closeQuietly((OutputStream)fos);
        IOUtils.closeQuietly(fis);
        tempFile.delete();
        log.debug("extractEntry: deleted temporary file at [{}]", (Object)tempFile.getPath());
    }

    private boolean isMatchSkipFileNamePatterns(UnarchiverContext context, String fileName) {
        String[] patterns;
        for (String pattern : patterns = context.getSkipFileNamePatterns().split(":")) {
            if (!fileName.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    protected void afterExtract(UnarchiverContext context, boolean isExtractionSuccessful) {
        String assetPath = context.getAsset().getPath();
        if (!isExtractionSuccessful) {
            log.info("afterExtract: not removing original archive [{}] as preceding extraction failed.", (Object)assetPath);
            return;
        }
        if (context.isRemoveOriginal()) {
            Session session = context.getSession();
            log.debug("afterExtract: removing original archive [{}]", (Object)assetPath);
            try {
                session.removeItem(assetPath);
                session.save();
                log.info("afterExtract: original archive [{}] removed", (Object)assetPath);
            }
            catch (RepositoryException e) {
                log.error("afterExtract: could not remove asset [{}]: ", (Object)assetPath, (Object)e);
            }
        } else {
            log.info("afterExtract: not removing original archive [{}] as per configuration.", (Object)assetPath);
        }
    }

    protected boolean isExtractEntry(UnarchiverContext context, ZipEntry entry) {
        return true;
    }

    protected void beforeExtract(UnarchiverContext context) {
    }

    protected Node getOrCreateRoot(UnarchiverContext context) throws RepositoryException {
        Node root;
        Session session = context.getSession();
        Asset asset = context.getAsset();
        String assetPath = asset.getPath();
        String rootHint = Text.getRelativeParent(asset.getPath(), 1) + "/" + StringUtils.substringBeforeLast((String)asset.getName(), (String)".");
        if (UnarchiverContext.UPDATE_MODE.OVERWRITE == context.getUpdateMode()) {
            if (session.itemExists(rootHint)) {
                log.debug("extract: update mode is [{}], removing existing folder [{}]...", (Object)context.getUpdateMode().name(), (Object)rootHint);
                session.getItem(rootHint).remove();
                session.save();
                log.info("extract: target folder [{}] removed.", (Object)rootHint);
            }
            root = JcrUtil.createPath(rootHint, "sling:OrderedFolder", session);
            log.debug("extract: created extraction folder at [{}] for [{}]", (Object)root.getPath(), (Object)assetPath);
        } else if (UnarchiverContext.UPDATE_MODE.UPDATE == context.getUpdateMode()) {
            if (session.itemExists(rootHint)) {
                root = (Node)session.getItem(rootHint);
                log.debug("extract: update mode is [{}], using existing folder [{}]...", (Object)context.getUpdateMode().name(), (Object)rootHint);
            } else {
                root = JcrUtil.createPath(rootHint, "sling:OrderedFolder", session);
                session.save();
                log.debug("extract: update mode is [{}], but destination doesn't exit, created [{}]", (Object)context.getUpdateMode().name(), (Object)rootHint);
            }
        } else {
            log.debug("extract: update mode is [{}], creating unique folder...", (Object)context.getUpdateMode().name());
            root = JcrUtil.createUniquePath(rootHint, "sling:OrderedFolder", session);
            session.save();
            log.debug("extract: created extraction folder at [{}] for [{}]", (Object)root.getPath(), (Object)assetPath);
        }
        return root;
    }

    protected static class EntryInfo {
        private static final String ROOT_FOLDER = "./";
        private final ZipEntry entry;
        private final String path;
        private final String fileName;
        private final String parentPath;

        private EntryInfo(ZipEntry entry) {
            this.entry = entry;
            String name = entry.getName();
            this.path = name.endsWith("/") ? StringUtils.substring((String)name, (int)0, (int)(name.length() - 1)) : name;
            this.fileName = Text.getName(entry.getName());
            this.parentPath = Text.getRelativeParent(this.path, 1);
        }

        protected ZipEntry getEntry() {
            return this.entry;
        }

        protected String getFileName() {
            return this.fileName;
        }

        protected String getParentPath() {
            return StringUtils.isBlank((String)this.parentPath) ? ROOT_FOLDER : this.parentPath;
        }

        protected String getPath() {
            return this.path;
        }

        protected String getTargetPath(String rootPath) {
            return rootPath + "/" + (ROOT_FOLDER.equals(this.getParentPath()) ? "" : this.getParentPath() + "/") + Text.escapeIllegalJcrChars(this.getFileName());
        }
    }

    protected static class UnarchiverContext {
        protected static final String ARG_NAME_DISABLE_EXTRACT = "disableExtract";
        protected static final String ARG_NAME_REMOVE_ORIGINAL = "removeOriginal";
        protected static final String ARG_NAME_MAX_BYTES = "maxBytes";
        protected static final String ARG_NAME_MAX_NUM_ITEMS = "maxNumItems";
        protected static final String ARG_NAME_MAX_NUM_ITEMS_PER_DIR = "maxNumItemsPerDir";
        protected static final String ARG_NAME_SAVE_THRESHOLD = "saveThreshold";
        protected static final String ARG_NAME_UPDATE_MODE = "updateMode";
        protected static final String ARG_NAME_SKIP_FILE_NAME_PATTERNS = "skipFileNamePatterns";
        protected static final long DEFAULT_MAX_BYTES = 0x6400000L;
        protected static final long DEFAULT_MAX_NUM_ITEMS = 10000L;
        protected static final long DEFAULT_MAX_NUM_ITEMS_PER_DIR = 100L;
        protected static final long DEFAULT_SAVE_THRESHOLD = 1024L;
        private final boolean removeOriginal;
        private final boolean disableExtraction;
        private final long maxBytes;
        private final long maxNumFiles;
        private final long maxNumFilesPerDir;
        private final long saveThreshold;
        private final Session session;
        private final AssetManager assetManager;
        private final Asset asset;
        private Node root;
        private UPDATE_MODE updateMode;
        private long numFiles = 0L;
        private long numBytes = 0L;
        private long totalNumFiles;
        private long totalNumBytes;
        private String skipFileNamePatterns = "";

        private UnarchiverContext(Session session, AssetManager assetManager, Asset asset, MetaDataMap args) {
            this.session = session;
            this.assetManager = assetManager;
            this.asset = asset;
            this.removeOriginal = args.get(ARG_NAME_REMOVE_ORIGINAL, false);
            this.disableExtraction = args.get(ARG_NAME_DISABLE_EXTRACT, false);
            this.maxBytes = args.get(ARG_NAME_MAX_BYTES, 0x6400000L);
            this.maxNumFiles = args.get(ARG_NAME_MAX_NUM_ITEMS, 10000L);
            this.maxNumFilesPerDir = args.get(ARG_NAME_MAX_NUM_ITEMS_PER_DIR, 100L);
            this.saveThreshold = args.get(ARG_NAME_SAVE_THRESHOLD, 1024L);
            this.skipFileNamePatterns = args.get(ARG_NAME_SKIP_FILE_NAME_PATTERNS, "");
            try {
                String updateModeStr = args.get(ARG_NAME_UPDATE_MODE, "new").toUpperCase();
                this.updateMode = UPDATE_MODE.valueOf(updateModeStr);
            }
            catch (IllegalArgumentException e) {
                this.updateMode = UPDATE_MODE.NEW;
            }
        }

        public Asset getAsset() {
            return this.asset;
        }

        public AssetManager getAssetManager() {
            return this.assetManager;
        }

        public EntryInfo getEntryInfo(ZipEntry entry) {
            return new EntryInfo(entry);
        }

        public long getSaveThreshold() {
            return this.saveThreshold;
        }

        public Node getTargetRoot() {
            return this.root;
        }

        public long getNumFiles() {
            return this.numFiles;
        }

        public long getNumBytes() {
            return this.numBytes;
        }

        public Session getSession() {
            return this.session;
        }

        protected long getMaxBytes() {
            return this.maxBytes;
        }

        protected long getMaxNumFiles() {
            return this.maxNumFiles;
        }

        public long getMaxNumFilesPerDirectory() {
            return this.maxNumFilesPerDir;
        }

        public long getTotalNumFiles() {
            return this.totalNumFiles;
        }

        public long getTotalNumBytes() {
            return this.totalNumBytes;
        }

        public UPDATE_MODE getUpdateMode() {
            return this.updateMode;
        }

        protected boolean isDisableExtraction() {
            return this.disableExtraction;
        }

        protected boolean isRemoveOriginal() {
            return this.removeOriginal;
        }

        protected ZipInputStream createZipInputStream() {
            return new ZipInputStream(new BufferedInputStream(this.asset.getOriginal().getStream()));
        }

        private void setRoot(Node root) {
            this.root = root;
        }

        private long updateNumBytes(long numBytes) {
            this.numBytes += numBytes;
            return this.numBytes;
        }

        private long updateNumFiles() {
            ++this.numFiles;
            return this.numFiles;
        }

        private void setTotalNumFiles(long totalNumFiles) {
            this.totalNumFiles = totalNumFiles;
        }

        private void setTotalNumBytes(long totalNumBytes) {
            this.totalNumBytes = totalNumBytes;
        }

        protected String getSkipFileNamePatterns() {
            return this.skipFileNamePatterns;
        }

        protected static enum UPDATE_MODE {
            OVERWRITE,
            UPDATE,
            NEW;

        }
    }
}

