/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.drive.servlet;

import com.day.cq.commons.servlets.AbstractPredicateServlet;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.drive.util.DriveRenditionPicker;
import com.day.cq.dam.drive.util.DriveUtil;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.resource.collection.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true)
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"driveGetChildren", "driveGetCollection"})})
public class GetChildrenServlet
extends AbstractPredicateServlet {
    private static Logger log = LoggerFactory.getLogger(GetChildrenServlet.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    DriveRenditionPicker picker;
    @Reference(policy=ReferencePolicy.STATIC)
    private QueryBuilder queryBuilder;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response, Predicate predicate) throws ServletException, IOException {
        String[] dTypes = DriveUtil.getDataType(request);
        String selectorString = request.getRequestPathInfo().getSelectorString();
        Resource resource = request.getResource();
        ResourceResolver resolver = resource.getResourceResolver();
        JSONObject obj = null;
        if ("driveGetCollection".equals(selectorString)) {
            try {
                obj = this.handleCollection(resource, resolver, request, predicate, dTypes);
            }
            catch (Exception e) {
                log.error("Error in Handling collection", (Throwable)e);
            }
        } else {
            try {
                obj = this.processFolder(request, predicate, dTypes);
            }
            catch (Exception e) {
                log.error("Error in Handling Folder ", (Throwable)e);
            }
        }
        response.addHeader("Content-Type", "application/json;charset=utf-8");
        try {
            obj.write(response.getWriter());
        }
        catch (JSONException e) {
            log.error("Error in returning the JSON response ", (Throwable)e);
        }
    }

    protected JSONObject handleCollection(Resource resource, ResourceResolver resolver, SlingHttpServletRequest request, Predicate predicate, String[] dTypes) throws Exception {
        JSONObject obj = new JSONObject();
        AssetManager assetManager = request.getResourceResolver().adaptTo(AssetManager.class);
        JSONObject parentObj = new JSONObject();
        JSONObject self = new JSONObject();
        DriveUtil.fillRecipeData(request, dTypes, resource, this.picker, assetManager, self);
        JSONArray jsonArr = new JSONArray();
        Resource parent = resource.getParent();
        DriveUtil.fillRecipeData(request, dTypes, parent, this.picker, assetManager, parentObj);
        obj.put("self", self);
        obj.put("parent", parentObj);
        if (resource.adaptTo(ResourceCollection.class) == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("path", "/content/dam");
            map.put("group.0_property", "sling:resourceType");
            map.put("group.0_property.0_value", "dam/collection");
            map.put("group.0_property.1_value", "dam/smartcollection");
            map.put("group.1_property", "sling:resourceSuperType");
            map.put("group.1_property.value", "dam/collection");
            map.put("group.p.or", "true");
            map.put("type", "nt:unstructured");
            map.put("p.limit", "0");
            Session session = resolver.adaptTo(Session.class);
            Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), session);
            query.setHitsPerPage(0L);
            Iterator<Resource> it = query.getResult().getResources();
            while (it.hasNext()) {
                Resource kid = it.next();
                this.processChildren(request, predicate, dTypes, assetManager, jsonArr, kid);
            }
        } else if (!DriveUtil.isSmartCollection(resource)) {
            Resource members = resource.getChild("sling:members");
            Iterator<Resource> itr = members.getChildren().iterator();
            while (itr != null && itr.hasNext()) {
                try {
                    Resource m = itr.next();
                    String orginalPath = m.adaptTo(Node.class).getProperty("sling:resource").getString();
                    Resource orig = resolver.getResource(orginalPath);
                    this.processChildren(request, predicate, dTypes, assetManager, jsonArr, orig);
                }
                catch (Exception e) {
                    log.warn("Error in adding a collection member", (Throwable)e);
                }
            }
        }
        obj.put("children", jsonArr);
        return obj;
    }

    protected JSONObject processFolder(SlingHttpServletRequest request, Predicate predicate, String[] dTypes) {
        Resource resource = request.getResource();
        Resource parent = resource.getParent();
        Iterator<Resource> kidz = resource.listChildren();
        AssetManager assetManager = request.getResourceResolver().adaptTo(AssetManager.class);
        JSONObject obj = new JSONObject();
        JSONObject parentObj = new JSONObject();
        JSONArray jsonArr = new JSONArray();
        try {
            DriveUtil.fillRecipeData(request, dTypes, parent, this.picker, assetManager, parentObj);
            obj.put("parent", parentObj);
            JSONObject self = new JSONObject();
            DriveUtil.fillRecipeData(request, dTypes, resource, this.picker, assetManager, self);
            obj.put("self", self);
            while (kidz.hasNext()) {
                Resource kid = kidz.next();
                this.processChildren(request, predicate, dTypes, assetManager, jsonArr, kid);
            }
            obj.put("children", jsonArr);
            return obj;
        }
        catch (Exception e) {
            log.error("Error in returning children", (Throwable)e);
            return null;
        }
    }

    protected void processChildren(SlingHttpServletRequest request, Predicate predicate, String[] dTypes, AssetManager assetManager, JSONArray jsonArr, Resource kid) {
        try {
            if (predicate == null || predicate.evaluate((Object)kid)) {
                JSONObject json = new JSONObject();
                DriveUtil.fillRecipeData(request, dTypes, kid, this.picker, assetManager, json);
                jsonArr.put(json);
            }
        }
        catch (Exception e) {
            log.warn("Failed processing resource ", (Throwable)e);
        }
    }

    protected void bindPicker(DriveRenditionPicker driveRenditionPicker) {
        this.picker = driveRenditionPicker;
    }

    protected void unbindPicker(DriveRenditionPicker driveRenditionPicker) {
        if (this.picker == driveRenditionPicker) {
            this.picker = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }
}

