/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.drive.util;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.options.SerializeOptions;
import com.day.cq.commons.LabeledResource;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.Revision;
import com.day.cq.dam.commons.metadata.SimpleXmpToJcrMetadataBuilder;
import com.day.cq.dam.drive.common.AssetType;
import com.day.cq.dam.drive.common.Flag;
import com.day.cq.dam.drive.common.IconConstants;
import com.day.cq.dam.drive.common.StringConstants;
import com.day.cq.dam.drive.util.DriveRenditionPicker;
import com.day.cq.dam.drive.util.PrefixRenditionPicker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriveUtil {
    private static final Logger log = LoggerFactory.getLogger(DriveUtil.class);
    private static final char DELIMITER = '@';
    static final String SMART_COLLECTION_SLING_RES_TYPE = "dam/smartcollection";

    public static Resource getBestFitRendition(int width, List<Resource> renditions) {
        int d2;
        int i;
        PrefixRenditionPicker prefixPicker = new PrefixRenditionPicker("cq5dam.thumbnail." + width);
        Resource bestFitRendition = prefixPicker.getRendition(renditions.iterator());
        if (bestFitRendition != null) {
            return bestFitRendition;
        }
        WidthBasedRenditionComparator comp = new WidthBasedRenditionComparator();
        Collections.sort(renditions, comp);
        for (i = 0; i < renditions.size() && width > DriveUtil.getWidth(renditions.get(i)); ++i) {
        }
        if (i == 0) {
            return renditions.get(0);
        }
        if (i == renditions.size()) {
            return renditions.get(i - 1);
        }
        int d1 = width - DriveUtil.getWidth(renditions.get(i - 1));
        return d1 > (d2 = DriveUtil.getWidth(renditions.get(i)) - width) ? renditions.get(i) : renditions.get(i - 1);
    }

    public static int getWidth(Resource r) {
        String name = r.getName();
        int renditionWidth = 0;
        try {
            Asset asset;
            String[] split = name.split("\\.");
            if (split.length > 3) {
                try {
                    renditionWidth = Integer.parseInt(split[2]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((asset = new ResourceWrapper(r).adaptTo(Rendition.class).adaptTo(Asset.class)) != null && StringConstants.ORIGINAL.equals(name)) {
                return Integer.parseInt(asset.getMetadataValue(StringConstants.TIFF_IMAGEWIDTH));
            }
        }
        catch (Exception e) {
            log.warn("Failed to compute with for rendition " + name, (Throwable)e);
            renditionWidth = 0;
        }
        return renditionWidth;
    }

    public static int getHeight(Resource r) {
        String name = r.getName();
        int renditionHeight = 0;
        try {
            Asset asset;
            String[] split = name.split("\\.");
            if (split.length > 3) {
                try {
                    renditionHeight = Integer.parseInt(split[3]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((asset = new ResourceWrapper(r).adaptTo(Rendition.class).adaptTo(Asset.class)) != null && StringConstants.ORIGINAL.equals(name)) {
                return Integer.parseInt(asset.getMetadataValue(StringConstants.TIFF_IMAGELENGTH));
            }
        }
        catch (Exception e) {
            log.warn("Failed to compute with for rendition " + name, (Throwable)e);
            renditionHeight = 0;
        }
        return renditionHeight;
    }

    public static String getIdentifier(Node n) {
        String identifier = "";
        try {
            identifier = n.hasProperty("jcr:uuid") ? n.getIdentifier() : DriveUtil.getPathBasedIdentifier(n);
        }
        catch (RepositoryException e) {
            log.warn("Error in getting identifier", (Throwable)e);
        }
        return identifier;
    }

    private static AssetType getAssetType(Resource resource) {
        try {
            Node resourceNode = resource.adaptTo(Node.class);
            if (resourceNode.isNodeType("dam:Asset") || resourceNode.isNodeType("nt:frozenNode")) {
                return AssetType.FILE;
            }
            String resourceType = resource.getResourceType();
            if ("dam/collection".equals(resourceType) || "collections".equals(resource.getName())) {
                return AssetType.FILE_CONTAINER;
            }
            if ("sling:OrderedFolder".equals(resourceType) || "sling:Folder".equals(resourceType) || "nt:unstructured".equals(resourceType)) {
                return AssetType.FILE_CONTAINER;
            }
        }
        catch (RepositoryException e) {
            log.error("Error in getting asset type", (Throwable)e);
        }
        return null;
    }

    public static String[] getDataType(SlingHttpServletRequest request) {
        String dataTypes = request.getParameter("dataType");
        String[] dTypes = null;
        dTypes = dataTypes != null ? dataTypes.split(",") : StringConstants.ALL_PARAMETERS;
        return dTypes;
    }

    public static boolean isSmartCollection(Resource resource) {
        return resource.isResourceType(SMART_COLLECTION_SLING_RES_TYPE);
    }

    public static void fillRecipeData(SlingHttpServletRequest request, String[] dTypes, Resource resource, DriveRenditionPicker picker, AssetManager assetManager, JSONObject json) throws JSONException, PathNotFoundException, RepositoryException, XMPException {
        for (int i = 0; i < dTypes.length; ++i) {
            String selector = dTypes[i];
            if (StringConstants.IDENTIFICATION.equals(selector)) {
                JSONObject identificationData = DriveUtil.buildIdentificationData(resource, assetManager);
                json.put(StringConstants.IDENTIFICATION, identificationData);
            }
            if (StringConstants.XMP.equals(selector)) {
                String xmlStr = DriveUtil.buildXMPData(resource);
                json.put(StringConstants.XMP, xmlStr);
                continue;
            }
            if (StringConstants.VERSION_PROPERTY.equals(selector)) {
                Asset asset = resource.adaptTo(Asset.class);
                if (asset == null) continue;
                Map<String, Object> metadata = asset.getMetadata();
                json.put(StringConstants.VERSION_PROPERTY, metadata);
                continue;
            }
            if (StringConstants.ICON.equals(selector)) {
                json.put(StringConstants.ICON, DriveUtil.getIconData(resource, picker));
                continue;
            }
            if (!StringConstants.BASIC.equals(selector)) continue;
            JSONObject basicData = DriveUtil.buildBasicData(resource, request.getRemoteUser(), assetManager);
            json.put(StringConstants.BASIC, basicData);
        }
    }

    private static String getPathBasedIdentifier(Node n) {
        try {
            if ("/".equals(n.getPath())) {
                return "@{}";
            }
            return DriveUtil.getPathBasedIdentifier(n.getParent()) + "\t{}" + n.getName();
        }
        catch (Exception e) {
            log.warn("Failed to get Path Based Identifier", (Throwable)e);
            return null;
        }
    }

    public static JSONObject buildIdentificationData(Resource resource, AssetManager assetManager) {
        JSONObject identificationData;
        block5: {
            identificationData = new JSONObject();
            try {
                Node resourceNode = resource.adaptTo(Node.class);
                String identifier = DriveUtil.getIdentifier(resourceNode);
                identificationData.put("jcr:uuid", identifier);
                String parentIdentifier = DriveUtil.getIdentifier(resourceNode.getParent());
                identificationData.put("jcr:predecessors", parentIdentifier);
                AssetType assetType = DriveUtil.getAssetType(resource);
                identificationData.put("assetType", (Object)assetType);
                String resourceType = resource.getResourceType();
                identificationData.put("jcr:defaultPrimaryType", resourceType);
                String name = resource.getName();
                identificationData.put("jcr:name", name);
                String path = resource.getPath();
                identificationData.put("jcr:path", path);
                Asset asset = resource.adaptTo(Asset.class);
                if (asset == null) break block5;
                long lastModificationDate = DriveUtil.getLastModificationDate(asset);
                Collection<Revision> revisions = assetManager.getRevisions(asset.getPath(), null);
                int currentVersionNumber = revisions.size() > 0 ? revisions.size() + 1 : 1;
                JSONObject etag = new JSONObject();
                etag.put("content", lastModificationDate);
                etag.put("version", currentVersionNumber);
                identificationData.put("etag", etag);
                identificationData.put("jcr:rootVersion", currentVersionNumber);
                String lastVersionComment = "";
                if (currentVersionNumber > 1) {
                    try {
                        lastVersionComment = asset.adaptTo(Node.class).getNode("jcr:content").getProperty("cq:versionComment").getString();
                    }
                    catch (Exception e) {
                        log.debug("Failed to get the last version comment", (Throwable)e);
                        lastVersionComment = "";
                    }
                }
                identificationData.put("cq:versionComment", lastVersionComment);
            }
            catch (Exception e) {
                log.error("Error in building identification data", (Throwable)e);
            }
        }
        return identificationData;
    }

    private static long getLastModificationDate(Asset asset) {
        long lastModificationDate = asset.getLastModified();
        if (lastModificationDate == 0L) {
            lastModificationDate = System.currentTimeMillis();
        }
        return lastModificationDate;
    }

    public static String buildXMPData(Resource resource) throws PathNotFoundException, RepositoryException, XMPException {
        try {
            Node resourceNode = resource.adaptTo(Node.class);
            SimpleXmpToJcrMetadataBuilder jcrBuilder = new SimpleXmpToJcrMetadataBuilder();
            Node metadataNode = resourceNode.getNode("jcr:content/metadata");
            if (metadataNode == null) {
                return "";
            }
            XMPMeta xmpMeta = jcrBuilder.getXmpFromJcr(metadataNode);
            String xmlStr = XMPMetaFactory.serializeToString(xmpMeta, new SerializeOptions());
            return xmlStr;
        }
        catch (Exception e) {
            log.error("Error in building xmp string for resource", (Throwable)e);
            return "";
        }
    }

    public static JSONObject buildBasicData(Resource resource, String remoteUser, AssetManager assetManager) {
        JSONObject basicData;
        block13: {
            basicData = new JSONObject();
            try {
                long creationDate;
                Node resourceNode = resource.adaptTo(Node.class);
                try {
                    creationDate = resourceNode.getProperty("jcr:created").getLong();
                }
                catch (Exception e1) {
                    log.warn("Failed to get creation date");
                    creationDate = System.currentTimeMillis();
                }
                basicData.put("jcr:created", creationDate);
                Asset asset = resource.adaptTo(Asset.class);
                if (asset != null) {
                    long lastModificationDate = DriveUtil.getLastModificationDate(asset);
                    basicData.put("jcr:lastModified", lastModificationDate);
                    long size = 0L;
                    try {
                        Property sizeProperty = resourceNode.getNode("jcr:content").getNode("metadata").getProperty("dam:size");
                        if (sizeProperty != null) {
                            size = sizeProperty.getLong();
                        }
                    }
                    catch (Exception e) {
                        log.warn("Failed to asset size from property");
                        size = 0L;
                    }
                    if (size == 0L) {
                        size = asset.getOriginal().getSize();
                    }
                    basicData.put("dam:size", size);
                    JSONArray flags = new JSONArray();
                    if (asset.getMetadata().size() > 0) {
                        flags.put((Object)Flag.HAS_XMP);
                    }
                    if (asset.getRenditions().size() > 0) {
                        flags.put((Object)Flag.HAS_ICON);
                    }
                    basicData.put("flags", flags);
                    basicData.put("jcr:mimeType", asset.getMimeType());
                    basicData.put("jcr:lastModifiedBy", asset.getModifier());
                    JSONObject lock = new JSONObject();
                    lock.put("jcr:path", asset.getPath());
                    Node jcrContent = resourceNode.getNode("jcr:content");
                    String driveLockOwner = "";
                    if (jcrContent.hasProperty("cq:drivelock")) {
                        driveLockOwner = jcrContent.getProperty("cq:drivelock").getString();
                        lock.put("jcr:lockOwner", driveLockOwner);
                        lock.put("jcr:path", asset.getPath());
                    }
                    boolean isLockOwner = driveLockOwner.equals(remoteUser);
                    lock.put("isLockOwner", isLockOwner);
                    basicData.put("lock", lock);
                    break block13;
                }
                LabeledResource lr = resource.adaptTo(LabeledResource.class);
                Node metaNode = null;
                if (resourceNode.hasNode("jcr:content/metadata")) {
                    metaNode = resourceNode.getNode("jcr:content/metadata");
                }
                ResourceMetadata data = resource.getResourceMetadata();
                long lastModificationDate = data.getModificationTime();
                basicData.put("jcr:lastModified", lastModificationDate);
            }
            catch (Exception e) {
                log.error("Failed in building basic data", (Throwable)e);
            }
        }
        return basicData;
    }

    public static JSONObject getIconData(Resource resource, DriveRenditionPicker picker) {
        Resource renditionsRes = resource.adaptTo(Asset.class) != null ? resource.getChild("jcr:content/renditions") : resource.getChild("jcr:frozenNode/jcr:content/renditions");
        JSONObject obj = new JSONObject();
        if (renditionsRes == null) {
            return obj;
        }
        Iterator<Resource> itr = renditionsRes.getChildren().iterator();
        ArrayList<Resource> renditions = new ArrayList<Resource>();
        while (itr.hasNext()) {
            Resource res = itr.next();
            renditions.add(res);
        }
        Resource thumnailRendition = picker.getThumbnailRendition(renditions);
        Resource previewRendition = picker.getPreviewRendition(renditions);
        try {
            obj.put(IconConstants.THUMBNAIL_RENDITION, DriveUtil.getJsonFromRendition(thumnailRendition));
            obj.put(IconConstants.PREVIEW_RENDITION, DriveUtil.getJsonFromRendition(previewRendition));
        }
        catch (JSONException e) {
            log.error("Failed in getting icon data", (Throwable)e);
        }
        return obj;
    }

    public static boolean userOwnsAllLocks(Node node, String userID) throws RepositoryException {
        String lockOwner;
        if (node.hasProperty("cq:drivelock") && !(lockOwner = node.getProperty("cq:drivelock").getString()).equals(userID)) {
            return false;
        }
        if (!node.hasNodes()) {
            return true;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            if (DriveUtil.userOwnsAllLocks(iter.nextNode(), userID)) continue;
            return false;
        }
        return true;
    }

    private static JSONObject getJsonFromRendition(Resource rend) {
        JSONObject json = new JSONObject();
        try {
            if (rend != null) {
                json.put("jcr:path", rend.getPath());
                json.put("exif:PixelXDimension", DriveUtil.getWidth(rend));
                json.put("exif:PixelYDimension", DriveUtil.getHeight(rend));
                String mimeType = rend.getChild("jcr:content").adaptTo(Node.class).getProperty("jcr:mimeType").getString();
                json.put("jcr:mimeType", mimeType);
            }
        }
        catch (Exception e) {
            log.error("Failed in getting json from rendition", (Throwable)e);
        }
        return json;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WidthBasedRenditionComparator
    implements Comparator<Resource> {
        private WidthBasedRenditionComparator() {
        }

        @Override
        public int compare(Resource r1, Resource r2) {
            int w2;
            int w1 = DriveUtil.getWidth(r1);
            if (w1 < (w2 = DriveUtil.getWidth(r2))) {
                return -1;
            }
            if (w1 == w2) {
                return 0;
            }
            return 1;
        }
    }
}

