/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.drive.util;

import com.day.cq.dam.drive.util.DriveRenditionPicker;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value={DriveRenditionPicker.class})
@Component(metatype=true)
@Properties(value={@Property(name="service.ranking", intValue={400}, propertyPrivate=false)})
public class PrefixRenditionPicker
implements DriveRenditionPicker {
    private String prefix;
    private boolean returnOriginal;

    public PrefixRenditionPicker(String startsWith) {
        this(startsWith, false);
    }

    public PrefixRenditionPicker() {
    }

    public PrefixRenditionPicker(String prefix, boolean returnOriginal) {
        this.prefix = prefix;
        this.returnOriginal = returnOriginal;
    }

    public Resource getRendition(Iterator<Resource> renditions) {
        Resource original = null;
        while (renditions.hasNext()) {
            Resource rendition = renditions.next();
            if ("original".equals(rendition.getName())) {
                original = rendition;
            }
            if (!rendition.getName().startsWith(this.prefix)) continue;
            return rendition;
        }
        if (this.returnOriginal) {
            return original;
        }
        return null;
    }

    public String getId() {
        return "prefix";
    }

    @Override
    public Resource getPreviewRendition(List<Resource> renditions) {
        return null;
    }

    @Override
    public Resource getThumbnailRendition(List<Resource> renditions) {
        return null;
    }
}

