/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.drive.util;

import com.day.cq.dam.drive.util.DriveRenditionPicker;
import com.day.cq.dam.drive.util.DriveUtil;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value={DriveRenditionPicker.class})
@Component(metatype=true)
@Properties(value={@Property(name="service.ranking", intValue={600}, propertyPrivate=false)})
public class WidthBasedRenditionPickerImpl
implements DriveRenditionPicker {
    int thumbnailWidth;
    int previewWidth;
    @Property(intValue={319}, label="Width for thumbnail rendition", description="Allows to specify the rendition width for thumbnails")
    public static final String THUMBNAIL_WIDTH = "cq.dam.asset.thumbnail.width";
    @Property(intValue={1280}, label="Width for preview rendition", description="Allows to specify the rendition width for previews")
    public static final String PREVIEW_WIDTH = "cq.dam.asset.preview.width";

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this.thumbnailWidth = OsgiUtil.toInteger(componentContext.getProperties().get(THUMBNAIL_WIDTH), 319);
        this.previewWidth = OsgiUtil.toInteger(componentContext.getProperties().get(PREVIEW_WIDTH), 1280);
    }

    @Override
    public Resource getPreviewRendition(List<Resource> renditions) {
        return DriveUtil.getBestFitRendition(this.previewWidth, renditions);
    }

    @Override
    public Resource getThumbnailRendition(List<Resource> renditions) {
        return DriveUtil.getBestFitRendition(this.thumbnailWidth, renditions);
    }
}

