/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.epub;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.handler.standard.epub.EPubExtractor;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true, metatype=false)
@Service
public class EPubHandler
extends AbstractAssetHandler {
    private static final String THUMBNAIL = "thumbnail";
    private static final Logger log = LoggerFactory.getLogger(EPubHandler.class);
    public static final String EPUB_MIME_TYPE = "application/epub+zip";
    public static final String[] MIME_TYPES = new String[]{"application/epub+zip"};

    private void _setMD(Map<String, String> md, String mdname, ExtractedMetadata xmd, String xmdname) {
        String v = md.get(mdname);
        if (v != null) {
            xmd.setMetaDataProperty(xmdname, v);
        }
    }

    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        try {
            byte[] bimg;
            ExtractedMetadata metadata = new ExtractedMetadata();
            log.debug("extractMetadata: start extracting asset [{}]", (Object)asset.getPath());
            EPubExtractor mdext = new EPubExtractor();
            InputStream is = asset.getOriginal().getStream();
            Map<String, String> md = mdext.extractMetadata(is);
            if (md == null) {
                log.debug("unable to extract metadata");
                return null;
            }
            this._setMD(md, "subject", metadata, "dc:description");
            this._setMD(md, "contributor", metadata, "dc:contributor");
            this._setMD(md, "creator", metadata, "dc:creator");
            this._setMD(md, "title", metadata, "dc:title");
            this._setMD(md, "language", metadata, "dc:language");
            this._setMD(md, "publisher", metadata, "dc:publisher");
            this._setMD(md, "date", metadata, "dc:date");
            this._setMD(md, "rights", metadata, "dc:rights");
            String coverhref = md.get("_coverhref");
            if (coverhref != null && (bimg = mdext.extractImage(is = asset.getOriginal().getStream(), coverhref)) != null) {
                metadata.setProperty(THUMBNAIL, bimg);
            }
            return metadata;
        }
        catch (Exception ex) {
            log.warn("extractMetadata: error while extracting metadata from EPub [{}]: ", (Object)asset.getPath(), (Object)ex);
            return null;
        }
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        Asset asset = rendition.getAsset();
        ExtractedMetadata metadata = this.extractMetadata(asset);
        byte[] buff = (byte[])metadata.getProperty(THUMBNAIL);
        if (buff != null) {
            return new Layer((InputStream)new ByteArrayInputStream(buff), dim).getImage();
        }
        log.warn("Failed to retrieve thumbnail for {}", (Object)asset.getPath());
        return null;
    }

    @Override
    public String[] getMimeTypes() {
        return MIME_TYPES;
    }
}

