/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.ooxml;

import com.adobe.granite.asset.api.AssetException;
import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.handler.standard.ooxml.OpenOfficeHandler;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true, metatype=false)
@Service
public class MSPowerPointOOXMLHandler
extends OpenOfficeHandler {
    private static final String SUB_ASSET_PREFIX = "slide_";
    private static final String PPTX_EXT = ".pptx";
    private static final Logger log = LoggerFactory.getLogger(MSPowerPointOOXMLHandler.class);
    public static final String MIMETYPE_PPTX = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final String DEFAULT_PAGES_REGEX = "^slide_[0-9]*.pptx";
    @Property(name="cq.dam.pptx.pages.regex", value={"^slide_[0-9]*.pptx"}, label="pptx pages regex", description="Regex for identifying pages in subassets folder. The pages will be shown in assets page viewer")
    public static final String PAGES_REGEX = "cq.dam.pptx.pages.regex";
    private String pagesRegex;

    @Override
    public boolean canHandleSubAssets() {
        return true;
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{MIMETYPE_PPTX};
    }

    private void removeSubAssets(Asset asset, AssetManager assetManager) {
        Collection<Asset> subAssets = asset.getSubAssets();
        for (Asset subAsset : subAssets) {
            assetManager.removeAsset(subAsset.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> processSubAssets(Asset asset) {
        ArrayList<String> subAssets = new ArrayList<String>();
        if (asset.isSubAsset()) {
            return subAssets;
        }
        InputStream is = null;
        try {
            is = asset.getOriginal().getStream();
            boolean oldBatchMode = asset.isBatchMode();
            asset.setBatchMode(true);
            AssetManager assetManager = asset.getOriginal().getResourceResolver().adaptTo(AssetManager.class);
            this.removeSubAssets(asset, assetManager);
            XMLSlideShow slideShow = new XMLSlideShow(is);
            for (int i = 0; i < slideShow.getSlides().length; ++i) {
                int slideNumber = i + 1;
                XMLSlideShow extractedSlide = this.extractSlideByIndex(slideShow, asset, slideNumber);
                FileOutputStream itout = null;
                File pptTmpFile = null;
                FileInputStream iis = null;
                try {
                    pptTmpFile = File.createTempFile("pptx", ".tmp");
                    itout = FileUtils.openOutputStream((File)pptTmpFile);
                    extractedSlide.write((OutputStream)itout);
                    String fileName = SUB_ASSET_PREFIX + slideNumber + PPTX_EXT;
                    iis = FileUtils.openInputStream((File)pptTmpFile);
                    Asset subAsset = asset.addSubAsset(fileName, asset.getMimeType(), iis);
                    subAssets.add(subAsset.getPath());
                }
                catch (IOException e) {
                    block15: {
                        try {
                            log.warn("error extracting subassets from asset {0} reason {1}", (Object)asset.getPath(), (Object)e.getMessage());
                            if (!log.isDebugEnabled()) break block15;
                            log.debug("Stack Trace", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(iis);
                            IOUtils.closeQuietly(itout);
                            FileUtils.deleteQuietly((File)pptTmpFile);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly(iis);
                    IOUtils.closeQuietly((OutputStream)itout);
                    FileUtils.deleteQuietly((File)pptTmpFile);
                    continue;
                }
                IOUtils.closeQuietly((InputStream)iis);
                IOUtils.closeQuietly((OutputStream)itout);
                FileUtils.deleteQuietly((File)pptTmpFile);
                continue;
            }
            asset.adaptTo(Node.class).getSession().save();
            asset.setBatchMode(oldBatchMode);
        }
        catch (IOException e) {
            log.warn("error parsing asset {0} reason {1}", (Object)asset.getPath(), (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug("Stack Trace", (Throwable)e);
            }
        }
        catch (RepositoryException e) {
            log.warn("error parsing asset {0} reason {1}", (Object)asset.getPath(), (Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug("Stack Trace", (Throwable)e);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        this.cleanup(asset);
        this.updatePageRelations(asset);
        return subAssets;
    }

    private void cleanup(Asset asset) {
        AssetManager assetManager = asset.getOriginal().getResourceResolver().adaptTo(AssetManager.class);
        com.adobe.granite.asset.api.Asset graniteAsset = asset.adaptTo(com.adobe.granite.asset.api.Asset.class);
        try {
            graniteAsset.removeRelation("pages");
        }
        catch (AssetException ae) {
            log.debug("Exception occured while deleting pages relation", (Throwable)ae);
        }
    }

    private void updatePageRelations(Asset asset) {
        Collection<Asset> subAssets = asset.getSubAssets();
        int numPages = 0;
        if (!subAssets.isEmpty()) {
            com.adobe.granite.asset.api.Asset graniteAsset = asset.adaptTo(com.adobe.granite.asset.api.Asset.class);
            for (Asset subAsset : subAssets) {
                if (!subAsset.getName().matches(this.pagesRegex)) continue;
                graniteAsset.addRelation("pages", subAsset.getPath());
                ++numPages;
            }
            if (numPages > 0) {
                ResourceResolver resolver = graniteAsset.getResourceResolver();
                Node assetNode = resolver.getResource(asset.getPath()).adaptTo(Node.class);
                try {
                    Node metadataNode = assetNode.getNode("jcr:content/metadata");
                    metadataNode.setProperty("dam:numPages", (long)numPages);
                }
                catch (PathNotFoundException e) {
                    log.warn("Unable to set dam:numPages on " + asset.getPath());
                    log.debug("Exception while setting dam:numPages on " + asset.getPath(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to set dam:numPages on " + asset.getPath());
                    log.debug("Exception while setting dam:numPages on " + asset.getPath(), (Throwable)e);
                }
            }
        }
    }

    private XMLSlideShow extractSlideByIndex(XMLSlideShow slideShow, Asset asset, int slideNumber) {
        XMLSlideShow slideShowNew;
        block9: {
            slideShowNew = new XMLSlideShow();
            try {
                slideShowNew.setPageSize(slideShow.getPageSize());
                XSLFSlide[] slides = slideShow.getSlides();
                int i = 1;
                for (XSLFSlide srcSlide : slides) {
                    if (i == slideNumber) {
                        POIXMLProperties src_properties;
                        XSLFSlideLayout src_layout = srcSlide.getSlideLayout();
                        XSLFSlideMaster src_master = srcSlide.getSlideMaster();
                        XSLFTheme src_theme = srcSlide.getTheme();
                        XSLFNotes src_notes = srcSlide.getNotes();
                        XSLFSlide newSlide = slideShowNew.createSlide();
                        if (src_master != null) {
                            newSlide.getSlideMaster().importContent((XSLFSheet)src_master);
                        }
                        if (src_theme != null) {
                            newSlide.getTheme().importTheme(src_theme);
                        }
                        if (src_layout != null) {
                            newSlide.getSlideLayout().importContent((XSLFSheet)src_layout);
                        }
                        XSLFNotes newNotesSlide = slideShowNew.getNotesSlide(newSlide);
                        if (src_notes != null) {
                            newNotesSlide.importContent((XSLFSheet)src_notes);
                        }
                        if ((src_properties = slideShow.getProperties()) != null) {
                            slideShowNew.getProperties().getCoreProperties().setTitle(SUB_ASSET_PREFIX + slideNumber + "_" + src_properties.getCoreProperties().getTitle());
                            slideShowNew.getProperties().getCoreProperties().setDescription(src_properties.getCoreProperties().getDescription());
                            slideShowNew.getProperties().getCoreProperties().setCreated(src_properties.getCoreProperties().getCreated().toString());
                            slideShowNew.getProperties().getCoreProperties().setCreator(src_properties.getCoreProperties().getCreator());
                            slideShowNew.getProperties().getCoreProperties().setModified(src_properties.getCoreProperties().getModified().toString());
                            slideShowNew.getProperties().getCoreProperties().setRevision(src_properties.getCoreProperties().getRevision());
                            slideShowNew.getProperties().getCoreProperties().setContentType(src_properties.getCoreProperties().getContentType());
                            slideShowNew.getProperties().getCoreProperties().setCategory(src_properties.getCoreProperties().getCategory());
                            slideShowNew.getProperties().getCoreProperties().setKeywords(src_properties.getCoreProperties().getKeywords());
                        }
                        newSlide.importContent((XSLFSheet)srcSlide);
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                log.warn("extractSlideByIndex : Error extracting explicit slide number " + Integer.toString(slideNumber) + " from asset " + asset.getPath() + " reason " + e.getMessage());
                if (!log.isDebugEnabled()) break block9;
                log.debug("Stack Trace", (Throwable)e);
            }
        }
        return slideShowNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        InputStream is = rendition.getStream();
        XMLSlideShow slideShow = new XMLSlideShow(is);
        XSLFSlide[] slides = slideShow.getSlides();
        if (slides != null && slides.length > 0) {
            dim = slideShow.getPageSize();
            try {
                BufferedImage image = new BufferedImage(dim.width, dim.height, 1);
                Graphics2D graphics = image.createGraphics();
                slides[0].draw(graphics);
                BufferedImage bufferedImage = new Layer(image).getImage();
                return bufferedImage;
            }
            catch (Exception e) {
                log.warn("getImage: error while getting image for {} reason: {}", (Object)rendition.getPath(), (Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug("Stack Trace", (Throwable)e);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return null;
    }

    @Activate
    private void activate(Map<String, Object> config) throws IOException {
        this.pagesRegex = OsgiUtil.toString(config.get(PAGES_REGEX), DEFAULT_PAGES_REGEX);
    }
}

