/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.ooxml;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.commons.xml.DocumentBuilderFactoryProvider;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

@Component(inherit=true, metatype=false)
@Service
public class OpenOfficeHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(OpenOfficeHandler.class);
    public static final String MIMETYPE_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String MIMETYPE_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String[] MIMETYPES_SUPPORTED = new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};
    private static final String ENTRY_CORE = "docProps/core.xml";
    private static final String ENTRY_APP = "docProps/app.xml";
    private static final String ENTRY_THUMBNAIL = "docProps/thumbnail.jpeg";
    private static final String ENTRY_THUMBNAIL_EMF = "docProps/thumbnail.emf";
    @Reference(policy=ReferencePolicy.STATIC)
    protected MimeTypeService mimeTypeService;
    private static final String META_KEY_THUMBNAIL = "thumbnail";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(asset.getOriginal().getStream()));
        ExtractedMetadata metadata = new ExtractedMetadata();
        try {
            this.readEntries(zis, metadata, asset);
        }
        catch (Exception e) {
            log.warn("Failed to extract metadata for {} reason: {}", (Object)asset.getPath(), (Object)e.getMessage());
            log.debug("Stack Trace: ", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
        this.setMimetype(metadata, asset);
        return metadata;
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        Asset asset = rendition.getAsset();
        byte[] picture = (byte[])this.extractMetadata(asset).getProperty(META_KEY_THUMBNAIL);
        if (picture != null) {
            return new Layer((InputStream)new ByteArrayInputStream(picture), dim).getImage();
        }
        log.warn("Failed to retrieve thumbnail for {}", (Object)asset.getPath());
        return null;
    }

    @Override
    public String[] getMimeTypes() {
        return MIMETYPES_SUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEntries(ZipInputStream zis, ExtractedMetadata metadata, Asset asset) throws Exception {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            ByteArrayOutputStream out;
            String name = entry.getName();
            if (name.equals(ENTRY_CORE) || name.equals(ENTRY_APP)) {
                Element next;
                out = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)zis, (OutputStream)out);
                DocumentBuilderFactoryProvider factoryprovider = new DocumentBuilderFactoryProvider();
                DocumentBuilderFactory documentBuilderFactory = factoryprovider.createSecureBuilderFactory(true);
                Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(out.toByteArray()));
                IOUtils.closeQuietly((OutputStream)out);
                DocumentTraversal dt = (DocumentTraversal)((Object)document);
                NodeIterator nit = dt.createNodeIterator(document, 1, null, true);
                nit.nextNode();
                while ((next = (Element)nit.nextNode()) != null) {
                    metadata.setMetaDataProperty(next.getLocalName(), next.getTextContent());
                }
                continue;
            }
            if (name.equals(ENTRY_THUMBNAIL)) {
                out = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)zis, (OutputStream)out);
                    metadata.setProperty(META_KEY_THUMBNAIL, out.toByteArray());
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                    continue;
                }
            }
            if (!name.equals(ENTRY_THUMBNAIL_EMF)) continue;
            out = new ByteArrayOutputStream();
            String mimeType = this.mimeTypeService.getMimeType(name);
            try {
                IOUtils.copy((InputStream)zis, (OutputStream)out);
                asset.addRendition("thumbnail.emf", (InputStream)new ByteArrayInputStream(out.toByteArray()), mimeType);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }
}

