/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.pdf;

import com.adobe.granite.asset.api.AssetException;
import com.adobe.granite.asset.api.AssetManager;
import com.adobe.granite.asset.api.AssetRelation;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.RandomAccessFileByteWriter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomDecodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryptionType;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCBaseState;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptions;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptionsBase;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMService;
import com.adobe.internal.pdftoolkit.services.rasterizer.PageRasterizer;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.security.SecurityKeyPassword;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetReferenceResolver;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.handler.gibson.fontmanager.FontManagerService;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.jcr.Node;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.contentdetection.ContentAwareMimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true, metatype=true)
@Service
public class PdfHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(PdfHandler.class);
    @Reference(policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected ContentAwareMimeTypeService mimeTypeService;
    @Property(intValue={0}, name="max.pages")
    private static final String MAX_PAGES = "max.pages";
    @Property(boolValue={false}, name="raster.annotation")
    private static final String RASTER_ANNOTATION = "raster.annotation";
    public static final String CONTENT_MIMETYPE = "application/pdf";
    private static final String AI_MIMETYPE_1 = "application/postscript";
    private static final String AI_MIMETYPE_2 = "application/illustrator";
    private static final double PDF_UNITS_PER_INCH = 72.0;
    @Reference
    private FontManagerService fontManagerService;
    @Reference(policy=ReferencePolicy.STATIC)
    private AssetReferenceResolver caRefResolver;
    protected boolean rasterAnn;
    protected int maxPages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata;
        block49: {
            metadata = new ExtractedMetadata();
            log.debug("extractMetadata: importing asset [{}]", (Object)asset.getPath());
            InputStream is = null;
            InputStreamByteReader byteReader = null;
            PDFDocument pdfDoc = null;
            try {
                is = asset.getOriginal().getStream();
                byteReader = new InputStreamByteReader(is);
                pdfDoc = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)PDFOpenOptions.newInstance());
                boolean canRead = true;
                if (pdfDoc.isEncrypted()) {
                    try {
                        this.unlock(pdfDoc);
                    }
                    catch (Exception e) {
                        log.warn("extractMetadata: unable to decrypt document [{}]: ", (Object)asset.getPath(), (Object)e);
                        canRead = false;
                    }
                }
                if (!canRead) break block49;
                DocumentMetadata pdfMetadata = XMPService.getDocumentMetadata((PDFDocument)pdfDoc);
                try {
                    PDFRectangle cropBox;
                    PDFPageTree pdfPageTree = pdfDoc.requirePages();
                    int numPages = pdfPageTree.getNumPages();
                    metadata.setMetaDataProperty("numPages", numPages);
                    if (numPages > 0 && (cropBox = pdfPageTree.getPage(0).getCropBox()) != null && cropBox.width() > 0.0 && cropBox.height() > 0.0) {
                        metadata.setMetaDataProperty("Physical width in inches", cropBox.width() / 72.0);
                        metadata.setMetaDataProperty("Physical height in inches", cropBox.height() / 72.0);
                    }
                }
                catch (Exception e) {
                    log.error("extractMetadata: error extracting number of pages in the pdf ", (Object)asset.getPath(), (Object)e);
                }
                if (pdfMetadata.getAuthor() != null) {
                    metadata.setMetaDataProperty("Author", pdfMetadata.getAuthor());
                }
                if (pdfMetadata.getCreationDate() != null) {
                    metadata.setMetaDataProperty("CreationDate", pdfMetadata.getCreationDate());
                }
                if (pdfMetadata.getModificationDate() != null) {
                    metadata.setMetaDataProperty("ModificationDate", pdfMetadata.getModificationDate());
                }
                if (pdfMetadata.getProducer() != null) {
                    metadata.setMetaDataProperty("Producer", pdfMetadata.getProducer());
                }
                if (pdfMetadata.getSubject() != null) {
                    metadata.setMetaDataProperty("Subject", pdfMetadata.getSubject());
                }
                if (pdfMetadata.getTitle() != null) {
                    metadata.setMetaDataProperty("Title", pdfMetadata.getTitle());
                }
                if (pdfMetadata.getTrapped() != null) {
                    metadata.setMetaDataProperty("Trapped", pdfMetadata.getTrapped());
                }
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    pdfMetadata.exportXMP((OutputStream)out);
                    metadata.setXmp(new ByteArrayInputStream(out.toByteArray()));
                }
                catch (Exception e) {
                    log.error("extractMetadata: cannot import embedded XMP data for document [{}]: ", (Object)asset.getPath(), (Object)e);
                    log.warn("Failed to set xmp metadata for the asset {}, trying to extract using DefaultFormatHandler", (Object)asset.getPath());
                    this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
                }
            }
            catch (IOException e) {
                log.warn("extractMetadata: error while extracting metadata from PDF [{}]: ", (Object)asset.getPath(), (Object)e);
            }
            catch (PDFException e) {
                log.warn("extractMetadata: error while extracting metadata from PDF [{}]: ", (Object)asset.getPath(), (Object)e);
            }
            finally {
                if (pdfDoc != null) {
                    try {
                        pdfDoc.close();
                    }
                    catch (Exception e) {
                        log.debug("extractMetadata: error while closing PDF document [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
                if (byteReader != null) {
                    try {
                        byteReader.close();
                    }
                    catch (IOException e) {
                        log.debug("extractMetadata: error while closing byteReader [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.debug("extractMetadata: error while closing inputStream [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
            }
        }
        this.setMimetype(metadata, asset);
        return metadata;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.rasterAnn = PropertiesUtil.toBoolean(properties.get(RASTER_ANNOTATION), false);
        this.maxPages = PropertiesUtil.toInteger(properties.get(MAX_PAGES), -1);
    }

    private void unlock(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEncryptionType encryptionType = pdfDoc.getEncryptionType();
        if (encryptionType.equals(PDFEncryptionType.Password)) {
            SecurityKeyPassword defaultKey = SecurityKeyPassword.newInstance((PDFDocument)pdfDoc);
            pdfDoc.unlock((SecurityKey)defaultKey);
        }
    }

    private RandomAccessFile getRandomAccessFileForWriting(File file, boolean create) throws IOException {
        RandomAccessFile raf = null;
        if (create) {
            file.delete();
            if (file.exists()) {
                throw new IOException("Failed to delete pre-existing file: \"" + file.getAbsolutePath() + "\".");
            }
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            file.createNewFile();
        }
        raf = new RandomAccessFile(file, "rw");
        return raf;
    }

    public ByteWriter getRAFByteWriter(File file) throws IOException {
        RandomAccessFile raf = this.getRandomAccessFileForWriting(file, true);
        RandomAccessFileByteWriter byteWriter = new RandomAccessFileByteWriter(raf);
        return byteWriter;
    }

    @Override
    public boolean canHandleSubAssets() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List<String> processSubAssets(Asset asset) {
        ArrayList<String> subAssets;
        block49: {
            subAssets = new ArrayList<String>();
            if (asset.isSubAsset()) {
                return subAssets;
            }
            InputStream is = null;
            PDFDocument pdfDoc = null;
            try {
                boolean oldBatchMode;
                block54: {
                    AssetManager assetManager;
                    block53: {
                        is = asset.getOriginal().getStream();
                        pdfDoc = PdfHandler.parseDocument(is);
                        boolean canRead = true;
                        if (pdfDoc.isEncrypted()) {
                            try {
                                this.unlock(pdfDoc);
                            }
                            catch (Exception e) {
                                log.warn("extractMetadata: unable to decrypt document [{}]: ", (Object)asset.getPath(), (Object)e);
                                canRead = false;
                            }
                        }
                        if (!canRead) break block49;
                        String mimeType = asset.getMimeType();
                        oldBatchMode = asset.isBatchMode();
                        asset.setBatchMode(true);
                        assetManager = asset.getOriginal().getResourceResolver().adaptTo(AssetManager.class);
                        if (!(StringUtils.equals((String)mimeType, (String)AI_MIMETYPE_1) || StringUtils.equals((String)mimeType, (String)AI_MIMETYPE_2)) && null != this.mimeTypeService) {
                            InputStream pdfContentStream = asset.getOriginal().getStream();
                            mimeType = pdfContentStream.markSupported() ? this.mimeTypeService.getMimeType(asset.getName(), pdfContentStream) : this.mimeTypeService.getMimeType(asset.getName(), new BufferedInputStream(pdfContentStream));
                        }
                        if (!StringUtils.equals((String)mimeType, (String)AI_MIMETYPE_1) && !StringUtils.equals((String)mimeType, (String)AI_MIMETYPE_2)) break block53;
                        this.cleanup(asset, assetManager);
                        PDFFontSet fontSet = this.fontManagerService.getPdfFontSet();
                        RasterizationOptions options222 = new RasterizationOptions();
                        options222.setFontSet(fontSet);
                        options222.processAnnotations(this.rasterAnn);
                        PDFOCProperties ocProps = pdfDoc.requireCatalog().getOCProperties();
                        if (ocProps == null) break block54;
                        PDFOCConfig defaultOCConfig = ocProps.getDefaultOCConfigDict();
                        defaultOCConfig.setBaseState(PDFOCBaseState.OFF);
                        Iterator itr = ocProps.getOCGs().iterator();
                        PDFOCGroup ocg = null;
                        int layer = 1;
                        while (itr.hasNext()) {
                            ocg = (PDFOCGroup)itr.next();
                            defaultOCConfig.setONList(PDFOCGroupArray.newInstance((PDFDocument)pdfDoc, (PDFOCGroup)ocg));
                            defaultOCConfig.setOFFList(null);
                            PageRasterizer rasterizer = new PageRasterizer((PDFPageTreeNode)pdfDoc.requirePages(), options222);
                            while (rasterizer.hasNext()) {
                                block50: {
                                    FileOutputStream itout = null;
                                    File imageTmpFile = null;
                                    FileInputStream iis = null;
                                    try {
                                        BufferedImage image = rasterizer.next();
                                        imageTmpFile = File.createTempFile("image", ".tmp");
                                        Layer layerImage = new Layer(image);
                                        String fileName = "layer" + layer + ".png";
                                        itout = FileUtils.openOutputStream((File)imageTmpFile);
                                        layerImage.write("image/png", 1.0, itout);
                                        iis = FileUtils.openInputStream((File)imageTmpFile);
                                        Asset subAsset = asset.addSubAsset(fileName, "image/png", iis);
                                        subAssets.add(subAsset.getPath());
                                        this.updatePageRelations(asset, subAsset.getPath());
                                        IOUtils.closeQuietly((InputStream)iis);
                                    }
                                    catch (Exception e) {
                                        log.warn("processSubAssets: error while creating sub assets for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                                        break block50;
                                    }
                                    finally {
                                        IOUtils.closeQuietly(iis);
                                        IOUtils.closeQuietly(itout);
                                        FileUtils.deleteQuietly((File)imageTmpFile);
                                    }
                                    IOUtils.closeQuietly((OutputStream)itout);
                                    FileUtils.deleteQuietly((File)imageTmpFile);
                                }
                                ++layer;
                            }
                        }
                        break block54;
                    }
                    PDFPageTree pages = pdfDoc.requirePages();
                    this.cleanup(asset, assetManager);
                    if (pages == null) {
                        List<String> options222 = Collections.emptyList();
                        return options222;
                    }
                    Iterator iter = pdfDoc.requirePages().iterator();
                    PMMService pmmService = new PMMService(pdfDoc);
                    for (int i = 0; iter.hasNext() && (this.maxPages < 0 || i < this.maxPages); ++i) {
                        ByteWriter byteWriter;
                        FileInputStream fis;
                        File tmpFile;
                        PDFDocument document;
                        block51: {
                            document = pmmService.extractPages((PDFPage)iter.next(), 1, PMMOptions.newInstance((PMMOptionsBase)PMMOptions.AllOptions), PDFOpenOptions.newInstance());
                            String fileName = "page" + (i + 1) + ".pdf";
                            tmpFile = null;
                            fis = null;
                            byteWriter = null;
                            tmpFile = File.createTempFile(fileName, ".pdf");
                            byteWriter = this.getRAFByteWriter(tmpFile);
                            document.save(byteWriter, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
                            fis = new FileInputStream(tmpFile);
                            Asset subAsset = asset.addSubAsset(fileName, CONTENT_MIMETYPE, fis);
                            subAssets.add(subAsset.getPath());
                            this.updatePageRelations(asset, subAsset.getPath());
                            if (document == null) break block51;
                            try {
                                document.close();
                            }
                            catch (Exception e) {
                                log.warn("processSubAssets: error while closing subAsset document [{}]: ", (Object)asset.getPath(), (Object)e);
                            }
                        }
                        if (byteWriter != null) {
                            try {
                                byteWriter.close();
                            }
                            catch (IOException e) {
                                log.warn("processSubAssets: error while closing byteWriter [{}]: ", (Object)asset.getPath(), (Object)e);
                            }
                        }
                        IOUtils.closeQuietly((InputStream)fis);
                        FileUtils.deleteQuietly((File)tmpFile);
                        continue;
                        catch (Exception e) {
                            block52: {
                                try {
                                    log.warn("createSubAsset: error while creating subasset [" + (i + 1) + "] for [{}]: ", (Object)asset.getPath(), (Object)e);
                                    if (document == null) break block52;
                                }
                                catch (Throwable throwable) {
                                    if (document != null) {
                                        try {
                                            document.close();
                                        }
                                        catch (Exception e2) {
                                            log.warn("processSubAssets: error while closing subAsset document [{}]: ", (Object)asset.getPath(), (Object)e2);
                                        }
                                    }
                                    if (byteWriter != null) {
                                        try {
                                            byteWriter.close();
                                        }
                                        catch (IOException e3) {
                                            log.warn("processSubAssets: error while closing byteWriter [{}]: ", (Object)asset.getPath(), (Object)e3);
                                        }
                                    }
                                    IOUtils.closeQuietly(fis);
                                    FileUtils.deleteQuietly((File)tmpFile);
                                    throw throwable;
                                }
                                try {
                                    document.close();
                                }
                                catch (Exception e4) {
                                    log.warn("processSubAssets: error while closing subAsset document [{}]: ", (Object)asset.getPath(), (Object)e4);
                                }
                            }
                            if (byteWriter != null) {
                                try {
                                    byteWriter.close();
                                }
                                catch (IOException e5) {
                                    log.warn("processSubAssets: error while closing byteWriter [{}]: ", (Object)asset.getPath(), (Object)e5);
                                }
                            }
                            IOUtils.closeQuietly((InputStream)fis);
                            FileUtils.deleteQuietly((File)tmpFile);
                            continue;
                        }
                    }
                }
                asset.adaptTo(Node.class).getSession().save();
                asset.setBatchMode(oldBatchMode);
            }
            catch (Exception e) {
                log.warn("processSubAssets: error while creating sub assets for asset [{}]: ", (Object)asset.getPath(), (Object)e);
            }
            finally {
                if (pdfDoc != null) {
                    try {
                        pdfDoc.close();
                    }
                    catch (Exception e) {
                        log.warn("processSubAssets: error while closing parent pdf document [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
            }
        }
        return subAssets;
    }

    private void updatePageRelations(Asset asset, String subAssetPath) {
        com.adobe.granite.asset.api.Asset graniteAsset = asset.adaptTo(com.adobe.granite.asset.api.Asset.class);
        graniteAsset.addRelation("pages", subAssetPath);
    }

    private void cleanup(Asset asset, AssetManager assetManager) {
        ResourceResolver resolver = asset.adaptTo(Resource.class).getResourceResolver();
        Collection<Asset> subAssets = asset.getSubAssets();
        boolean saveReqd = !subAssets.isEmpty();
        for (Asset subAsset : subAssets) {
            assetManager.removeAsset(subAsset.getPath());
        }
        try {
            com.adobe.granite.asset.api.Asset graniteAsset = asset.adaptTo(com.adobe.granite.asset.api.Asset.class);
            graniteAsset.removeRelation("pages");
            if (saveReqd) {
                resolver.commit();
            }
        }
        catch (AssetException ae) {
            log.debug("Exception occurred while deleting pages relation", (Throwable)ae);
        }
        catch (PersistenceException e) {
            log.debug("Exception occurred while removing subassets", (Throwable)e);
        }
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{CONTENT_MIMETYPE, AI_MIMETYPE_2};
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        RasterizationOptions rasterizationOptions = null;
        try {
            rasterizationOptions = new RasterizationOptions();
        }
        catch (Throwable e) {
            log.warn("getImage: unable to create rasterization option: ", (Object)rendition.getPath(), (Object)e);
            throw new IOException(e.getMessage());
        }
        try {
            PDFFontSet fontSet = null;
            fontSet = this.fontManagerService.getPdfFontSet();
            rasterizationOptions.setFontSet(fontSet);
        }
        catch (Exception e) {
            log.warn("exception: fontmanagerserviceimpl with [{}]", (Object)e.getMessage());
        }
        rasterizationOptions.ignoreErrors(true);
        rasterizationOptions.processAnnotations(this.rasterAnn);
        try {
            return this.getImage(rendition, rasterizationOptions, dim);
        }
        catch (Exception e) {
            log.warn("getImage: unable to generate image : ", (Object)rendition.getPath(), (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(Rendition rendition, RasterizationOptions rasterizationOptions, Dimension dim) throws Exception {
        InputStreamByteReader byteReader = null;
        PDFDocument pdfDoc = null;
        BufferedImage image = null;
        try {
            byteReader = new InputStreamByteReader(rendition.getStream());
            PDFOpenOptions openOptions = PDFOpenOptions.newInstance();
            ArrayList<JPXDecodeFilter> filters = new ArrayList<JPXDecodeFilter>();
            filters.add(new JPXDecodeFilter());
            openOptions.registerCustomFilters(filters);
            pdfDoc = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)openOptions);
            if (pdfDoc.isEncrypted()) {
                try {
                    this.unlock(pdfDoc);
                }
                catch (Exception e) {
                    log.warn("getImage: unable to decrypt document [{}]: ", (Object)rendition.getPath(), (Object)e);
                    BufferedImage bufferedImage = null;
                    if (pdfDoc != null) {
                        pdfDoc.close();
                    }
                    if (byteReader != null) {
                        byteReader.close();
                    }
                    return bufferedImage;
                }
            }
            PDFPageTree pages = pdfDoc.requirePages();
            PDFPage page = pages.getPage(0);
            Dimension d = this.calculateRasterizeDim(dim, page.getCropBox());
            rasterizationOptions.setWidth(d.width);
            rasterizationOptions.setHeight(d.height);
            PageRasterizer rasterizer = new PageRasterizer((PDFPageTreeNode)pages, rasterizationOptions);
            if (rasterizer.hasNext() && (image = rasterizer.next()) != null) {
                Layer layer = new Layer(image);
                image = layer.getImage();
            }
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            if (byteReader != null) {
                byteReader.close();
            }
        }
        return image;
    }

    private static PDFDocument parseDocument(InputStream input) throws IOException, PDFException {
        InputStreamByteReader byteReader = null;
        PDFDocument pdfDoc = null;
        byteReader = new InputStreamByteReader(input);
        try {
            pdfDoc = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)PDFOpenOptions.newInstance());
        }
        catch (PDFException e) {
            log.warn("extractMetadata: error while reading PDF [{}]: ", (Throwable)e);
            throw e;
        }
        return pdfDoc;
    }

    private Dimension calculateRasterizeDim(Dimension dim, PDFRectangle cropBox) throws PDFException {
        double scale;
        if (dim == null || cropBox == null) {
            return new Dimension();
        }
        double cropWidth = cropBox.width();
        double cropHeight = cropBox.height();
        if (cropWidth == 0.0 || cropHeight == 0.0) {
            return new Dimension();
        }
        if (dim.getWidth() <= 0.0 && dim.getHeight() <= 0.0) {
            scale = 1.0;
        } else if (dim.getWidth() <= 0.0) {
            scale = dim.getHeight() / cropHeight;
        } else if (dim.getHeight() <= 0.0) {
            scale = dim.getWidth() / cropWidth;
        } else {
            double scaleX = dim.getWidth() / cropWidth;
            double scaleY = dim.getHeight() / cropHeight;
            scale = Math.min(scaleX, scaleY);
        }
        int width = (int)Math.round(scale * cropWidth);
        int height = (int)Math.round(scale * cropHeight);
        return new Dimension(width, height);
    }

    @Override
    public Iterator<? extends AssetRelation> processRelated(Asset asset) {
        if (!asset.isSubAsset()) {
            return this.caRefResolver.resolve(asset);
        }
        return super.processRelated(asset);
    }

    protected void bindMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        this.mimeTypeService = contentAwareMimeTypeService;
    }

    protected void unbindMimeTypeService(ContentAwareMimeTypeService contentAwareMimeTypeService) {
        if (this.mimeTypeService == contentAwareMimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindFontManagerService(FontManagerService fontManagerService) {
        this.fontManagerService = fontManagerService;
    }

    protected void unbindFontManagerService(FontManagerService fontManagerService) {
        if (this.fontManagerService == fontManagerService) {
            this.fontManagerService = null;
        }
    }

    protected void bindCaRefResolver(AssetReferenceResolver assetReferenceResolver) {
        this.caRefResolver = assetReferenceResolver;
    }

    protected void unbindCaRefResolver(AssetReferenceResolver assetReferenceResolver) {
        if (this.caRefResolver == assetReferenceResolver) {
            this.caRefResolver = null;
        }
    }

    private static class JPXDecodeFilter
    implements CustomDecodeFilter {
        private JPXDecodeFilter() {
        }

        public ASName getName() {
            return ASName.k_JPXDecode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream decode(InputStream is, FilterParams filterParams) throws CustomFilterException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                BufferedImage bufImage = ImageIO.read(is);
                if (bufImage != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((DataBufferByte)bufImage.getData().getDataBuffer()).getData());
                    return byteArrayInputStream;
                }
                InputStream inputStream = null;
                return inputStream;
            }
            catch (IOException e) {
                log.error("Error decoding the JPX: ", (Object)e.getMessage(), (Object)e);
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error("Error closing the stream: ", (Object)e.getMessage(), (Object)e);
                }
            }
            return null;
        }
    }
}

