/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.psd;

import com.adobe.granite.asset.api.AssetRelation;
import com.adobe.xmp.core.XMPMetadata;
import com.adobe.xmp.core.serializer.RDFXMLSerializer;
import com.adobe.xmp.core.serializer.RDFXMLSerializerContext;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetReferenceResolver;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.xmp.XMPHandler;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.image.Layer;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageReader;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageReaderSpi;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true, metatype=true)
@Service
public class PsdHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(PsdHandler.class);
    private static final ImageReaderSpi provider = new PSDImageReaderSpi();
    public static final String CONFIG_LARGE_FILE_THRESHOLD = "large_file_threshold";
    private static final long DEFAULT_LARGE_FILE_THRESHOLD = 500L;
    @Property(longValue={500L}, name="large_file_threshold", label="Threshold size in MB to use intermediate temporary file", description="Asset size greater than threshold use temporary file instead of memory buffer to avoid OutOfMemoryError. Value of -1 means that the use of temporary file is disabled.")
    private long largeFileThreshold = 500L;
    public static final String PHOTOSHOP_MIMETYPE_1 = "application/x-photoshop";
    public static final String PHOTOSHOP_MIMETYPE_2 = "application/photoshop";
    public static final String PHOTOSHOP_MIMETYPE_3 = "image/vnd.adobe.photoshop";
    public static final String PHOTOSHOP_MIMETYPE_4 = "application/vnd.adobe.photoshop";
    public static final String PHOTOSHOP_MIMETYPE_5 = "application/vnd.3gpp.pic-bw-small";
    @Reference(policy=ReferencePolicy.STATIC)
    private AssetReferenceResolver refResolver;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected XMPHandler xmpHandler;

    synchronized void bindXmpHandler(XMPHandler handler) {
        this.xmpHandler = handler;
        log.debug("binding xmp handler");
    }

    synchronized void unbindXmpHandler(XMPHandler handler) {
        this.xmpHandler = null;
        log.debug("un-binding xmp handler");
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        block21: {
            InputStream is = rendition.getStream();
            ImageInputStream stream = null;
            boolean debug = log.isDebugEnabled();
            try {
                BufferedImage bufferedImage;
                ColorModel imageColorModel;
                PSDImageReader reader = new PSDImageReader(provider);
                if (this.doFileBuffering(rendition)) {
                    stream = new FileCacheImageInputStream(is, null);
                    log.debug("Used FileCacheInputImageStream for rendition size [{}]", (Object)rendition.getSize());
                } else {
                    stream = ImageIO.createImageInputStream(is);
                }
                reader.setInput((Object)stream);
                long start = System.currentTimeMillis();
                BufferedImage image = null;
                ImageReadParam param = new ImageReadParam();
                image = reader.read(0, param);
                if (debug) {
                    log.debug("time: " + (System.currentTimeMillis() - start));
                    log.debug("image: " + image);
                }
                if ((imageColorModel = image.getColorModel()).getColorSpace().getType() == 9) {
                    try {
                        BufferedImage tmpImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                        int[] rgbArray = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
                        tmpImage.setRGB(0, 0, image.getWidth(), image.getHeight(), rgbArray, 0, image.getWidth());
                        image = tmpImage;
                    }
                    catch (Exception e) {
                        log.error("Exception", (Throwable)e);
                    }
                    if (debug) {
                        log.debug("time: " + (System.currentTimeMillis() - start));
                        log.debug("image: " + image);
                    }
                }
                FileOutputStream itout = null;
                FileInputStream iis = null;
                File imageTmpFile = null;
                try {
                    imageTmpFile = File.createTempFile("image", ".tmp");
                    Layer layer = new Layer(image);
                    itout = FileUtils.openOutputStream((File)imageTmpFile);
                    layer.write("image/png", 1.0, itout);
                    iis = FileUtils.openInputStream((File)imageTmpFile);
                    bufferedImage = new Layer((InputStream)iis, dim).getImage();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly(iis);
                        IOUtils.closeQuietly(itout);
                        FileUtils.deleteQuietly((File)imageTmpFile);
                        throw throwable;
                    }
                    catch (Exception e) {
                        log.warn("getImage: error while getting image for PSD [{}]: ", (Object)rendition.getPath(), (Object)e);
                        break block21;
                    }
                }
                IOUtils.closeQuietly((InputStream)iis);
                IOUtils.closeQuietly((OutputStream)itout);
                FileUtils.deleteQuietly((File)imageTmpFile);
                return bufferedImage;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
                try {
                    stream.close();
                }
                catch (Exception ignore) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata = new ExtractedMetadata();
        InputStream is = asset.getOriginal().getStream();
        ImageInputStream stream = null;
        try {
            PSDImageReader reader = new PSDImageReader(null);
            if (this.doFileBuffering(asset.getOriginal())) {
                stream = new FileCacheImageInputStream(is, null);
                log.debug("Used FileCacheInputImageStream for size [{}]", (Object)asset.getOriginal().getSize());
            } else {
                stream = ImageIO.createImageInputStream(is);
            }
            reader.setInput((Object)stream);
            metadata.setMetaDataProperty("tiff:ImageWidth", reader.getWidth(0));
            metadata.setMetaDataProperty("tiff:ImageLength", reader.getHeight(0));
            this.setMimetype(metadata, asset);
        }
        catch (IOException e) {
            log.error("I/O error while getting metadata", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            try {
                stream.close();
            }
            catch (Exception ignore) {}
        }
        ByteArrayInputStream xmps = null;
        if (this.xmpHandler != null) {
            try {
                XMPMetadata xmpMetadata = this.xmpHandler.readXmpMetadata(asset);
                if (xmpMetadata == null) return metadata;
                byte[] xmpBytes = new RDFXMLSerializer().serializeToBuffer(xmpMetadata, new RDFXMLSerializerContext());
                xmps = new ByteArrayInputStream(xmpBytes);
                metadata.setXmp(xmps);
                return metadata;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error("Couldn't extract metadata using XMPhandler, attempting brute-force extraction", (Throwable)e);
                } else {
                    log.warn("Couldn't extract metadata using XMPhandler, attempting brute-force extraction");
                }
                this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
                return metadata;
            }
            finally {
                IOUtils.closeQuietly(xmps);
            }
        } else {
            this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
        }
        return metadata;
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{PHOTOSHOP_MIMETYPE_1, PHOTOSHOP_MIMETYPE_2, PHOTOSHOP_MIMETYPE_3, PHOTOSHOP_MIMETYPE_4, PHOTOSHOP_MIMETYPE_5};
    }

    @Override
    public Iterator<? extends AssetRelation> processRelated(Asset asset) {
        return this.refResolver.resolve(asset);
    }

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException {
        this.largeFileThreshold = PropertiesUtil.toLong(context.getProperties().get(CONFIG_LARGE_FILE_THRESHOLD), 500L);
    }

    private boolean doFileBuffering(Rendition r) {
        return this.largeFileThreshold != -1L && this.largeFileThreshold <= r.getSize();
    }

    protected void bindRefResolver(AssetReferenceResolver assetReferenceResolver) {
        this.refResolver = assetReferenceResolver;
    }

    protected void unbindRefResolver(AssetReferenceResolver assetReferenceResolver) {
        if (this.refResolver == assetReferenceResolver) {
            this.refResolver = null;
        }
    }
}

