/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.api.constants;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Scene7AssetType {
    IMAGE("Image"),
    VIDEO("Video"),
    TEMPLATE("Template"),
    PSD_TEMPLATE("PsdTemplate"),
    FLASH("Flash"),
    GENERIC("Generic"),
    MASTER_VIDEO("MasterVideo"),
    FXG("Fxg"),
    VIEWER_PRESET("ViewerPreset"),
    MBR_SET("MbrSet"),
    CATALOG("Catalog");

    private static final Logger LOGGER;
    private String type;

    private Scene7AssetType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.type;
    }

    public static Scene7AssetType toScene7AssetType(String type) {
        Scene7AssetType[] assetTypes;
        Scene7AssetType assetType = null;
        for (Scene7AssetType validAssetType : assetTypes = Scene7AssetType.values()) {
            if (!validAssetType.getValue().equals(type)) continue;
            assetType = validAssetType;
            break;
        }
        if (assetType == null) {
            LOGGER.warn("Invalid Scene7 asset type '{}'! Using generic asset type!", (Object)type);
            assetType = GENERIC;
        }
        return assetType;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Scene7AssetType.class);
    }
}

