/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.thumbnail.ThumbnailGenerator;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.video.AbstractFFMpegProcess;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@Component(label="Day CQ DAM FFmpeg Thumbnail Process", description="Workflow process that creates thumbnails from video files")
@Service
@Properties(value={@Property(name="process.label", value={"Create Video Thumbnails"}, propertyPrivate=true)})
public class FFMpegThumbnailProcess
extends AbstractFFMpegProcess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processVideo(MetaDataMap metaData, Asset asset, File tmpFile, WorkflowSession wfSession) throws IOException, RepositoryException {
        Object[] args = this.buildArguments(metaData);
        int start = 0;
        int count = 1;
        int index = 0;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("start:") || arg.startsWith("count:") || arg.startsWith("index:")) {
                String[] split = StringUtils.split((String)arg, (String)":");
                if (split.length == 2) {
                    if (arg.startsWith("start:")) {
                        start = NumberUtils.toInt((String)split[1], (int)start);
                    } else if (arg.startsWith("count:")) {
                        if ((count = NumberUtils.toInt((String)split[1], (int)count)) <= 0) {
                            count = 1;
                        }
                    } else if (arg.startsWith("index:")) {
                        index = NumberUtils.toInt((String)split[1], (int)index);
                    }
                }
                args = (String[])ArrayUtils.remove((Object[])args, (int)i);
                continue;
            }
            ++i;
        }
        FFMpegWrapper wrapper = null;
        File tmpWorkingDir = null;
        try {
            tmpWorkingDir = this.createTempDir(this.getWorkingDir());
            wrapper = new FFMpegWrapper(tmpFile, tmpWorkingDir);
            wrapper.setExecutableLocator(this.locator);
            BufferedImage[] thumbnails = wrapper.getThumbnails(count, start);
            if (thumbnails != null && thumbnails.length > 0) {
                BufferedImage thumbnail;
                if (index >= thumbnails.length) {
                    index = thumbnails.length - 1;
                }
                if ((thumbnail = thumbnails[index]) != null) {
                    BufferedImage rgbaThumbnail = new BufferedImage(thumbnail.getWidth(), thumbnail.getHeight(), 2);
                    rgbaThumbnail.getGraphics().drawImage(thumbnail, 0, 0, null);
                    ThumbnailGenerator generator = new ThumbnailGenerator(asset, rgbaThumbnail);
                    generator.generate(ThumbnailGenerator.parseConfig((String[])args));
                }
            } else {
                this.log.warn("Could not create thumbnails for video asset {}, maybe ffmpeg is not installed.", (Object)asset.getPath());
            }
        }
        finally {
            try {
                if (tmpWorkingDir != null) {
                    FileUtils.deleteDirectory((File)tmpWorkingDir);
                }
            }
            catch (IOException e) {
                this.log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
            }
        }
    }

    @Override
    public String[] buildArguments(MetaDataMap metaData) {
        String[] configs;
        String index;
        String count;
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String start = (String)((Object)metaData.get(Arguments.START.name(), String.class));
        if (start != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.START.getArgumentPrefix()).append(start);
            arguments.add(builder.toString());
        }
        if ((count = (String)((Object)metaData.get(Arguments.COUNT.name(), String.class))) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.COUNT.getArgumentPrefix()).append(count);
            arguments.add(builder.toString());
        }
        if ((index = (String)((Object)metaData.get(Arguments.INDEX.name(), String.class))) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.INDEX.getArgumentPrefix()).append(index);
            arguments.add(builder.toString());
        }
        if ((configs = (String[])metaData.get(Arguments.CONFIGS.name(), String[].class)) != null) {
            for (String config : configs) {
                arguments.add(config);
            }
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        START("start"),
        COUNT("count"),
        INDEX("index"),
        CONFIGS("CONFIGS");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

