/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video.servlet;

import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam/components/video/home"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"profiles.list"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Servlet to list all video profiles"})})
public class VideoProfileListServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    private final Logger log = LoggerFactory.getLogger(VideoProfileListServlet.class);

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONWriter writer = new JSONWriter(response.getWriter());
        try {
            writer.array();
            Node videoProfilesRoot = request.getResourceResolver().getResource("/etc/dam/video").adaptTo(Node.class);
            this.loopVideoProfiles(writer, videoProfilesRoot);
            writer.endArray();
        }
        catch (RepositoryException e) {
            throw new ServletException("Could not lookup video profiles.", (Throwable)e);
        }
        catch (JSONException e) {
            throw new ServletException("Error", (Throwable)e);
        }
    }

    private void loopVideoProfiles(JSONWriter writer, Node videoProfilesRoot) throws RepositoryException, JSONException {
        NodeIterator profiles = videoProfilesRoot.getNodes();
        while (profiles.hasNext()) {
            Node profile = profiles.nextNode();
            if (profile.isNodeType("sling:Folder")) {
                if (profile.getName().equals("analyticsreport") || !profile.hasNodes()) continue;
                NodeIterator itr = profile.getNodes();
                while (itr.hasNext()) {
                    Node node = (Node)itr.next();
                    this.writeAdaptiveVideoProfile(writer, node);
                }
                continue;
            }
            if (profile.getName().equals("configuration")) continue;
            if (profile.isNodeType("nt:folder")) {
                this.loopVideoProfiles(writer, profile);
                continue;
            }
            this.writeVideoProfile(writer, profile);
        }
    }

    private void writeVideoProfile(JSONWriter writer, Node profile) throws RepositoryException, JSONException {
        writer.object();
        writer.key("text").value(this.getProfileTitle(profile));
        writer.key("description").value(this.getProfileDescription(profile));
        writer.key("value").value(this.getProfileName(profile));
        writer.endObject();
    }

    private void writeAdaptiveVideoProfile(JSONWriter writer, Node profile) throws RepositoryException, JSONException {
        writer.object();
        writer.key("name").value(profile.getProperty("name").getString());
        if (profile.getProperty("description") != null) {
            writer.key("description").value(profile.getProperty("description").getString());
        }
        writer.key("value").value(this.getAdaptiveVideoProfileDescription(profile));
        writer.endObject();
    }

    private String getProfileTitle(Node profile) throws RepositoryException {
        String title = profile.getPath();
        try {
            Node jcrContent = profile.getNode("jcr:content");
            title = jcrContent.getProperty("jcr:title").getString();
        }
        catch (PathNotFoundException e) {
            this.log.warn("trouble resovling jcr:title property from profile's jcr:content node. Fallback to profile path");
        }
        return title;
    }

    private Object getProfileDescription(Node profile) throws RepositoryException {
        String description = "";
        try {
            Node jcrContent = profile.getNode("jcr:content");
            description = jcrContent.getProperty("jcr:description").getString();
        }
        catch (PathNotFoundException e) {
            this.log.warn("trouble resovling jcr:description property from profile's jcr:content node. Fallback to empty string");
        }
        return description;
    }

    private String getAdaptiveVideoProfileDescription(Node profile) throws RepositoryException {
        String description = "";
        if (profile.hasNodes()) {
            NodeIterator itr = profile.getNodes();
            while (itr.hasNext()) {
                Node node = (Node)itr.next();
                if (description.length() > 0) {
                    description = description + " | ";
                }
                description = description + node.getName();
            }
        }
        return description;
    }

    private String getProfileName(Node profileNode) throws RepositoryException {
        String path = profileNode.getPath();
        String resourceType = this.getResourceType(profileNode);
        if (path.startsWith("/etc/dam/video/")) {
            if (resourceType.equals("dam/components/video/profile")) {
                return path.substring("/etc/dam/video".length() + 1);
            }
            if (resourceType.endsWith("dam/components/video/s7profile")) {
                return path;
            }
        }
        return profileNode.getPath();
    }

    private String getResourceType(Node profileNode) throws RepositoryException {
        Node contentNode;
        String resourceType = null;
        if (profileNode.hasNode("jcr:content") && (contentNode = profileNode.getNode("jcr:content")).hasProperty("sling:resourceType")) {
            return contentNode.getProperty("sling:resourceType").getString();
        }
        return resourceType;
    }
}

