/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.api;

import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;

public class MCMUtil {
    public static String removePossibleJcrContent(String path) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith("/jcr:content")) {
            path = path.substring(0, path.length() - "/jcr:content".length());
        }
        return path;
    }

    public static <T> void writeMapAsJsonObject(JSONWriter out, Map<String, T> m) throws JSONException {
        out.object();
        for (String key : m.keySet()) {
            out.key(key).value(m.get(key));
        }
        out.endObject();
    }

    public static void addPossibleTagsToValues(Page aPage, Map<String, Object> values) throws JSONException {
        Tag[] tags = aPage.getTags();
        if (tags != null && tags.length > 0) {
            JSONArray tagsArray = new JSONArray();
            for (int i2 = 0; i2 < tags.length; ++i2) {
                JSONObject tag = new JSONObject();
                tag.put("title", tags[i2].getTitle());
                tag.put("id", tags[i2].getTagID());
                tagsArray.put(tag);
            }
            values.put("tags", tagsArray);
        }
    }

    public static void addPossibleSegmentsToValues(ValueMap content, Map<String, Object> values, ResourceResolver resourceResolver) throws JSONException {
        if (content.containsKey("cq:segments")) {
            JSONArray segArray = new JSONArray();
            if (content.get("cq:segments") instanceof String) {
                JSONObject seg = new JSONObject();
                seg.put("title", MCMUtil.getSegmentName(resourceResolver, content.get("cq:segments").toString()));
                seg.put("path", content.get("cq:segments").toString());
                segArray.put(seg);
            } else {
                for (String segment : content.get("cq:segments", new String[0])) {
                    JSONObject seg = new JSONObject();
                    seg.put("title", MCMUtil.getSegmentName(resourceResolver, segment));
                    seg.put("path", segment);
                    segArray.put(seg);
                }
            }
            values.put("segments", segArray);
        }
    }

    public static String getSegmentName(ResourceResolver resolver, String path) {
        Resource resource = resolver.getResource(path);
        if (resource == null || !resource.getResourceType().equals("cq:Page")) {
            return path;
        }
        Page page = resource.adaptTo(Page.class);
        return page.getTitle();
    }

    @Deprecated
    public static com.day.cq.security.User getUser(ResourceResolver rr, String userId) {
        com.day.cq.security.User retval = null;
        com.day.cq.security.UserManager userManager = rr.adaptTo(com.day.cq.security.UserManager.class);
        if (userManager == null) {
            throw new RuntimeException("Could not adapt resource resolver to UserManager.");
        }
        com.day.cq.security.Authorizable authorizable = userManager.get(userId);
        if (authorizable != null && authorizable.isUser()) {
            retval = (com.day.cq.security.User)authorizable;
        }
        return retval;
    }

    public static User getAuthorizedUser(ResourceResolver rr, String userId) {
        User retval = null;
        UserManager userManager = rr.adaptTo(UserManager.class);
        if (userManager == null) {
            throw new RuntimeException("Could not adapt resource resolver to UserManager.");
        }
        Authorizable authorizable = null;
        try {
            userManager.getAuthorizable(userId);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        if (authorizable != null && !authorizable.isGroup()) {
            retval = (User)authorizable;
        }
        return retval;
    }

    public static String getUserId(ResourceResolver rr, String userId) {
        String id = null;
        UserManager userManager = rr.adaptTo(UserManager.class);
        if (userManager == null) {
            throw new RuntimeException("Could not adapt resource resolver to UserManager.");
        }
        Authorizable authorizable = null;
        try {
            userManager.getAuthorizable(userId);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        if (authorizable != null && !authorizable.isGroup()) {
            try {
                id = authorizable.getPrincipal().getName();
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Could not fetch name for the given UserId : " + userId);
            }
        }
        return id;
    }

    public static boolean isAnExperience(Resource resource) {
        if (resource != null) {
            return ResourceUtil.isA(resource, "cq/personalization/components/teaserpage") || ResourceUtil.isA(resource, "cq/personalization/components/offerpage") || ResourceUtil.isA(resource, "mcm/components/newsletter/page") || ResourceUtil.isA(resource, "mcm/campaign/components/campaign_newsletterpage") || ResourceUtil.isA(resource, "wcm/designimporter/components/importerpage") || ResourceUtil.isA(resource, "commerce/components/voucher") || ResourceUtil.isA(resource, "commerce/components/promotion") || ResourceUtil.isA(resource, "cq/personalization/components/experiencepage");
        }
        return false;
    }
}

